/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.Implementation;
import net.java.ao.MethodImplWrapper;
import net.java.ao.RawEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImplementationWrapper<T extends RawEntity<?>> {
    private List<Object> implementations = new ArrayList<Object>();

    public ImplementationWrapper(T instance) {
        this.instantiateImplementation(instance, instance.getEntityType());
    }

    private void instantiateImplementation(T instance, Class<? extends RawEntity<?>> clazz) {
        Implementation implAnnotation = clazz.getAnnotation(Implementation.class);
        if (implAnnotation != null) {
            try {
                Constructor<?> con = implAnnotation.value().getConstructor(clazz);
                this.implementations.add(con.newInstance(instance));
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        for (Class<?> sup : clazz.getInterfaces()) {
            this.instantiateImplementation(instance, sup);
        }
    }

    public MethodImplWrapper getMethod(String name, Class<?> ... parameterTypes) {
        for (Object obj : this.implementations) {
            try {
                return new MethodImplWrapper(obj, obj.getClass().getMethod(name, parameterTypes));
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
        }
        return null;
    }
}

