/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.db;

import java.sql.Driver;
import net.java.ao.DatabaseProvider;
import net.java.ao.schema.ddl.DDLIndex;
import net.java.ao.types.DatabaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDatabaseProvider
extends DatabaseProvider {
    public MySQLDatabaseProvider(String uri, String username, String password) {
        super(uri, username, password);
    }

    @Override
    public Class<? extends Driver> getDriverClass() throws ClassNotFoundException {
        return Class.forName("com.mysql.jdbc.Driver");
    }

    @Override
    protected String convertTypeToString(DatabaseType<?> type) {
        switch (type.getType()) {
            case 2005: {
                return "TEXT";
            }
        }
        return super.convertTypeToString(type);
    }

    @Override
    protected String renderAutoIncrement() {
        return "AUTO_INCREMENT";
    }

    @Override
    protected String renderAppend() {
        return "ENGINE=InnoDB";
    }

    @Override
    protected String renderCreateIndex(DDLIndex index) {
        StringBuilder back = new StringBuilder("CREATE INDEX ");
        back.append(index.getName()).append(" ON ");
        back.append(index.getTable()).append('(').append(index.getField());
        if (index.getType().getType() == 2005 || index.getType().getType() == 12) {
            int defaultPrecision = index.getType().getDefaultPrecision();
            back.append('(').append(defaultPrecision > 0 ? defaultPrecision : 255).append(')');
        }
        back.append(')');
        return back.toString();
    }
}

