/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema.ddl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.java.ao.Common;
import net.java.ao.DatabaseProvider;
import net.java.ao.Query;
import net.java.ao.schema.ddl.DDLAction;
import net.java.ao.schema.ddl.DDLActionType;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLForeignKey;
import net.java.ao.schema.ddl.DDLIndex;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.types.TypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchemaReader {
    public static DDLTable[] readSchema(DatabaseProvider provider) throws SQLException {
        Connection conn = provider.getConnection();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet res = provider.getTables(conn);
        TypeManager manager = TypeManager.getInstance();
        if (res == null) {
            return new DDLTable[0];
        }
        ArrayList<DDLTable> tables = new ArrayList<DDLTable>();
        while (res.next()) {
            DDLTable table = new DDLTable();
            table.setName(res.getString("TABLE_NAME"));
            tables.add(table);
        }
        res.close();
        for (DDLTable table : tables) {
            Query query = Query.select("*").from(table.getName()).limit(1);
            String sql = provider.renderQuery(query, null, false);
            PreparedStatement stmt = conn.prepareStatement(sql);
            provider.setQueryStatementProperties(stmt, query);
            res = stmt.executeQuery();
            HashMap<String, DDLField> fields = new HashMap<String, DDLField>();
            ResultSetMetaData rsmd = res.getMetaData();
            for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
                DDLField field = new DDLField();
                field.setName(rsmd.getColumnName(i));
                field.setType(manager.getType(rsmd.getColumnType(i)));
                field.setPrecision(rsmd.getPrecision(i));
                field.setScale(rsmd.getScale(i));
                field.setAutoIncrement(rsmd.isAutoIncrement(i));
                field.setNotNull(rsmd.isNullable(i) == 0);
                fields.put(field.getName(), field);
            }
            res.close();
            res = dbmd.getColumns(null, null, table.getName(), null);
            while (res.next()) {
                DDLField field = (DDLField)fields.get(res.getString("COLUMN_NAME"));
                field.setDefaultValue(provider.parseValue(field.getType().getType(), res.getString("COLUMN_DEF")));
                field.setNotNull(res.getString("IS_NULLABLE").equals("NO"));
            }
            res.close();
            res = dbmd.getPrimaryKeys(null, null, table.getName());
            while (res.next()) {
                DDLField field = (DDLField)fields.get(res.getString("COLUMN_NAME"));
                field.setPrimaryKey(true);
            }
            res.close();
            ArrayList<DDLForeignKey> foreignKeys = new ArrayList<DDLForeignKey>();
            res = dbmd.getImportedKeys(null, null, table.getName());
            while (res.next()) {
                DDLForeignKey key = new DDLForeignKey();
                key.setForeignField(res.getString("PKCOLUMN_NAME"));
                key.setField(res.getString("FKCOLUMN_NAME"));
                key.setTable(res.getString("PKTABLE_NAME"));
                key.setDomesticTable(table.getName());
                foreignKeys.add(key);
            }
            res.close();
            table.setFields(fields.values().toArray(new DDLField[fields.size()]));
            table.setForeignKeys(foreignKeys.toArray(new DDLForeignKey[foreignKeys.size()]));
        }
        return tables.toArray(new DDLTable[tables.size()]);
    }

    public static DDLAction[] diffSchema(DDLTable[] fromArray, DDLTable[] ontoArray) {
        HashSet<DDLAction> actions = new HashSet<DDLAction>();
        ArrayList<DDLTable> createTables = new ArrayList<DDLTable>();
        ArrayList<DDLTable> dropTables = new ArrayList<DDLTable>();
        ArrayList<DDLTable> alterTables = new ArrayList<DDLTable>();
        HashMap<String, DDLTable> from = new HashMap<String, DDLTable>();
        HashMap<String, DDLTable> onto = new HashMap<String, DDLTable>();
        for (DDLTable table : fromArray) {
            from.put(table.getName().toLowerCase(), table);
        }
        for (DDLTable table : ontoArray) {
            onto.put(table.getName().toLowerCase(), table);
        }
        for (DDLTable table : fromArray) {
            if (onto.containsKey(table.getName().toLowerCase())) {
                alterTables.add(table);
                continue;
            }
            createTables.add(table);
        }
        for (DDLTable table : ontoArray) {
            if (from.containsKey(table.getName().toLowerCase())) continue;
            dropTables.add(table);
        }
        for (DDLTable table : createTables) {
            DDLAction action = new DDLAction(DDLActionType.CREATE);
            action.setTable(table);
            actions.add(action);
        }
        for (DDLTable table : dropTables) {
            DDLAction action = new DDLAction(DDLActionType.DROP);
            action.setTable(table);
            actions.add(action);
        }
        for (DDLTable fromTable : alterTables) {
            DDLTable ontoTable = (DDLTable)onto.get(fromTable.getName().toLowerCase());
            ArrayList<DDLField> createFields = new ArrayList<DDLField>();
            ArrayList<DDLField> dropFields = new ArrayList<DDLField>();
            ArrayList<DDLField> alterFields = new ArrayList<DDLField>();
            HashMap<String, DDLField> fromFields = new HashMap<String, DDLField>();
            HashMap<String, DDLField> ontoFields = new HashMap<String, DDLField>();
            for (DDLField field : fromTable.getFields()) {
                fromFields.put(field.getName().toLowerCase(), field);
            }
            for (DDLField field : ontoTable.getFields()) {
                ontoFields.put(field.getName().toLowerCase(), field);
            }
            for (DDLField field : fromTable.getFields()) {
                if (ontoFields.containsKey(field.getName().toLowerCase())) {
                    alterFields.add(field);
                    continue;
                }
                createFields.add(field);
            }
            for (DDLField field : ontoTable.getFields()) {
                if (fromFields.containsKey(field.getName().toLowerCase())) continue;
                dropFields.add(field);
            }
            for (DDLField field : createFields) {
                DDLAction action = new DDLAction(DDLActionType.ALTER_ADD_COLUMN);
                action.setTable(fromTable);
                action.setField(field);
                actions.add(action);
            }
            for (DDLField field : dropFields) {
                DDLAction action = new DDLAction(DDLActionType.ALTER_DROP_COLUMN);
                action.setTable(fromTable);
                action.setField(field);
                actions.add(action);
            }
            for (DDLField fromField : alterFields) {
                DDLField ontoField = (DDLField)ontoFields.get(fromField.getName().toLowerCase());
                if (fromField.getDefaultValue() == null && ontoField.getDefaultValue() != null) {
                    actions.add(SchemaReader.createColumnAlterAction(fromTable, ontoField, fromField));
                    continue;
                }
                if (fromField.getDefaultValue() != null && !Common.fuzzyCompare(fromField.getDefaultValue(), ontoField.getDefaultValue())) {
                    actions.add(SchemaReader.createColumnAlterAction(fromTable, ontoField, fromField));
                    continue;
                }
                if (!Common.fuzzyTypeCompare(fromField.getType().getType(), ontoField.getType().getType())) {
                    actions.add(SchemaReader.createColumnAlterAction(fromTable, ontoField, fromField));
                    continue;
                }
                if (fromField.isAutoIncrement() == ontoField.isAutoIncrement()) continue;
                actions.add(SchemaReader.createColumnAlterAction(fromTable, ontoField, fromField));
            }
            ArrayList<DDLForeignKey> addKeys = new ArrayList<DDLForeignKey>();
            ArrayList<DDLForeignKey> dropKeys = new ArrayList<DDLForeignKey>();
            for (DDLForeignKey fromKey : fromTable.getForeignKeys()) {
                for (DDLForeignKey ontoKey : ontoTable.getForeignKeys()) {
                    if (fromKey.getTable().equalsIgnoreCase(ontoKey.getTable()) && fromKey.getForeignField().equalsIgnoreCase(ontoKey.getForeignField()) || !fromKey.getField().equalsIgnoreCase(ontoKey.getField()) || !fromKey.getDomesticTable().equalsIgnoreCase(ontoKey.getDomesticTable())) continue;
                    addKeys.add(fromKey);
                }
            }
            for (DDLForeignKey ontoKey : ontoTable.getForeignKeys()) {
                for (DDLForeignKey fromKey : fromTable.getForeignKeys()) {
                    if (ontoKey.getTable().equalsIgnoreCase(fromKey.getTable()) && ontoKey.getForeignField().equalsIgnoreCase(fromKey.getForeignField()) || !ontoKey.getField().equalsIgnoreCase(fromKey.getField()) || !ontoKey.getDomesticTable().equalsIgnoreCase(fromKey.getDomesticTable())) continue;
                    dropKeys.add(ontoKey);
                }
            }
            for (DDLForeignKey key : addKeys) {
                DDLAction action = new DDLAction(DDLActionType.ALTER_ADD_KEY);
                action.setKey(key);
                actions.add(action);
            }
            for (DDLForeignKey key : dropKeys) {
                DDLAction action = new DDLAction(DDLActionType.ALTER_DROP_KEY);
                action.setKey(key);
                actions.add(action);
            }
        }
        return actions.toArray(new DDLAction[actions.size()]);
    }

    public static DDLAction[] sortTopologically(DDLAction[] actions) {
        LinkedList<DDLAction> back = new LinkedList<DDLAction>();
        HashMap<DDLAction, Set<DDLAction>> deps = new HashMap<DDLAction, Set<DDLAction>>();
        HashSet<DDLAction> roots = new HashSet<DDLAction>();
        SchemaReader.performSort(actions, deps, roots);
        while (!roots.isEmpty()) {
            DDLAction[] rootsArray = roots.toArray(new DDLAction[roots.size()]);
            roots.remove(rootsArray[0]);
            back.add(rootsArray[0]);
            LinkedList<DDLAction> toRemove = new LinkedList<DDLAction>();
            for (DDLAction depAction : deps.keySet()) {
                Set individualDeps = (Set)deps.get(depAction);
                individualDeps.remove(rootsArray[0]);
                if (!individualDeps.isEmpty()) continue;
                roots.add(depAction);
                toRemove.add(depAction);
            }
            for (DDLAction action : toRemove) {
                deps.remove(action);
            }
        }
        return back.toArray(new DDLAction[back.size()]);
    }

    private static void performSort(DDLAction[] actions, Map<DDLAction, Set<DDLAction>> deps, Set<DDLAction> roots) {
        DDLForeignKey key;
        LinkedList<DDLAction> dropKeys = new LinkedList<DDLAction>();
        LinkedList<DDLAction> dropIndexes = new LinkedList<DDLAction>();
        LinkedList<DDLAction> dropColumns = new LinkedList<DDLAction>();
        LinkedList<DDLAction> changeColumns = new LinkedList<DDLAction>();
        LinkedList<DDLAction> drops = new LinkedList<DDLAction>();
        LinkedList<DDLAction> creates = new LinkedList<DDLAction>();
        LinkedList<DDLAction> addColumns = new LinkedList<DDLAction>();
        LinkedList<DDLAction> addKeys = new LinkedList<DDLAction>();
        LinkedList<DDLAction> createIndexes = new LinkedList<DDLAction>();
        block11: for (DDLAction action : actions) {
            switch (action.getActionType()) {
                case ALTER_DROP_KEY: {
                    dropKeys.add(action);
                    continue block11;
                }
                case DROP_INDEX: {
                    dropIndexes.add(action);
                    continue block11;
                }
                case ALTER_DROP_COLUMN: {
                    dropColumns.add(action);
                    continue block11;
                }
                case ALTER_CHANGE_COLUMN: {
                    changeColumns.add(action);
                    continue block11;
                }
                case DROP: {
                    drops.add(action);
                    continue block11;
                }
                case CREATE: {
                    creates.add(action);
                    continue block11;
                }
                case ALTER_ADD_COLUMN: {
                    addColumns.add(action);
                    continue block11;
                }
                case ALTER_ADD_KEY: {
                    addKeys.add(action);
                    continue block11;
                }
                case CREATE_INDEX: {
                    createIndexes.add(action);
                }
            }
        }
        roots.addAll(dropKeys);
        roots.addAll(dropIndexes);
        for (DDLAction action : dropColumns) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            for (DDLAction depAction : dropKeys) {
                key = depAction.getKey();
                if ((!key.getTable().equals(action.getTable().getName()) || !key.getForeignField().equals(action.getField().getName())) && (!key.getDomesticTable().equals(action.getTable().getName()) || !key.getField().equals(action.getField().getName()))) continue;
                dependencies.add(depAction);
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
        for (DDLAction action : changeColumns) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            for (DDLAction depAction : dropKeys) {
                key = depAction.getKey();
                if ((!key.getTable().equals(action.getTable().getName()) || !key.getForeignField().equals(action.getField().getName())) && (!key.getDomesticTable().equals(action.getTable().getName()) || !key.getField().equals(action.getField().getName()))) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : dropColumns) {
                if ((!depAction.getTable().equals(action.getTable()) || !depAction.getField().equals(action.getField())) && (!depAction.getTable().equals(action.getTable()) || !depAction.getField().equals(action.getOldField()))) continue;
                dependencies.add(depAction);
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
        for (DDLAction action : drops) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            for (DDLAction depAction : dropKeys) {
                key = depAction.getKey();
                if (!key.getTable().equals(action.getTable().getName()) && !key.getDomesticTable().equals(action.getTable().getName())) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : dropColumns) {
                if (!depAction.getTable().equals(action.getTable())) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : changeColumns) {
                if (!depAction.getTable().equals(action.getTable())) continue;
                dependencies.add(depAction);
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
        for (DDLAction action : creates) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            for (DDLForeignKey key2 : action.getTable().getForeignKeys()) {
                for (DDLAction depAction : creates) {
                    if (depAction == action || !depAction.getTable().getName().equals(key2.getTable())) continue;
                    dependencies.add(depAction);
                }
                for (DDLAction depAction : addColumns) {
                    if (!depAction.getTable().getName().equals(key2.getTable()) || !depAction.getField().getName().equals(key2.getForeignField())) continue;
                    dependencies.add(depAction);
                }
                for (DDLAction depAction : changeColumns) {
                    if (!depAction.getTable().getName().equals(key2.getTable()) || !depAction.getField().getName().equals(key2.getForeignField())) continue;
                    dependencies.add(depAction);
                }
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
        for (DDLAction action : addColumns) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            for (DDLAction depAction : creates) {
                if (!depAction.getTable().equals(action.getTable())) continue;
                dependencies.add(depAction);
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
        for (DDLAction action : addKeys) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            DDLForeignKey key3 = action.getKey();
            for (DDLAction depAction : creates) {
                if (!depAction.getTable().getName().equals(key3.getTable()) && !depAction.getTable().getName().equals(key3.getDomesticTable())) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : addColumns) {
                if ((!depAction.getTable().getName().equals(key3.getTable()) || !depAction.getField().getName().equals(key3.getForeignField())) && (!depAction.getTable().getName().equals(key3.getDomesticTable()) || !depAction.getField().getName().equals(key3.getField()))) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : changeColumns) {
                if ((!depAction.getTable().getName().equals(key3.getTable()) || !depAction.getField().getName().equals(key3.getForeignField())) && (!depAction.getTable().getName().equals(key3.getDomesticTable()) || !depAction.getField().getName().equals(key3.getField()))) continue;
                dependencies.add(depAction);
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
        for (DDLAction action : createIndexes) {
            HashSet<DDLAction> dependencies = new HashSet<DDLAction>();
            DDLIndex index = action.getIndex();
            for (DDLAction depAction : creates) {
                if (!depAction.getTable().getName().equals(index.getTable())) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : addColumns) {
                if (!depAction.getTable().getName().equals(index.getTable()) && !depAction.getField().getName().equals(index.getField())) continue;
                dependencies.add(depAction);
            }
            for (DDLAction depAction : changeColumns) {
                if (!depAction.getTable().getName().equals(index.getTable()) && !depAction.getField().getName().equals(index.getField())) continue;
                dependencies.add(depAction);
            }
            if (dependencies.size() == 0) {
                roots.add(action);
                continue;
            }
            deps.put(action, dependencies);
        }
    }

    private static DDLAction createColumnAlterAction(DDLTable table, DDLField oldField, DDLField field) {
        DDLAction action = new DDLAction(DDLActionType.ALTER_CHANGE_COLUMN);
        action.setTable(table);
        action.setField(field);
        action.setOldField(oldField);
        return action;
    }
}

