/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.types;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.java.ao.EntityManager;
import net.java.ao.types.DatabaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DateDateType
extends DatabaseType<Date> {
    public DateDateType() {
        super(91, -1, Date.class);
    }

    @Override
    public String getDefaultName() {
        return "DATE";
    }

    @Override
    public void putToDatabase(int index, PreparedStatement stmt, Date value) throws SQLException {
        stmt.setDate(index, new java.sql.Date(value.getTime()));
    }

    @Override
    public Date pullFromDatabase(EntityManager manager, ResultSet res, Class<? extends Date> type, String field) throws SQLException {
        return res.getDate(field);
    }

    @Override
    public Date defaultParseValue(String value) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(value);
        }
        catch (ParseException parseException) {
            return new Date();
        }
    }
}

