/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.types;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.java.ao.EntityManager;
import net.java.ao.types.DatabaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DateType
extends DatabaseType<Calendar> {
    public DateType() {
        super(91, -1, Calendar.class);
    }

    @Override
    public String getDefaultName() {
        return "DATE";
    }

    @Override
    public void putToDatabase(int index, PreparedStatement stmt, Calendar value) throws SQLException {
        stmt.setDate(index, new Date(value.getTimeInMillis()));
    }

    @Override
    public Calendar pullFromDatabase(EntityManager manager, ResultSet res, Class<? extends Calendar> type, String field) throws SQLException {
        Calendar back = Calendar.getInstance();
        back.setTime(res.getDate(field));
        return back;
    }

    @Override
    public Calendar defaultParseValue(String value) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(value));
            return cal;
        }
        catch (ParseException parseException) {
            return Calendar.getInstance();
        }
    }
}

