/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derbyTesting.functionTests.harness.BackgroundStreamDrainer;
import org.apache.derbyTesting.functionTests.harness.CurrentTime;
import org.apache.derbyTesting.functionTests.harness.HandleResult;
import org.apache.derbyTesting.functionTests.harness.JavaVersionHolder;
import org.apache.derbyTesting.functionTests.harness.ManageSysProps;
import org.apache.derbyTesting.functionTests.harness.RunTest;
import org.apache.derbyTesting.functionTests.harness.SpecialFlags;
import org.apache.derbyTesting.functionTests.harness.UnJar;
import org.apache.derbyTesting.functionTests.harness.jvm;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class RunList {
    static String jvmName = "currentjvm";
    static String javaCmd = "java";
    static String javaArgs;
    static jvm jvm;
    static String javaVersion;
    static String majorVersion;
    static String minorVersion;
    static String jversion;
    static int iminor;
    static int imajor;
    static boolean skip;
    static boolean driverNotFound;
    static boolean needSync;
    static boolean needJdk12;
    static boolean needJdk12ext;
    static boolean excludedFromJCC;
    static String clientExclusionMessage;
    static Boolean needIBMjvm;
    static boolean needEncryption;
    static String jvmflags;
    static String testJavaFlags;
    static String classpath;
    static String classpathServer;
    static String framework;
    static String usesystem;
    static String upgradetest;
    static String jarfile;
    static String useoutput;
    static String keepfiles;
    static String encryption;
    static String testEncryptionProvider;
    static String testEncryptionAlgorithm;
    static String jdk12test;
    static String jdk12exttest;
    static String runwithibmjvm;
    static String runwithj9;
    static String runwithjvm;
    static String excludeJCC;
    static boolean useprocess;
    static String skipsed;
    static boolean fw_set;
    static String systemdiff;
    static String suiteName;
    static String fullsuiteName;
    static String topSuiteName;
    static String topParentSuite;
    static String topSpecialProps;
    static String otherSpecialProps;
    static String ijdefaultResourcePackage;
    static String outcopy;
    static String userdir;
    static String mtestdir;
    static boolean verbose;
    static String reportstderr;
    static String timeout;
    static String shutdownurl;
    static PrintWriter pwOut;
    static String outputdir;
    static String topsuitedir;
    static String topreportdir;
    static String canondir;
    static String bootcp;
    static String serverJvm;
    static String serverJvmName;
    static File outDir;
    static File outFile;
    static File runDir;
    static File runFile;
    static Properties suiteProperties;
    static Properties specialProperties;
    static BufferedReader runlistFile;
    static String hostName;
    static String testEncoding;
    static String upgradejarpath;
    static String derbyTestingXaSingle;
    static String[] clientExclusionKeywords;

    public RunList() {
    }

    public RunList(Vector suitesToRun, File runDir, File outDir, PrintWriter pwOut, Properties suiteProperties, Properties specialProperties, String topParentSuite) throws ClassNotFoundException, IOException, Exception {
        RunList.runDir = runDir;
        RunList.outDir = outDir;
        RunList.pwOut = pwOut;
        RunList.suiteProperties = suiteProperties;
        RunList.specialProperties = specialProperties;
        topSuiteName = suiteProperties.getProperty("suitename");
        RunList.topParentSuite = topParentSuite;
        RunList.runSuites(suitesToRun);
    }

    private static void runSuites(Vector suitesToRun) throws ClassNotFoundException, FileNotFoundException, IOException, Exception {
        String suiteName = "";
        userdir = System.getProperty("user.dir");
        Properties p = null;
        RunList.setTopSuiteProperties();
        Properties topParentSuiteProps = RunList.locateSuiteProperties(topParentSuite, suiteProperties, true, true);
        RunList.setSuiteProperties(topParentSuiteProps, topParentSuite, suiteProperties, true, true);
        for (int i = 0; i < suitesToRun.size(); ++i) {
            Properties subProps = null;
            fullsuiteName = (String)suitesToRun.elementAt(i);
            String subSuite = fullsuiteName.substring(0, fullsuiteName.lastIndexOf(":"));
            subProps = !subSuite.equals(topParentSuite) ? RunList.locateSuiteProperties(subSuite, topParentSuiteProps, true, false) : topParentSuiteProps;
            RunList.setSuiteProperties(subProps, subSuite, topParentSuiteProps, true, false);
            suiteName = fullsuiteName.substring(fullsuiteName.lastIndexOf(":") + 1);
            p = RunList.locateSuiteProperties(suiteName, subProps, false, false);
            RunList.setSuiteProperties(p, suiteName, subProps, false, false);
            String runfile = "suites/" + suiteName + ".runall";
            InputStream is = RunTest.loadTestResource(runfile);
            if (is == null) {
                is = RunTest.loadTestResource(userdir + '/' + suiteName + ".runall");
            }
            if (is == null) {
                System.out.println("Suite runall file not found for " + suiteName);
                continue;
            }
            runlistFile = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            if (runlistFile == null) {
                System.out.println("The suite runall file could not be read.");
                continue;
            }
            String startTime = CurrentTime.getTime();
            pwOut.println("**** Start SubSuite: " + fullsuiteName + " jdk" + javaVersion + " " + startTime + " ****");
            if (framework != null && framework.length() > 0) {
                pwOut.println("Framework: " + framework);
            } else {
                pwOut.println("Framework: No special framework.");
            }
            File f = new File(outDir, topSuiteName);
            File skipFile = new File(f, topSuiteName + ".skip");
            PrintStream ps = null;
            try {
                ps = new PrintStream(new FileOutputStream(skipFile.getCanonicalPath(), true));
            }
            catch (IOException e) {
                FileWriter fw = new FileWriter(skipFile);
                fw.close();
                ps = new PrintStream(new FileOutputStream(skipFile.getCanonicalPath(), true));
            }
            if (!useprocess) {
                RunList.unloadEmbeddedDriver();
            }
            System.out.println("Now run the suite's tests");
            if (skip) {
                RunList.addToSkipFile(topSuiteName + ":" + fullsuiteName, ps);
                if (driverNotFound) {
                    pwOut.println("Cannot run the suite, framework driver not found");
                } else if (needSync) {
                    pwOut.println("Cannot run the suite, sync product not found");
                } else if (needJdk12ext) {
                    pwOut.println("Cannot run the suite, requires jdk12 or higher with extensions");
                } else if (needJdk12) {
                    pwOut.println("Cannot run the suite, requires jdk12 or higher, have jdk" + javaVersion);
                } else if (excludedFromJCC) {
                    pwOut.println(clientExclusionMessage);
                } else if (needIBMjvm == null || !needIBMjvm.booleanValue()) {
                    pwOut.println("Cannot run the suite, requires IBM jvm, jvm vendor is " + System.getProperty("java.vendor"));
                } else {
                    pwOut.println("Cannot run the suite, have jdk" + javaVersion);
                }
            } else {
                System.out.println("Run the tests...");
                if (jarfile != null) {
                    UnJar uj = new UnJar();
                    UnJar.unjar(jarfile, outDir.getCanonicalPath(), true);
                    if (upgradetest.equals("true") && suiteName.startsWith("convert")) {
                        String tmpname = jarfile.substring(0, jarfile.indexOf("JAR"));
                        File tmp = new File(outDir, tmpname);
                        File convert = new File(outDir, usesystem);
                        boolean renamed = tmp.renameTo(convert);
                    }
                }
                RunList.runTests(p, fullsuiteName);
            }
            String endTime = CurrentTime.getTime();
            pwOut.println("**** End SubSuite: " + fullsuiteName + " jdk" + javaVersion + " " + endTime + " ****");
            ps.close();
        }
    }

    private static void runTests(Properties suiteProps, String suite) throws IOException, Exception {
        ManageSysProps.saveSysProps();
        StringBuffer sb = new StringBuffer();
        jvm = org.apache.derbyTesting.functionTests.harness.jvm.getJvm(jvmName);
        Vector<String> jvmProps = new Vector<String>();
        if (javaCmd.length() > 0) {
            jvm.setJavaCmd(javaCmd);
            jvmProps.addElement("javaCmd=" + javaCmd);
        }
        if (testJavaFlags != null && testJavaFlags.length() > 0) {
            jvmProps.addElement("testJavaFlags=" + testJavaFlags);
        }
        if (classpath != null) {
            jvmProps.addElement("classpath=" + classpath);
        }
        if (classpathServer != null) {
            jvmProps.addElement("classpathServer=" + classpathServer);
        }
        if (jversion != null) {
            jvmProps.addElement("jvm=" + jversion);
        }
        if (framework != null) {
            jvmProps.addElement("framework=" + framework);
        }
        if (usesystem != null) {
            jvmProps.addElement("usesystem=" + usesystem);
        }
        if (shutdownurl != null) {
            jvmProps.addElement("shutdownurl=" + shutdownurl);
        }
        if (upgradetest != null) {
            jvmProps.addElement("upgradetest=" + upgradetest);
        }
        if (outcopy != null) {
            jvmProps.addElement("outcopy=" + outcopy);
        }
        if (useoutput != null) {
            jvmProps.addElement("useoutput=" + useoutput);
        }
        if (verbose) {
            jvmProps.addElement("verbose=true");
        }
        if (reportstderr != null && reportstderr.length() > 0) {
            jvmProps.addElement("reportstderr=" + reportstderr);
        }
        if (jvmflags != null && jvmflags.length() > 0) {
            jvmProps.addElement("jvmflags=" + jvmflags);
        }
        if (timeout != null && timeout.length() > 0) {
            if (useprocess) {
                jvmProps.addElement("timeout=" + timeout);
            } else {
                RunTest.timeoutStr = timeout;
            }
        }
        if (Boolean.getBoolean("listOnly")) {
            jvmProps.addElement("listOnly=true");
        }
        if (encryption != null) {
            jvmProps.addElement("encryption=" + encryption);
        }
        if (testEncryptionProvider != null) {
            jvmProps.addElement("testEncryptionProvider=" + testEncryptionProvider);
        }
        if (testEncryptionAlgorithm != null) {
            jvmProps.addElement("testEncryptionAlgorithm=" + testEncryptionAlgorithm);
        }
        if (jdk12test != null) {
            jvmProps.addElement("jdk12test=" + jdk12test);
        }
        if (jdk12exttest != null) {
            jvmProps.addElement("jdk12exttest=" + jdk12exttest);
        }
        if (keepfiles != null) {
            jvmProps.addElement("keepfiles=" + keepfiles);
        }
        if (outputdir != null && outputdir.length() > 0) {
            jvmProps.addElement("outputdir=" + outputdir);
        }
        if (topsuitedir != null && topsuitedir.length() > 0) {
            jvmProps.addElement("topsuitedir=" + topsuitedir);
        } else {
            jvmProps.addElement("topsuitedir=" + outputdir);
        }
        if (topreportdir != null) {
            jvmProps.addElement("topreportdir=" + topreportdir);
        } else {
            jvmProps.addElement("topreprtdir=" + topsuitedir);
        }
        if (runDir != null && runDir.exists()) {
            jvmProps.addElement("rundir=" + runDir.getCanonicalPath());
        }
        if (bootcp != null && bootcp.length() > 0) {
            jvmProps.addElement("bootcp=" + bootcp);
        }
        if (serverJvm != null && serverJvm.length() > 0) {
            jvmProps.addElement("serverJvm=" + serverJvm);
        }
        if (serverJvmName != null && serverJvmName.length() > 0) {
            jvmProps.addElement("serverJvmName=" + serverJvmName);
        }
        if (testEncoding != null) {
            jvmProps.addElement("derbyTesting.encoding=" + testEncoding);
        }
        if (upgradejarpath != null) {
            jvmProps.addElement("derbyTesting.jar.path=" + upgradejarpath);
        }
        if (hostName != null && hostName.length() > 0) {
            jvmProps.addElement("hostName=" + hostName);
        }
        if (!useprocess) {
            jvmProps.addElement("useprocess=false");
        }
        if (skipsed.equals("true")) {
            jvmProps.addElement("skipsed=true");
        }
        if (systemdiff != null) {
            jvmProps.addElement("systemdiff=" + systemdiff);
        }
        if (ijdefaultResourcePackage != null) {
            jvmProps.addElement("ij.defaultResourcePackage=" + ijdefaultResourcePackage);
        }
        if (mtestdir != null) {
            jvmProps.addElement("mtestdir=" + mtestdir);
        }
        if (topSpecialProps.length() > 0) {
            jvmProps.addElement("testSpecialProps=" + topSpecialProps + (otherSpecialProps.length() > 0 ? "^" + otherSpecialProps : ""));
        } else if (otherSpecialProps.length() > 0) {
            jvmProps.addElement("testSpecialProps=" + otherSpecialProps);
        }
        if (derbyTestingXaSingle != null) {
            jvmProps.addElement("derbyTesting.xa.single=" + derbyTestingXaSingle);
        }
        Properties sysProps = System.getProperties();
        Enumeration<Object> e = sysProps.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("ij.dataSource")) continue;
            jvmProps.addElement(key + "=" + sysProps.getProperty(key));
        }
        jvmProps.addElement("suitename=" + suite);
        if (topSuiteName != null && topSuiteName.length() > 0) {
            jvmProps.addElement("topsuitename=" + topSuiteName);
        }
        if (classpath != null) {
            jvm.setClasspath(classpath);
        }
        jvm.setD(jvmProps);
        Vector v = jvm.getCommandLine();
        v.addElement("org.apache.derbyTesting.functionTests.harness.RunTest");
        String str = "";
        String lastTest = null;
        String skipTo = System.getProperties().getProperty("skipToFile");
        String stopAfter = System.getProperties().getProperty("stopAfterFile");
        while ((str = runlistFile.readLine()) != null) {
            block60: {
                if (skipTo != null && !str.equals(skipTo)) continue;
                skipTo = null;
                if (stopAfter != null && lastTest != null && lastTest.equals(stopAfter)) break;
                String[] testCmd = new String[v.size() + 1];
                StringBuffer verboseSb = new StringBuffer();
                int i = 0;
                for (i = 0; i < v.size(); ++i) {
                    testCmd[i] = (String)v.elementAt(i);
                    verboseSb.append(testCmd[i] + " ");
                }
                testCmd[i++] = str;
                verboseSb.append(str + " ");
                String uc = System.getProperties().getProperty("useCommonDB");
                if (uc == null) {
                    uc = "false";
                }
                if (useprocess && !uc.equals("true")) {
                    System.out.println("Execute command: " + verboseSb.toString());
                    Process pr = null;
                    try {
                        pr = Runtime.getRuntime().exec(testCmd);
                        BackgroundStreamDrainer stdout = new BackgroundStreamDrainer(pr.getInputStream(), null);
                        BackgroundStreamDrainer stderr = new BackgroundStreamDrainer(pr.getErrorStream(), null);
                        pr.waitFor();
                        String result = HandleResult.handleResult(pr.exitValue(), stdout.getData(), stderr.getData(), pwOut, testEncoding);
                        pr.destroy();
                    }
                    catch (Throwable t) {
                        System.out.println("Process exception: " + t.getMessage());
                        if (pr == null) break block60;
                        pr.destroy();
                        pr = null;
                    }
                } else {
                    String[] args = new String[]{str, ijdefaultResourcePackage != null ? ijdefaultResourcePackage : "/org/apache/derbyTesting/functionTests/", usesystem != null ? usesystem : "", "noprocess", shutdownurl != null ? shutdownurl : "", suite, framework};
                    RunTest.main(args);
                    String tmp = str.substring(str.indexOf("/") + 1, str.lastIndexOf("."));
                    String diffname = tmp + "." + "diff";
                    File diffFile = new File(outDir, diffname);
                    if (diffFile != null && diffFile.exists()) {
                        BufferedReader inFile = new BufferedReader(new FileReader(diffFile));
                        String diffLine = "";
                        while ((diffLine = inFile.readLine()) != null) {
                            pwOut.println(diffLine);
                        }
                    }
                }
            }
            ManageSysProps.resetSysProps();
            lastTest = str;
        }
        if (!useprocess && framework != null && framework.startsWith("DerbyNet")) {
            try {
                String stopCmd = javaCmd + " org.apache.derby.drda.NetworkServerControl shutdown";
                Process prstop = Runtime.getRuntime().exec(stopCmd);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public static Properties locateSuiteProperties(String suiteName, Properties parentProps, boolean isParent, boolean isTop) throws ClassNotFoundException, IOException, Exception {
        String suitePropsName = "suites/" + suiteName + ".properties";
        InputStream is = RunTest.loadTestResource(suitePropsName);
        if (is == null) {
            suitePropsName = userdir + '/' + suiteName + ".properties";
            is = RunTest.loadTestResource(suitePropsName);
        }
        Properties p = new Properties();
        if (isParent) {
            usesystem = null;
            upgradetest = null;
            jarfile = null;
            outcopy = null;
            useoutput = null;
            mtestdir = null;
            skipsed = "false";
        }
        if (is != null) {
            p.load(is);
            is = null;
        } else {
            testEncoding = parentProps.getProperty("derbyTesting.encoding");
            upgradejarpath = parentProps.getProperty("derbyTesting.jar.path");
            framework = parentProps.getProperty("framework");
            serverJvm = parentProps.getProperty("serverJvm");
            serverJvmName = parentProps.getProperty("serverJvmName");
            ijdefaultResourcePackage = parentProps.getProperty("ij.defaultResourcePackage");
            encryption = parentProps.getProperty("encryption");
            testEncryptionProvider = parentProps.getProperty("testEncryptionProvider");
            testEncryptionAlgorithm = parentProps.getProperty("testEncryptionAlgorithm");
            jdk12test = parentProps.getProperty("jdk12test");
            jdk12exttest = parentProps.getProperty("jdk12exttest");
            runwithj9 = parentProps.getProperty("runwithj9");
            runwithibmjvm = parentProps.getProperty("runwithibmjvm");
            String testJVM = jvmName;
            if (jvmName.startsWith("j9") && !jvmName.startsWith("j9dee")) {
                testJVM = jvmName.startsWith("j9_foundation") ? "foundation" : "j9";
            }
            runwithjvm = parentProps.getProperty("runwith" + testJVM);
            excludeJCC = parentProps.getProperty("excludeJCC");
        }
        return p;
    }

    private static void setTopSuiteProperties() throws ClassNotFoundException, IOException {
        framework = suiteProperties.getProperty("framework");
        jversion = suiteProperties.getProperty("jversion");
        jvmName = suiteProperties.getProperty("jvm");
        String j9config = System.getProperty("com.ibm.oti.configuration");
        if (j9config != null) {
            if (j9config.equals("foun10")) {
                jvmName = "j9_foundation";
            } else if (j9config.equals("foun11")) {
                jvmName = "j9_foundation11";
            } else if (j9config.equals("max")) {
                jvmName = "j9_13";
            } else if (j9config.equals("dee")) {
                jvmName = "j9dee15";
            }
        }
        javaVersion = jversion == null ? System.getProperty("java.version") : jversion;
        javaCmd = suiteProperties.getProperty("javaCmd");
        if (javaCmd == null) {
            javaCmd = "java";
        } else if (javaCmd.equals("jview")) {
            jvmName = "jview";
        }
        String javavmVersion = System.getProperty("java.vm.name").equals("J9") ? System.getProperty("java.vm.version") : javaVersion;
        JavaVersionHolder jvh = new JavaVersionHolder(javavmVersion);
        majorVersion = jvh.getMajorVersion();
        minorVersion = jvh.getMinorVersion();
        iminor = jvh.getMinorNumber();
        imajor = jvh.getMajorNumber();
        if (jvmName == null || jvmName.equals("jview")) {
            jvmName = iminor < 2 && imajor < 2 ? "currentjvm" : "jdk" + majorVersion + minorVersion;
        }
        if (jvmName.equals("j9_13")) {
            javaVersion = javaVersion + " - " + majorVersion + "." + minorVersion;
            System.out.println("javaVersion now: " + javaVersion);
            if (imajor <= 2 && iminor < 2) {
                majorVersion = "1";
                minorVersion = "3";
                imajor = 1;
                iminor = 3;
            } else {
                jvmName = "j9_" + majorVersion + minorVersion;
            }
        }
        jvmflags = suiteProperties.getProperty("jvmflags");
        testJavaFlags = suiteProperties.getProperty("testJavaFlags");
        classpath = suiteProperties.getProperty("classpath");
        classpathServer = suiteProperties.getProperty("classpathServer");
        usesystem = suiteProperties.getProperty("usesystem");
        upgradetest = suiteProperties.getProperty("upgradetest");
        outcopy = suiteProperties.getProperty("outcopy");
        useoutput = suiteProperties.getProperty("useoutput");
        encryption = suiteProperties.getProperty("encryption");
        testEncryptionProvider = suiteProperties.getProperty("testEncryptionProvider");
        testEncryptionAlgorithm = suiteProperties.getProperty("testEncryptionAlgorithm");
        jdk12test = suiteProperties.getProperty("jdk12test");
        jdk12exttest = suiteProperties.getProperty("jdk12exttest");
        runwithibmjvm = suiteProperties.getProperty("runwithibmjvm");
        runwithj9 = suiteProperties.getProperty("runwithj9");
        derbyTestingXaSingle = suiteProperties.getProperty("derbyTesting.xa.single");
        String testJVM = jvmName;
        if (jvmName.startsWith("j9") && !jvmName.startsWith("j9dee")) {
            testJVM = jvmName.startsWith("j9_foundation") ? "foundation" : "j9";
        }
        runwithjvm = suiteProperties.getProperty("runwith" + testJVM);
        excludeJCC = suiteProperties.getProperty("excludeJCC");
        keepfiles = suiteProperties.getProperty("keepfiles");
        systemdiff = suiteProperties.getProperty("systemdiff");
        outputdir = suiteProperties.getProperty("outputdir");
        if (outputdir == null) {
            outputdir = userdir;
        }
        if ((topsuitedir = suiteProperties.getProperty("topsuitedir")) == null) {
            topsuitedir = outputdir;
        }
        bootcp = suiteProperties.getProperty("bootcp");
        serverJvm = suiteProperties.getProperty("serverJvm");
        serverJvmName = suiteProperties.getProperty("serverJvmName");
        hostName = suiteProperties.getProperty("hostName");
        testEncoding = suiteProperties.getProperty("derbyTesting.encoding");
        upgradejarpath = suiteProperties.getProperty("derbyTesting.jar.path");
        canondir = suiteProperties.getProperty("canondir");
        mtestdir = suiteProperties.getProperty("mtestdir");
        String usepr = suiteProperties.getProperty("useprocess");
        if (usepr != null && usepr.equals("false")) {
            useprocess = false;
        }
        skipsed = suiteProperties.getProperty("skipsed");
        String dbug = suiteProperties.getProperty("verbose");
        if (dbug != null && dbug.equals("true")) {
            verbose = true;
        }
        reportstderr = suiteProperties.getProperty("reportstderr");
        timeout = suiteProperties.getProperty("timeout");
        shutdownurl = suiteProperties.getProperty("shutdownurl");
        topSuiteName = suiteProperties.getProperty("suitename");
        ijdefaultResourcePackage = suiteProperties.getProperty("ij.defaultResourcePackage");
        if (specialProperties != null && !specialProperties.isEmpty()) {
            RunList.setSpecialProps(specialProperties, true);
        }
    }

    private static void setSuiteProperties(Properties p, String suiteName, Properties parentProperties, boolean isParent, boolean isTop) throws ClassNotFoundException, IOException {
        if (jversion != null) {
            p.put("jvm", jversion);
        }
        if (jvmName == null) {
            jvmName = "currentjvm";
        } else {
            p.put("jvm", jvmName);
        }
        if (javaCmd == null) {
            javaCmd = "java";
        } else {
            p.put("javaCmd", javaCmd);
        }
        String totaljvmflags = jvmflags;
        String subjvmflags = p.getProperty("jvmflags");
        String parentjvmflags = parentProperties.getProperty("jvmflags");
        if (subjvmflags != null && parentjvmflags != null && !subjvmflags.equals(parentjvmflags) && subjvmflags != null && subjvmflags.length() > 0) {
            totaljvmflags = subjvmflags + "^" + totaljvmflags;
        }
        if (totaljvmflags != null) {
            jvmflags = totaljvmflags;
        }
        if (classpath != null) {
            p.put("classpath", classpath);
        }
        if (classpathServer != null) {
            p.put("classpathServer", classpathServer);
        }
        if (systemdiff != null) {
            p.put("systemdiff", systemdiff);
        }
        if (verbose) {
            p.put("verbose", "true");
        }
        if (bootcp != null) {
            p.put("bootcp", "bootcp");
        }
        if (canondir != null) {
            p.put("canondir", canondir);
        }
        if ((outputdir == null || outputdir.length() == 0) && (outputdir = p.getProperty("outputdir")) == null) {
            outputdir = userdir;
        }
        if (parentProperties.getProperty("framework") != null) {
            p.put("framework", framework);
        } else {
            framework = p.getProperty("framework");
        }
        if (parentProperties.getProperty("serverJvm") != null) {
            p.put("serverJvm", serverJvm);
        } else {
            serverJvm = p.getProperty("serverJvm");
        }
        if (parentProperties.getProperty("serverJvmName") != null) {
            p.put("serverJvmName", serverJvmName);
        } else {
            serverJvmName = p.getProperty("serverJvmName");
        }
        if (parentProperties.getProperty("derbyTesting.encoding") != null) {
            p.put("derbyTesting.encoding", testEncoding);
        } else {
            testEncoding = p.getProperty("derbyTesting.encoding");
        }
        if (parentProperties.getProperty("derbyTesting.jar.path") != null) {
            p.put("derbyTesting.jar.path", upgradejarpath);
        } else {
            upgradejarpath = p.getProperty("derbyTesting.jar.path");
        }
        if (hostName != null) {
            p.put("hostName", hostName);
        } else {
            p.put("hostName", "localhost");
        }
        if (parentProperties.getProperty("encryption") != null) {
            p.put("encryption", encryption);
        } else {
            encryption = p.getProperty("encryption");
        }
        if (parentProperties.getProperty("testEncryptionProvider") != null) {
            p.put("testEncryptionProvider", testEncryptionProvider);
        } else {
            testEncryptionProvider = p.getProperty("testEncryptionProvider");
        }
        if (parentProperties.getProperty("testEncryptionAlgorithm") != null) {
            p.put("testEncryptionAlgorithm", testEncryptionAlgorithm);
        } else {
            testEncryptionAlgorithm = p.getProperty("testEncryptionAlgorithm");
        }
        if (parentProperties.getProperty("jdk12test") != null) {
            p.put("jdk12test", jdk12test);
        } else {
            jdk12test = p.getProperty("jdk12test");
        }
        if (parentProperties.getProperty("jdk12exttest") != null) {
            p.put("jdk12exttest", jdk12exttest);
        } else {
            jdk12exttest = p.getProperty("jdk12exttest");
        }
        if (parentProperties.getProperty("runwithibmjvm") != null) {
            p.put("runwithibmjvm", runwithibmjvm);
        } else {
            runwithibmjvm = p.getProperty("runwithibmjvm");
        }
        String testJVM = jvmName;
        if (jvmName.startsWith("j9") && !jvmName.startsWith("j9dee")) {
            String string = testJVM = jvmName.startsWith("j9_foundation") ? "foundation" : "j9";
        }
        if (parentProperties.getProperty("runwith" + testJVM) != null) {
            p.put("runwith" + testJVM, runwithjvm);
        } else {
            runwithjvm = p.getProperty("runwith" + testJVM);
        }
        if (parentProperties.getProperty("runwithj9") != null) {
            p.put("runwithj9", runwithj9);
        } else {
            runwithj9 = p.getProperty("runwithj9");
        }
        if (parentProperties.getProperty("excludeJCC") != null) {
            p.put("excludeJCC", excludeJCC);
        } else {
            excludeJCC = p.getProperty("excludeJCC");
        }
        String upr = parentProperties.getProperty("useprocess");
        if (upr != null) {
            p.put("useprocess", upr);
        } else {
            upr = p.getProperty("useprocess");
            useprocess = upr == null ? true : !upr.equals("false");
        }
        usesystem = p.getProperty("usesystem");
        shutdownurl = p.getProperty("shutdownurl");
        upgradetest = p.getProperty("upgradetest");
        jarfile = p.getProperty("jarfile");
        skipsed = p.getProperty("skipsed");
        if (skipsed == null) {
            skipsed = "false";
        }
        if ("true".equals(keepfiles)) {
            p.put("keepfiles", keepfiles);
        }
        String testflags = p.getProperty("testJavaFlags");
        if (parentProperties.getProperty("testJavaFlags") != null) {
            if (testflags != null && !testflags.equals(testJavaFlags)) {
                testJavaFlags = testJavaFlags + "^" + testflags;
            }
            p.put("testJavaFlags", testJavaFlags);
        } else {
            testJavaFlags = p.getProperty("testJavaFlags");
        }
        if (parentProperties.getProperty("reportstderr") != null) {
            p.put("reportstderr", reportstderr);
        } else {
            reportstderr = p.getProperty("reportstderr");
        }
        if (parentProperties.getProperty("timeout") != null) {
            p.put("timeout", timeout);
        } else {
            timeout = p.getProperty("timeout");
        }
        outcopy = p.getProperty("outcopy");
        useoutput = p.getProperty("useoutput");
        mtestdir = p.getProperty("mtestdir");
        ijdefaultResourcePackage = p.getProperty("ij.defaultResourcePackage");
        if (topSuiteName == null) {
            topSuiteName = p.getProperty("suitename");
        } else {
            p.put("suitename", topSuiteName);
        }
        skip = RunList.shouldSkipTest();
        RunList.setSuiteDir(suiteName, isParent, isTop);
        otherSpecialProps = "";
        Properties specialProps = SpecialFlags.getSpecialProperties(p);
        if (specialProps != null && !specialProps.isEmpty()) {
            RunList.setSpecialProps(specialProps, false);
        }
    }

    private static boolean shouldSkipTest() {
        boolean result = false;
        boolean isJdk12 = false;
        boolean isJdk118 = false;
        boolean isJdk117 = false;
        boolean isEncryption = false;
        boolean isJdk12Test = false;
        boolean isJdk12ExtTest = false;
        boolean isSyncTest = false;
        boolean isSyncProduct = false;
        boolean isExcludeJCC = false;
        driverNotFound = false;
        needSync = false;
        needJdk12 = false;
        needJdk12ext = false;
        excludedFromJCC = false;
        needIBMjvm = null;
        if (iminor >= 2) {
            isJdk12 = true;
        }
        if (System.getProperty("java.version").startsWith("1.1.8")) {
            isJdk118 = true;
        }
        if (System.getProperty("java.version").startsWith("1.1.7")) {
            isJdk117 = true;
        }
        if (runwithibmjvm != null) {
            needIBMjvm = runwithibmjvm.equals("") ? null : new Boolean(runwithibmjvm);
        }
        if (runwithibmjvm == null) {
            needIBMjvm = null;
        }
        if (needIBMjvm != null) {
            boolean needsibm = needIBMjvm;
            boolean ibmjvm = false;
            String vendor = System.getProperty("java.vendor");
            if (vendor.startsWith("IBM")) {
                ibmjvm = true;
            }
            if (!needsibm && ibmjvm) {
                return true;
            }
            if (needsibm && !ibmjvm) {
                return true;
            }
        }
        if (runwithjvm != null && runwithjvm.equals("false")) {
            return true;
        }
        if (framework != null && framework.length() > 0 && framework.equals("DerbyNet")) {
            try {
                Class.forName("org.apache.derby.drda.NetworkServerControl");
            }
            catch (ClassNotFoundException cnfe) {
                driverNotFound = true;
                result = true;
            }
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
            }
            catch (ClassNotFoundException cnfe) {
                driverNotFound = true;
                result = true;
            }
            catch (NoClassDefFoundError err) {
                driverNotFound = true;
                result = true;
            }
        }
        if (result) {
            return true;
        }
        if (encryption != null && encryption.length() > 0 && "true".equalsIgnoreCase(encryption)) {
            isEncryption = true;
        }
        if (jdk12test != null && jdk12test.length() > 0 && "true".equalsIgnoreCase(jdk12test)) {
            isJdk12Test = true;
        }
        if (jdk12exttest != null && jdk12exttest.length() > 0 && "true".equalsIgnoreCase(jdk12exttest)) {
            isJdk12ExtTest = true;
        }
        if (!isJdk12) {
            if (isEncryption || isJdk12Test || isJdk12ExtTest) {
                needJdk12 = true;
                result = true;
            }
            if (result) {
                return true;
            }
        }
        if (isEncryption || isJdk12ExtTest) {
            needJdk12ext = true;
            try {
                Class<?> jtaClass = Class.forName("javax.transaction.xa.Xid");
                Class<?> jdbcClass = Class.forName("javax.sql.RowSet");
            }
            catch (ClassNotFoundException cnfe) {
                result = true;
            }
            if (result) {
                return true;
            }
        }
        if (isEncryption) {
            needEncryption = true;
            try {
                Class<?> jceClass = Class.forName("javax.crypto.Cipher");
            }
            catch (ClassNotFoundException cnfe) {
                result = true;
            }
            if (result) {
                return true;
            }
        }
        if (excludeJCC != null) {
            int jccMinor;
            int jccMajor;
            block36: {
                Class<?> c = null;
                Method m = null;
                Object o = null;
                Integer i = null;
                jccMajor = 0;
                jccMinor = 0;
                try {
                    c = Class.forName("com.ibm.db2.jcc.DB2Driver");
                    o = c.newInstance();
                    m = c.getMethod("getMajorVersion", null);
                    i = (Integer)m.invoke(o, null);
                    jccMajor = i;
                    m = c.getMethod("getMinorVersion", null);
                    i = (Integer)m.invoke(o, null);
                    jccMinor = i;
                }
                catch (Exception e) {
                    if (!verbose) break block36;
                    System.out.println("Exception in shouldSkipTest: " + e);
                }
            }
            try {
                RunList.checkClientExclusion(excludeJCC, "JCC", jccMajor, jccMinor, javaVersion);
            }
            catch (Exception e) {
                excludedFromJCC = true;
                clientExclusionMessage = e.getMessage();
                return true;
            }
        }
        return result;
    }

    public static void setSuiteDir(String suiteName, boolean isParent, boolean isTop) throws IOException {
        if (isTop) {
            outputdir = topsuitedir == null || topsuitedir.length() == 0 ? (topsuitedir = userdir) : topsuitedir;
            File topdir = new File(outputdir, topSuiteName);
            topdir.mkdir();
            if (!topParentSuite.equals(topSuiteName)) {
                File topparent = new File(topdir, topParentSuite);
                topparent.mkdir();
                outputdir = topparent.getCanonicalPath();
            } else {
                outputdir = topdir.getCanonicalPath();
            }
            topreportdir = outputdir;
            if (framework != null && framework.length() > 0) {
                File f = new File(outputdir, framework);
                f.mkdir();
                outputdir = f.getCanonicalPath();
                fw_set = true;
            }
            topsuitedir = outputdir;
        } else if (isParent) {
            outputdir = topsuitedir;
            if (!suiteName.equals(topParentSuite)) {
                File suitedir = new File(outputdir, suiteName);
                suitedir.mkdir();
                outputdir = suitedir.getCanonicalPath();
            }
            if (!fw_set && framework != null && framework.length() > 0) {
                File f = new File(outputdir, framework);
                f.mkdir();
                outputdir = f.getCanonicalPath();
            }
        } else if (upgradetest == null) {
            File suitedir = new File(outputdir, suiteName);
            suitedir.mkdir();
            outputdir = suitedir.getCanonicalPath();
        }
    }

    private static void setSpecialProps(Properties p, boolean isTop) {
        String tmp = "";
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            tmp = tmp + key + "=" + p.getProperty(key) + "^";
        }
        if (tmp.length() > 0) {
            if (isTop) {
                topSpecialProps = tmp.substring(0, tmp.lastIndexOf(94));
            } else {
                otherSpecialProps = tmp.substring(0, tmp.lastIndexOf(94));
            }
        }
    }

    static void addToSkipFile(String suiteName, PrintStream ps) throws IOException {
        ps.println(suiteName);
        ps.flush();
    }

    public static void checkClientExclusion(String exclusion, String clientName, int clientMajor, int clientMinor, String javaVersion) throws Exception {
        boolean jvmDependent;
        if (exclusion == null) {
            return;
        }
        int clientComparisonType = 0;
        int jvmComparisonType = 0;
        exclusion = exclusion.toLowerCase();
        String clientVersion = null;
        int comma = exclusion.indexOf(",");
        clientVersion = comma != -1 ? exclusion.substring(0, comma) : exclusion;
        try {
            clientComparisonType = RunList.getVersionCompareType(clientVersion);
        }
        catch (Exception e) {
            System.out.println("exclusion property poorly formatted: " + exclusion);
            return;
        }
        if (comma == -1) {
            jvmDependent = false;
        } else {
            jvmDependent = true;
            String jvmVersion = exclusion.substring(comma + 6);
            try {
                jvmComparisonType = RunList.getVersionCompareType(jvmVersion);
            }
            catch (Exception e) {
                System.out.println("exclusion property poorly formatted: " + exclusion);
                return;
            }
        }
        int[] excludeInfo = null;
        try {
            excludeInfo = RunList.getVersionArray(exclusion, 5);
        }
        catch (Exception e) {
            System.out.println("Unexpected text in exclusion property: " + e.getMessage());
            return;
        }
        if (RunList.versionExcluded(new int[]{clientMajor, clientMinor}, 0, excludeInfo, 0, 2, clientComparisonType)) {
            if (!jvmDependent) {
                throw new Exception("This test/suite is excluded from running with " + clientName + " versions at or " + (clientComparisonType == -1 ? "before " : "after ") + excludeInfo[0] + "." + excludeInfo[1] + ".");
            }
            int[] jvmInfo = null;
            try {
                jvmInfo = RunList.getVersionArray(javaVersion, 3);
            }
            catch (Exception e) {
                System.out.println("Unexpected text in exclusion property: " + e.getMessage());
                return;
            }
            if (RunList.versionExcluded(jvmInfo, 0, excludeInfo, 2, 3, jvmComparisonType)) {
                throw new Exception("This test/suite is excluded from running with " + clientName + " versions at or " + (clientComparisonType == -1 ? "before " : "after ") + excludeInfo[0] + "." + excludeInfo[1] + " when JVM versions at or " + (jvmComparisonType == -1 ? "before " : "after ") + excludeInfo[2] + "." + excludeInfo[3] + "." + excludeInfo[4] + " are being used.");
            }
        }
    }

    private static int[] getVersionArray(String versionString, int resultSize) throws Exception {
        if (versionString == null) {
            versionString = "";
        }
        int[] result = new int[resultSize];
        String tok = null;
        String text = null;
        StringTokenizer st = new StringTokenizer(versionString, ".,_");
        for (int i = 0; i < resultSize; ++i) {
            if (!st.hasMoreTokens()) {
                result[i] = -1;
                continue;
            }
            tok = st.nextToken();
            int pos = 0;
            while (!Character.isDigit(tok.charAt(pos))) {
                ++pos;
            }
            text = tok.substring(0, pos);
            if (text.length() > 0 && !RunList.isClientExclusionKeyword(text)) {
                throw new Exception(text);
            }
            if ((tok = tok.substring(pos)).length() == 0) {
                --i;
                continue;
            }
            result[i] = Integer.parseInt(tok);
        }
        return result;
    }

    private static int getVersionCompareType(String versionString) throws Exception {
        if (versionString == null) {
            return -1;
        }
        int colon = versionString.indexOf(":");
        if (colon != -1) {
            if (versionString.startsWith("at-or-before")) {
                return -1;
            }
            if (versionString.startsWith("at-or-after")) {
                return 1;
            }
            throw new Exception("bad exclusion property format");
        }
        return -1;
    }

    private static boolean versionExcluded(int[] vActual, int offset1, int[] vTarget, int offset2, int numParts, int comparisonType) {
        int compareLen = vActual.length >= vTarget.length ? vTarget.length : vActual.length;
        compareLen = compareLen <= numParts ? compareLen : numParts;
        for (int i = 0; i < compareLen; ++i) {
            if (comparisonType * vActual[offset1] > comparisonType * vTarget[offset2]) {
                return true;
            }
            if (comparisonType * vActual[offset1] < comparisonType * vTarget[offset2]) {
                return false;
            }
            ++offset1;
            ++offset2;
        }
        if (compareLen == numParts) {
            return true;
        }
        return comparisonType * vActual.length > comparisonType * vTarget.length;
    }

    private static boolean isClientExclusionKeyword(String text) {
        for (int i = 0; i < clientExclusionKeywords.length; ++i) {
            if (!clientExclusionKeywords[i].equals(text)) continue;
            return true;
        }
        return false;
    }

    private static void unloadEmbeddedDriver() {
        if (TestUtil.HAVE_DRIVER_CLASS) {
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        System.gc();
    }

    static {
        skip = false;
        driverNotFound = false;
        needSync = false;
        needJdk12 = false;
        needJdk12ext = false;
        excludedFromJCC = false;
        needIBMjvm = null;
        needEncryption = false;
        keepfiles = "false";
        runwithibmjvm = null;
        useprocess = true;
        skipsed = "false";
        fw_set = false;
        systemdiff = "false";
        suiteName = "";
        fullsuiteName = "";
        topSuiteName = "";
        topParentSuite = "";
        topSpecialProps = "";
        otherSpecialProps = "";
        verbose = false;
        clientExclusionKeywords = new String[]{"at-or-before:", "at-or-after:", "when-at-or-before:jdk", "when-at-or-after:jdk", "when:jdk"};
    }
}

