/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derbyTesting.functionTests.harness.CurrentTime;
import org.apache.derbyTesting.functionTests.harness.GenerateReport;
import org.apache.derbyTesting.functionTests.harness.JavaVersionHolder;
import org.apache.derbyTesting.functionTests.harness.RunList;
import org.apache.derbyTesting.functionTests.harness.RunTest;
import org.apache.derbyTesting.functionTests.harness.SpecialFlags;
import org.apache.derbyTesting.functionTests.harness.SysInfoLog;

public class RunSuite {
    static final boolean verbose = true;
    static String suites;
    static Vector suitesToRun;
    static String jvmName;
    static String javaCmd;
    static String jvmflags;
    static String javaVersion;
    static String classpath;
    static String classpathServer;
    static String testJavaFlags;
    static String testSpecialProps;
    static String userdir;
    static String framework;
    static String runwithibmjvm;
    static String excludeJCC;
    static boolean useprocess;
    static boolean skipsed;
    static String systemdiff;
    static String topSuiteName;
    static String outputdir;
    static String outcopy;
    static String canondir;
    static String bootcp;
    static String serverJvm;
    static String hostName;
    static String testEncoding;
    static String ijdefaultResourcePackage;
    static String debug;
    static String timeout;
    static String shutdownurl;
    static String reportstderr;
    static Properties suiteProperties;
    static Properties specialProperties;
    static PrintWriter pwOut;
    static File outDir;
    static File runDir;
    static File outFile;

    public static void main(String[] args) throws Exception {
        String suiteName;
        String j9config;
        if (System.getProperty("java.vm.name") != null && System.getProperty("java.vm.name").equals("J9")) {
            javaCmd = "j9";
            String javaHome = System.getProperty("java.home");
        }
        if ((j9config = System.getProperty("com.ibm.oti.configuration")) != null) {
            if (j9config.equals("foun10")) {
                jvmName = "j9_foundation";
            } else if (j9config.equals("foun11")) {
                jvmName = "j9_foundation11";
            } else if (j9config.equals("max")) {
                jvmName = "j9_13";
            } else if (j9config.equals("dee")) {
                jvmName = "j9dee15";
            }
        }
        if ((suiteName = args[0]) == null) {
            System.out.println("No suite name argument.");
            System.exit(1);
        }
        topSuiteName = suiteName;
        System.out.println("Top suite: " + suiteName);
        suitesToRun = new Vector();
        suiteProperties = RunSuite.getSuiteProperties(suiteName, true);
        RunSuite.getSystemProperties();
        specialProperties = SpecialFlags.getSpecialProperties(suiteProperties);
        RunSuite.setOutput(suiteName);
        String startTime = CurrentTime.getTime();
        pwOut.println("******* Start Suite: " + suiteName + " " + startTime + " *******");
        if (useprocess) {
            SysInfoLog sysLog = new SysInfoLog();
            sysLog.exec(jvmName, javaCmd, classpath, framework, pwOut, useprocess);
        }
        RunSuite.getSuitesList(suiteName, true);
        String endTime = CurrentTime.getTime();
        pwOut.println("******* End Suite: " + suiteName + " " + endTime + " *******");
        pwOut.close();
        String genrep = System.getProperty("genrep");
        boolean isGenrep = true;
        if (genrep != null) {
            isGenrep = "true".equalsIgnoreCase(genrep);
        }
        if (isGenrep) {
            String[] genargs = new String[]{args[0], jvmName, javaCmd, classpath, framework, useprocess ? "true" : "false"};
            GenerateReport.main(genargs);
        }
    }

    static void getSuitesList(String topparent, boolean isTop) throws Exception, ClassNotFoundException, IOException {
        if (suites == null || suites.length() == 0) {
            System.out.println("Suite to run: " + topparent + ":" + topparent);
            suitesToRun.addElement(topparent + ":" + topparent);
            System.out.println("Now do RunList");
            RunList rl = new RunList(suitesToRun, runDir, outDir, pwOut, suiteProperties, specialProperties, topparent);
            suitesToRun.removeAllElements();
        } else {
            isTop = false;
            StringTokenizer st = new StringTokenizer(suites);
            String subparent = "";
            while (st.hasMoreTokens()) {
                subparent = st.nextToken();
                Properties p = RunSuite.getSuiteProperties(subparent, isTop);
                if (p.getProperty("suites") == null || subparent.equals(topparent)) {
                    suitesToRun.addElement(topparent + ":" + subparent);
                    System.out.println("Now do RunList");
                    RunList rl = new RunList(suitesToRun, runDir, outDir, pwOut, suiteProperties, specialProperties, topparent);
                    suitesToRun.removeAllElements();
                    continue;
                }
                String sublist = p.getProperty("suites");
                RunSuite.BuildSuitesVector(subparent, sublist);
                System.out.println("Now do RunList");
                RunList rl = new RunList(suitesToRun, runDir, outDir, pwOut, suiteProperties, specialProperties, subparent);
                suitesToRun.removeAllElements();
            }
        }
    }

    static void BuildSuitesVector(String parent, String subsuites) throws ClassNotFoundException, IOException {
        StringTokenizer st = new StringTokenizer(subsuites);
        String child = "";
        while (st.hasMoreTokens()) {
            child = st.nextToken();
            if (child.equals(parent)) {
                suitesToRun.addElement(parent + ":" + child);
                continue;
            }
            Properties p = RunSuite.getSuiteProperties(child, false);
            if (p.getProperty("suites") == null) {
                suitesToRun.addElement(parent + ":" + child);
                continue;
            }
            String moresuites = p.getProperty("suites");
            RunSuite.BuildSuitesVector(child, moresuites);
        }
    }

    static Properties getSuiteProperties(String suiteName, boolean isTop) throws ClassNotFoundException, IOException {
        String suiteProps = "suites/" + suiteName + ".properties";
        userdir = System.getProperty("user.dir");
        InputStream is = RunTest.loadTestResource(suiteProps);
        if (is == null) {
            suiteProps = userdir + '/' + suiteName + ".properties";
            is = RunTest.loadTestResource(suiteProps);
        }
        Properties p = new Properties();
        if (is == null) {
            return p;
        }
        p.load(is);
        if (isTop) {
            String tmpjvmName = jvmName;
            jvmName = p.getProperty("jvm");
            javaVersion = jvmName == null || jvmName.length() == 0 ? System.getProperty("java.version") : jvmName;
            String javavmVersion = System.getProperty("java.vm.name").equals("J9") ? System.getProperty("java.vm.version") : javaVersion;
            JavaVersionHolder jvh = new JavaVersionHolder(javavmVersion);
            String majorVersion = jvh.getMajorVersion();
            String minorVersion = jvh.getMinorVersion();
            int iminor = jvh.getMinorNumber();
            int imajor = jvh.getMajorNumber();
            jvmName = iminor < 2 && imajor < 2 ? "currentjvm" : "jdk" + majorVersion + minorVersion;
            if (tmpjvmName != null) {
                jvmName = tmpjvmName;
            }
            javaCmd = p.getProperty("javaCmd");
            jvmflags = p.getProperty("jvmflags");
            testJavaFlags = p.getProperty("testJavaFlags");
            testSpecialProps = p.getProperty("testSpecialProps");
            classpath = p.getProperty("classpath");
            classpathServer = p.getProperty("classpathServer");
            framework = p.getProperty("framework");
            String usepr = p.getProperty("useprocess");
            useprocess = usepr != null ? !(usepr = usepr.toLowerCase()).equals("false") : true;
            String nosed = p.getProperty("skipsed");
            skipsed = nosed != null ? (nosed = nosed.toLowerCase()).equals("true") : false;
            outputdir = p.getProperty("outputdir");
            canondir = p.getProperty("canondir");
            bootcp = p.getProperty("bootcp");
            hostName = p.getProperty("hostName");
            serverJvm = p.getProperty("serverJvm");
            systemdiff = p.getProperty("systemdiff");
            ijdefaultResourcePackage = p.getProperty("ij.defaultResourcePackage");
            outcopy = p.getProperty("outcopy");
            debug = p.getProperty("verbose");
            reportstderr = p.getProperty("reportstderr");
            timeout = p.getProperty("timeout");
            shutdownurl = p.getProperty("shutdownurl");
            testEncoding = p.getProperty("derbyTesting.encoding");
        }
        suites = p.getProperty("suites");
        return p;
    }

    private static void getSystemProperties() {
        String tout;
        String reporterr;
        String topsuite;
        String outcpy;
        String defrespckg;
        String sysdiff;
        String nosed;
        String usepr;
        String mtdir;
        String testout;
        String upgradejarpath;
        String cmlTestEncoding;
        String serverJvm;
        String hostname;
        String j9bootcp;
        String canond;
        String outd;
        String keep;
        String excludeJCC;
        String runwithibmjvm;
        String jdk12ex;
        String jdk12test;
        String encryptAlgorithm;
        String encrypt;
        String rep;
        String upgtest;
        String jarf;
        String usesys;
        String clsrv;
        String clpth;
        String testprops;
        String j;
        String frm;
        Properties sp = System.getProperties();
        String searchCP = sp.getProperty("ij.searchClassPath");
        if (searchCP != null) {
            suiteProperties.put("ij.searchClassPath", searchCP);
        }
        if ((frm = sp.getProperty("framework")) != null && !frm.equals("embedded")) {
            framework = frm;
            suiteProperties.put("framework", framework);
        }
        if ((j = sp.getProperty("jvm")) != null) {
            suiteProperties.put("jversion", j);
        }
        String jcmd = sp.getProperty("javaCmd");
        if (System.getProperty("java.vm.name") != null && System.getProperty("java.vm.name").equals("J9")) {
            jcmd = "j9";
        }
        if (jcmd != null) {
            javaCmd = jcmd;
            suiteProperties.put("javaCmd", javaCmd);
        }
        String jflags = sp.getProperty("jvmflags");
        if (jvmflags != null && jvmflags.length() > 0) {
            if (jflags != null && jflags.length() > 0) {
                suiteProperties.put("jvmflags", jvmflags + "^" + jflags);
            } else {
                suiteProperties.put("jvmflags", jvmflags);
            }
        } else if (jflags != null && jflags.length() > 0) {
            suiteProperties.put("jvmflags", jflags);
        }
        String testflags = sp.getProperty("testJavaFlags");
        if (testflags != null) {
            testJavaFlags = testJavaFlags == null || testJavaFlags.length() == 0 ? testflags : testJavaFlags + "^" + testflags;
            suiteProperties.put("testJavaFlags", testJavaFlags);
        }
        if ((testprops = sp.getProperty("testSpecialProps")) != null) {
            testSpecialProps = testSpecialProps == null || testSpecialProps.length() == 0 ? testprops : testSpecialProps + "^" + testprops;
            suiteProperties.put("testSpecialProps", testSpecialProps);
        }
        if ((clpth = sp.getProperty("classpath")) != null) {
            classpath = clpth;
            suiteProperties.put("classpath", classpath);
        }
        if ((clsrv = sp.getProperty("classpathServer")) != null && !clsrv.startsWith("${")) {
            classpathServer = clsrv;
            suiteProperties.put("classpathServer", clsrv);
        }
        if ((usesys = sp.getProperty("usesystem")) != null) {
            suiteProperties.put("usesystem", usesys);
        }
        if ((jarf = sp.getProperty("jarfile")) != null) {
            suiteProperties.put("jarfile", jarf);
        }
        if ((upgtest = sp.getProperty("upgradetest")) != null) {
            suiteProperties.put("upgradetest", upgtest);
        }
        if ((rep = sp.getProperty("replication")) != null) {
            suiteProperties.put("replication", rep);
        }
        if ((encrypt = sp.getProperty("encryption")) != null) {
            suiteProperties.put("encryption", encrypt);
        }
        if ((encryptAlgorithm = sp.getProperty("testEncryptionAlgorithm")) != null) {
            suiteProperties.put("testEncryptionAlgorithm", encryptAlgorithm);
        }
        if ((jdk12test = sp.getProperty("jdk12test")) != null) {
            suiteProperties.put("jdk12test", jdk12test);
        }
        if ((jdk12ex = sp.getProperty("jdk12exttest")) != null) {
            suiteProperties.put("jdk12exttest", jdk12ex);
        }
        if ((runwithibmjvm = sp.getProperty("runwithibmjvm")) != null) {
            suiteProperties.put("runwithibmjvm", runwithibmjvm);
        }
        if ((excludeJCC = sp.getProperty("excludeJCC")) != null) {
            suiteProperties.put("excludeJCC", excludeJCC);
        }
        if ((keep = sp.getProperty("keepfiles")) != null) {
            suiteProperties.put("keepfiles", keep);
        }
        if ((outd = sp.getProperty("outputdir")) != null) {
            outputdir = outd;
            suiteProperties.put("outputdir", outputdir);
        }
        if ((canond = sp.getProperty("canondir")) != null) {
            canondir = canond;
            suiteProperties.put("canondir", canondir);
        }
        if ((j9bootcp = sp.getProperty("bootcp")) != null) {
            bootcp = j9bootcp;
            suiteProperties.put("bootcp", bootcp);
        }
        if ((hostname = sp.getProperty("hostName")) != null) {
            suiteProperties.put("hostName", hostname);
        }
        if ((serverJvm = sp.getProperty("serverJvm")) != null) {
            suiteProperties.put("serverJvm", serverJvm);
        }
        if ((cmlTestEncoding = sp.getProperty("derbyTesting.encoding")) != null) {
            suiteProperties.put("derbyTesting.encoding", cmlTestEncoding);
        }
        if ((upgradejarpath = sp.getProperty("derbyTesting.jar.path")) != null) {
            suiteProperties.put("derbyTesting.jar.path", upgradejarpath);
        }
        if ((testout = sp.getProperty("testoutname")) != null) {
            suiteProperties.put("testoutname", testout);
        }
        if ((mtdir = sp.getProperty("mtestdir")) != null) {
            suiteProperties.put("mtestdir", mtdir);
        }
        if ((usepr = sp.getProperty("useprocess")) != null && (usepr = usepr.toLowerCase()).equals("false")) {
            useprocess = false;
            suiteProperties.put("useprocess", usepr);
        }
        if ((nosed = sp.getProperty("skipsed")) != null && (nosed = nosed.toLowerCase()).equals("true")) {
            skipsed = true;
            suiteProperties.put("skipsed", nosed);
        }
        if ((sysdiff = sp.getProperty("systemdiff")) != null && (sysdiff = sysdiff.toLowerCase()).equals("true")) {
            suiteProperties.put("systemdiff", "true");
        }
        if ((defrespckg = sp.getProperty("ij.defaultResourcePackage")) != null) {
            suiteProperties.put("ij.defaultResourcePackage", defrespckg);
        }
        if ((outcpy = sp.getProperty("outcopy")) != null) {
            suiteProperties.put("outcopy", outcpy);
        }
        if ((topsuite = sp.getProperty("suitename")) != null) {
            suiteProperties.put("suitename", topsuite);
        } else {
            suiteProperties.put("suitename", topSuiteName);
        }
        String dbug = sp.getProperty("verbose");
        if (dbug != null) {
            suiteProperties.put("verbose", dbug);
        }
        if ((reporterr = sp.getProperty("reportstderr")) != null) {
            suiteProperties.put("reportstderr", reporterr);
        }
        if ((tout = sp.getProperty("timeout")) != null) {
            suiteProperties.put("timeout", tout);
        }
    }

    private static void setOutput(String suiteName) throws ClassNotFoundException, FileNotFoundException, IOException {
        File failFile;
        File passFile;
        boolean status = false;
        File tmpoutDir = outputdir == null || outputdir.length() == 0 ? new File(new File(userdir).getCanonicalPath()) : new File(new File(outputdir).getCanonicalPath());
        outDir = tmpoutDir;
        outDir.mkdir();
        runDir = new File(new File(userdir).getCanonicalPath());
        suiteProperties.put("outputdir", outDir.getCanonicalPath());
        outFile = new File(outDir, suiteName + ".sum");
        if (outFile.exists()) {
            status = outFile.delete();
        }
        if ((passFile = new File(outDir, suiteName + ".pass")).exists()) {
            status = passFile.delete();
        }
        if ((failFile = new File(outDir, suiteName + ".fail")).exists()) {
            status = failFile.delete();
        }
        pwOut = new PrintWriter((Writer)new BufferedWriter(new FileWriter(outFile.getPath()), 4096), true);
    }

    static {
        jvmName = "";
        javaCmd = "java";
        jvmflags = "";
        testJavaFlags = "";
        testSpecialProps = "";
        useprocess = true;
        skipsed = false;
        systemdiff = "false";
        topSuiteName = "";
        outcopy = "false";
        pwOut = null;
    }
}

