/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ServerPropertiesTest
extends BaseJDBCTestCase {
    private static String POLICY_FILE_NAME = "functionTests/tests/derbynet/ServerPropertiesTest.policy";
    private static String TARGET_POLICY_FILE_NAME = "server.policy";
    private int[] portsSoFar;
    private int basePort = TestConfiguration.getCurrent().getPort();

    public ServerPropertiesTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ServerPropertiesTest");
        if (!Derby.hasServer()) {
            return suite;
        }
        if (JDBC.vmSupportsJSR169()) {
            return suite;
        }
        suite.addTest(ServerPropertiesTest.decorateTest("ttestSetPortPriority", new String[0], new String[0], false));
        String[] badServerProperties = new String[]{"derby.drda.logConnections=", "derby.drda.traceAll=", "derby.drda.traceDirectory=", "derby.drda.keepAlive=", "derby.drda.timeSlice=", "derby.drda.host=", "derby.drda.portNumber=", "derby.drda.minThreads=", "derby.drda.maxThreads=", "derby.drda.startNetworkServer=", "derby.drda.debug="};
        if (TestConfiguration.loadingFromJars()) {
            suite.addTest(ServerPropertiesTest.decorateTest("ttestDefaultProperties", badServerProperties, new String[0], true));
        }
        if (!Locale.getDefault().getLanguage().equals("en")) {
            return suite;
        }
        Test test = TestConfiguration.clientServerSuite(ServerPropertiesTest.class);
        test = ServerPropertiesTest.decorateWithPolicy(test);
        suite.addTest(test);
        return suite;
    }

    public void tearDown() throws Exception {
        super.tearDown();
        POLICY_FILE_NAME = null;
        TARGET_POLICY_FILE_NAME = null;
        if (this.portsSoFar != null) {
            for (int i = 0; i < this.portsSoFar.length; ++i) {
                try {
                    this.shutdownServer(this.portsSoFar[i], true);
                    continue;
                }
                catch (SQLException e) {
                    ServerPropertiesTest.fail((String)("could not shutdown server at port " + this.portsSoFar[i]));
                }
            }
            this.portsSoFar = null;
        }
    }

    private static Test decorateTest(String testName, String[] startupProperties, String[] startupArgs, boolean startServer) {
        ServerPropertiesTest spt = new ServerPropertiesTest(testName);
        String[] startupProps = startupProperties == null ? new String[]{} : startupProperties;
        if (startupArgs == null) {
            startupArgs = new String[]{};
        }
        NetworkServerTestSetup networkServerTestSetup = startServer ? new NetworkServerTestSetup((Test)spt, startupProps, startupArgs, true) : new NetworkServerTestSetup((Test)spt, true, false);
        Test test = ServerPropertiesTest.decorateWithPolicy((Test)networkServerTestSetup);
        test = TestConfiguration.defaultServerDecorator(test);
        return test;
    }

    private String makeServerPolicyName() {
        try {
            String userDir = ServerPropertiesTest.getSystemProperty("user.dir");
            String fileName = userDir + File.separator + "extinout" + File.separator + TARGET_POLICY_FILE_NAME;
            File file = new File(fileName);
            String urlString = file.toURL().toExternalForm();
            return urlString;
        }
        catch (Exception e) {
            System.out.println("Unexpected exception caught by makeServerPolicyName(): " + e);
            return null;
        }
    }

    private static Test decorateWithPolicy(Test test) {
        String serverPolicyName = new ServerPropertiesTest("test").makeServerPolicyName();
        test = new SecurityManagerSetup((Test)test, serverPolicyName);
        test = new SupportFilesSetup((Test)test, null, new String[]{POLICY_FILE_NAME}, null, new String[]{TARGET_POLICY_FILE_NAME});
        return test;
    }

    private static Properties getTheProperties() {
        Properties p;
        try {
            p = NetworkServerTestSetup.getNetworkServerControl().getCurrentProperties();
        }
        catch (Exception e) {
            p = null;
            e.printStackTrace();
            ServerPropertiesTest.fail((String)"unexpected exception getting properties from server");
        }
        return p;
    }

    private static void verifyProperties(String expectedPropAndValue) {
        Properties p = ServerPropertiesTest.getTheProperties();
        ServerPropertiesTest.assertPropertyValueCorrect(p, expectedPropAndValue);
        p = null;
    }

    private static void verifyProperties(String[] expectedValues) {
        int i;
        Properties p = ServerPropertiesTest.getTheProperties();
        for (i = 0; i < expectedValues.length; ++i) {
            ServerPropertiesTest.println("expV: " + expectedValues[i]);
        }
        ServerPropertiesTest.assertEquals((int)expectedValues.length, (int)p.size());
        for (i = 0; i < expectedValues.length; ++i) {
            ServerPropertiesTest.assertPropertyValueCorrect(p, expectedValues[i]);
        }
        p = null;
    }

    private static void assertPropertyValueCorrect(Properties p, String expectedPropAndValue) {
        String[] expPropValueString = expectedPropAndValue.split("=");
        try {
            String actualPropertyValue = p.getProperty(expPropValueString[0]);
            ServerPropertiesTest.println("exppropName: " + expPropValueString[0]);
            ServerPropertiesTest.println("exppropValue: " + expPropValueString[1]);
            ServerPropertiesTest.println("actualpropValue: " + actualPropertyValue);
            ServerPropertiesTest.assertEquals((String)expPropValueString[1], (String)actualPropertyValue);
        }
        catch (Exception e) {
            ServerPropertiesTest.fail((String)("could not find property " + expPropValueString[0]));
        }
    }

    private boolean canPingServer(int port, boolean expectServerUp) throws SQLException {
        boolean serverUp = false;
        try {
            serverUp = NetworkServerTestSetup.pingForServerUp(NetworkServerTestSetup.getNetworkServerControl(port), null, expectServerUp);
        }
        catch (Exception e) {
            ServerPropertiesTest.fail((String)"unexpected Exception while pinging");
        }
        return serverUp;
    }

    private String shutdownServer(int port, boolean specifyPort) throws SQLException {
        try {
            if (specifyPort) {
                NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl(port);
                nsctrl.shutdown();
            } else {
                NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControlDefault();
                nsctrl.shutdown();
            }
        }
        catch (Exception e) {
            return "failed to shutdown server with API parameter (" + e + ")";
        }
        if (this.canPingServer(port, false)) {
            return "Can still ping server";
        }
        return null;
    }

    public String startServer(int port, boolean specifyPort) throws SQLException {
        try {
            if (specifyPort) {
                NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl(port);
                nsctrl.start(null);
                NetworkServerTestSetup.waitForServerStart(nsctrl);
            } else {
                NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControlDefault();
                nsctrl.start(null);
                NetworkServerTestSetup.waitForServerStart(nsctrl);
            }
        }
        catch (Exception e) {
            return "failed to start server with port " + port;
        }
        if (!this.canPingServer(port, true)) {
            return "Cannot ping server started with port set to " + port;
        }
        return null;
    }

    public void checkWhetherNeedToShutdown(int[] ports, String failReason) {
        this.portsSoFar = ports;
        if (failReason != null) {
            ServerPropertiesTest.fail((String)failReason);
        }
    }

    private void assertSuccessfulCmd(String expectedString, String[] Cmd) throws InterruptedException, IOException {
        ServerPropertiesTest.assertExecJavaCmdAsExpected(new String[]{expectedString}, Cmd, 0);
    }

    public void ttestSetPortPriority() throws SQLException, InterruptedException, IOException {
        NetworkServerTestSetup.setWaitTime(0L);
        if (this.canPingServer(this.basePort, false)) {
            this.shutdownServer(this.basePort, false);
        }
        NetworkServerTestSetup.setDefaultWaitTime();
        String actionResult = this.startServer(this.basePort, true);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort}, actionResult);
        int firstAlternatePort = TestConfiguration.getCurrent().getNextAvailablePort();
        final Properties derbyProperties = new Properties();
        derbyProperties.put("derby.drda.portNumber", new Integer(firstAlternatePort).toString());
        final String derbyHome = ServerPropertiesTest.getSystemProperty("derby.system.home");
        Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean fail = false;
                try {
                    FileOutputStream propFile = new FileOutputStream(derbyHome + File.separator + "derby.properties");
                    derbyProperties.store(propFile, "testing derby.properties");
                    propFile.close();
                }
                catch (IOException ioe) {
                    fail = true;
                }
                return new Boolean(fail);
            }
        });
        if (b.booleanValue()) {
            this.checkWhetherNeedToShutdown(new int[]{TestConfiguration.getCurrent().getPort()}, "failed to write derby.properties");
        }
        TestConfiguration.getCurrent().shutdownEngine();
        actionResult = this.startServer(firstAlternatePort, false);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, firstAlternatePort}, actionResult);
        int secondAlternatePort = TestConfiguration.getCurrent().getNextAvailablePort();
        ServerPropertiesTest.setSystemProperty("derby.drda.portNumber", new Integer(secondAlternatePort).toString());
        actionResult = this.startServer(secondAlternatePort, false);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, firstAlternatePort, secondAlternatePort}, actionResult);
        int thirdAlternatePort = TestConfiguration.getCurrent().getNextAvailablePort();
        actionResult = this.startServer(thirdAlternatePort, true);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, firstAlternatePort, secondAlternatePort, thirdAlternatePort}, actionResult);
        int fourthAlternatePort = TestConfiguration.getCurrent().getNextAvailablePort();
        String[] commandArray = new String[]{"-Dderby.system.home=" + derbyHome, "org.apache.derby.drda.NetworkServerControl", "-p", String.valueOf(fourthAlternatePort).toString(), "-noSecurityManager", "start"};
        ServerPropertiesTest.execJavaCmd(commandArray);
        if (!this.canPingServer(fourthAlternatePort, true)) {
            actionResult = "Can not ping server specified with -p";
        }
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, firstAlternatePort, secondAlternatePort, thirdAlternatePort, fourthAlternatePort}, actionResult);
        commandArray = new String[]{"-Dderby.system.home=" + derbyHome, "org.apache.derby.drda.NetworkServerControl", "-p", String.valueOf(fourthAlternatePort).toString(), "-noSecurityManager", "shutdown"};
        ServerPropertiesTest.execJavaCmd(commandArray);
        if (this.canPingServer(fourthAlternatePort, false)) {
            actionResult = "Can still ping server specified with -p";
        }
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, firstAlternatePort, secondAlternatePort, thirdAlternatePort, fourthAlternatePort}, actionResult);
        actionResult = this.shutdownServer(thirdAlternatePort, true);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, firstAlternatePort, secondAlternatePort, thirdAlternatePort}, actionResult);
        actionResult = this.shutdownServer(secondAlternatePort, false);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, firstAlternatePort, secondAlternatePort}, actionResult);
        ServerPropertiesTest.removeSystemProperty("derby.drda.portNumber");
        actionResult = this.shutdownServer(firstAlternatePort, false);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, firstAlternatePort}, actionResult);
        Boolean ret = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new File(derbyHome + File.separator + "derby.properties").delete();
            }
        });
        if (!ret.booleanValue()) {
            this.checkWhetherNeedToShutdown(new int[]{this.basePort, firstAlternatePort}, "unable to remove derby.properties");
        }
        TestConfiguration.getCurrent().shutdownEngine();
        actionResult = this.shutdownServer(this.basePort, true);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort}, actionResult);
    }

    public void ttestDefaultProperties() throws SQLException {
        ServerPropertiesTest.verifyProperties(new String[]{"derby.drda.maxThreads=0", "derby.drda.sslMode=off", "derby.drda.keepAlive=true", "derby.drda.minThreads=0", "derby.drda.portNumber=" + String.valueOf(TestConfiguration.getCurrent().getPort()), "derby.drda.logConnections=false", "derby.drda.timeSlice=0", "derby.drda.startNetworkServer=false", "derby.drda.host=" + String.valueOf(TestConfiguration.getCurrent().getHostName()), "derby.drda.traceAll=false"});
    }

    public void testToggleTrace() throws SQLException, IOException, InterruptedException {
        String expectedTraceOff = "derby.drda.traceAll=false";
        String expectedTraceOn = "derby.drda.traceAll=true";
        ServerPropertiesTest.verifyProperties(expectedTraceOff);
        int port = TestConfiguration.getCurrent().getPort();
        String[] traceCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "trace", "on", "-p", String.valueOf(port)};
        this.assertSuccessfulCmd("Trace turned on for all sessions.", traceCmd);
        ServerPropertiesTest.verifyProperties(expectedTraceOn);
        traceCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "trace", "off", "-p", String.valueOf(port)};
        this.assertSuccessfulCmd("Trace turned off for all sessions", traceCmd);
        ServerPropertiesTest.verifyProperties(expectedTraceOff);
    }

    public void testToggleLogConnections() throws SQLException, IOException, InterruptedException {
        String expectedLogConnectionsOff = "derby.drda.logConnections=false";
        String expectedLogConnectionsOn = "derby.drda.logConnections=true";
        ServerPropertiesTest.verifyProperties(expectedLogConnectionsOff);
        int port = TestConfiguration.getCurrent().getPort();
        String[] cmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "logconnections", "on", "-p", String.valueOf(port)};
        this.assertSuccessfulCmd("Log Connections changed to on.", cmd);
        ServerPropertiesTest.verifyProperties(expectedLogConnectionsOn);
        cmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "logconnections", "off", "-p", String.valueOf(port)};
        this.assertSuccessfulCmd("Log Connections changed to off.", cmd);
        ServerPropertiesTest.verifyProperties(expectedLogConnectionsOff);
    }
}

