/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLFeatureNotSupportedException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Driver;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Driver40UnbootedTest
extends BaseJDBCTestCase {
    private static final String SUCCESS = "Success";

    public Driver40UnbootedTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("DriverTest tests java.sql.Driver, not supported with JSR169");
        }
        Test test = TestConfiguration.embeddedSuite(Driver40UnbootedTest.class);
        return SecurityManagerSetup.noSecurityManager(test);
    }

    public static void main(String[] args) throws Exception {
        String statusMessage;
        block2: {
            Driver embeddedDriver = DriverManager.getDriver("jdbc:derby:");
            Wrapper41Driver embeddedWrapper = new Wrapper41Driver(embeddedDriver);
            statusMessage = SUCCESS;
            try {
                embeddedWrapper.getParentLogger();
                statusMessage = "getParentLogger() unexpectedly succeeded";
            }
            catch (Exception se) {
                if (se instanceof SQLFeatureNotSupportedException) break block2;
                statusMessage = "Exception was not a SQLFeatureNotSupportedException. It was a " + se.getClass().getName();
            }
        }
        System.out.print(statusMessage);
    }

    public void test_notBooted() throws Exception {
        this.getTestConfiguration();
        if (!TestConfiguration.loadingFromJars()) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        String classpath = Driver40UnbootedTest.getSystemProperty("java.class.path");
        buffer.append(Driver40UnbootedTest.getJavaExecutableName() + " -classpath ");
        buffer.append(classpath);
        buffer.append(" -Demma.verbosity.level=silent ");
        buffer.append(((Object)((Object)this)).getClass().getName());
        String command = buffer.toString();
        Driver40UnbootedTest.println("Server command is " + command);
        Process process = Runtime.getRuntime().exec(command);
        SpawnedProcess spawned = new SpawnedProcess(process, "UnbootedTest");
        Driver40UnbootedTest.assertEquals((int)0, (int)spawned.complete(false));
        Driver40UnbootedTest.assertEquals((String)SUCCESS, (String)spawned.getFullServerOutput());
    }
}

