/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BlobSetBytesBoundaryTest
extends BaseJDBCTestCase {
    private static final byte[] BOLB_CONTENT = "test".getBytes();

    public BlobSetBytesBoundaryTest(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = TestConfiguration.defaultSuite(BlobSetBytesBoundaryTest.class, false);
        return new CleanDatabaseTestSetup(suite){

            protected void decorateSQL(Statement stmt) throws SQLException {
                BlobSetBytesBoundaryTest.initializeBlobData(stmt);
            }
        };
    }

    public void testSetBytesWithTooLongLength() throws SQLException {
        Statement stmt = this.getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("select dBlob, length from BlobTable");
        rs.next();
        Blob blob = rs.getBlob(1);
        try {
            blob.setBytes(1L, new byte[]{105}, 0, 2);
            BlobSetBytesBoundaryTest.fail((String)"Wrong long length is not accepted!");
        }
        catch (SQLException sqle) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ079", sqle);
        }
        stmt.close();
    }

    public void testSetBytesByBadLengthAndOffset() throws SQLException {
        Statement stmt = this.getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("select dBlob, length from BlobTable");
        rs.next();
        Blob blob = rs.getBlob(1);
        try {
            blob.setBytes(1L, new byte[]{105, 78, 71, 85}, 1, 4);
            BlobSetBytesBoundaryTest.fail((String)"Wrong offset and length is not accepted!");
        }
        catch (SQLException sqle) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ079", sqle);
        }
        try {
            blob.setBytes(1L, new byte[100], 10, Integer.MAX_VALUE);
            BlobSetBytesBoundaryTest.fail((String)"setBytes() should fail when offset+length > bytes.length");
        }
        catch (SQLException sqle) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ079", sqle);
        }
        stmt.close();
    }

    public void testSetBytesWithZeroLength() throws SQLException {
        Statement stmt = this.getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("select dBlob, length from BlobTable");
        rs.next();
        Blob blob = rs.getBlob(1);
        int actualLength = blob.setBytes(1L, new byte[]{105}, 0, 0);
        BlobSetBytesBoundaryTest.assertEquals((String)"return zero for zero length", (int)0, (int)actualLength);
        stmt.close();
    }

    public void testSetBytesWithNonPositiveLength() throws SQLException {
        Statement stmt = this.getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("select dBlob, length from BlobTable");
        rs.next();
        Blob blob = rs.getBlob(1);
        try {
            blob.setBytes(1L, new byte[]{105}, 0, -1);
            BlobSetBytesBoundaryTest.fail((String)"Nonpositive Length is not sccepted!");
        }
        catch (SQLException sqle) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ071", sqle);
        }
        stmt.close();
    }

    public void testSetBytesWithInvalidOffset() throws SQLException {
        Statement stmt = this.getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("select dBlob, length from BlobTable");
        rs.next();
        Blob blob = rs.getBlob(1);
        try {
            blob.setBytes(1L, new byte[]{11}, -1, 1);
            BlobSetBytesBoundaryTest.fail((String)"Invalid offset Length is not sccepted!");
        }
        catch (SQLException sqle) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ078", sqle);
        }
        try {
            blob.setBytes(1L, new byte[]{11}, 2, 1);
            BlobSetBytesBoundaryTest.fail((String)"Invalid offset Length is not sccepted!");
        }
        catch (SQLException sqle) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ078", sqle);
        }
        try {
            blob.setBytes(1L, new byte[]{11, 14}, Integer.MAX_VALUE, 1);
            BlobSetBytesBoundaryTest.fail((String)"Invalid offset Length is not sccepted!");
        }
        catch (SQLException sqle) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ078", sqle);
        }
        stmt.close();
    }

    public void testSetBytesWithEmptyBytes() throws SQLException {
        Statement stmt = this.getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("select dBlob, length from BlobTable");
        rs.next();
        Blob blob = rs.getBlob(1);
        BlobSetBytesBoundaryTest.assertEquals((int)0, (int)blob.setBytes(1L, new byte[0]));
        stmt.close();
    }

    public void testSetBytesWithTooBigPos() throws SQLException {
        Statement stmt = this.getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("select dBlob, length from BlobTable");
        rs.next();
        Blob blob = rs.getBlob(1);
        try {
            blob.setBytes(Integer.MAX_VALUE, new byte[]{15});
            BlobSetBytesBoundaryTest.fail((String)"Too big position is not sccepted!");
        }
        catch (SQLException sqle) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ076", sqle);
        }
        try {
            blob.setBytes(BOLB_CONTENT.length + 2, new byte[]{15});
            BlobSetBytesBoundaryTest.fail((String)"Too big position is not sccepted!");
        }
        catch (SQLException sqle) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ076", sqle);
        }
        stmt.close();
    }

    public void testSetBytesWithNonpositivePos() throws SQLException {
        Statement stmt = this.getConnection().createStatement();
        ResultSet rs = stmt.executeQuery("select dBlob, length from BlobTable");
        rs.next();
        Blob blob = rs.getBlob(1);
        try {
            blob.setBytes(0L, new byte[]{15});
            BlobSetBytesBoundaryTest.fail((String)"Nonpositive position is not sccepted!");
        }
        catch (SQLException sqle) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ070", sqle);
        }
        try {
            blob.setBytes(-1L, new byte[]{15});
            BlobSetBytesBoundaryTest.fail((String)"Nonpositive position is not sccepted!");
        }
        catch (SQLException sqle) {
            BlobSetBytesBoundaryTest.assertSQLState("XJ070", sqle);
        }
        stmt.close();
    }

    private static void initializeBlobData(Statement stmt) throws SQLException {
        Connection con = stmt.getConnection();
        con.setAutoCommit(false);
        try {
            stmt.executeUpdate("drop table BlobTable");
        }
        catch (SQLException sqle) {
            BlobSetBytesBoundaryTest.assertSQLState("42Y55", sqle);
        }
        stmt.executeUpdate("create table BlobTable (dBlob Blob, length int)");
        PreparedStatement smallBlobInsert = con.prepareStatement("insert into BlobTable values (?,?)");
        smallBlobInsert.setBytes(1, BOLB_CONTENT);
        smallBlobInsert.setInt(2, BOLB_CONTENT.length);
        smallBlobInsert.executeUpdate();
        con.commit();
    }
}

