/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RelativeTest
extends BaseJDBCTestCase {
    public RelativeTest(String name) {
        super(name);
    }

    public void testScrolling_CONCUR_READ_ONLY() throws SQLException {
        int concurrency = 1007;
        Statement stmt1 = this.createStatement(1004, concurrency);
        ResultSet rs = stmt1.executeQuery("select * from testRelative");
        rs.next();
        RelativeTest.assertEquals((String)"work1", (String)rs.getString("name"));
        rs.relative(2);
        RelativeTest.assertEquals((String)"work3", (String)rs.getString("name"));
        RelativeTest.assertEquals((boolean)false, (boolean)rs.isFirst());
        RelativeTest.assertEquals((boolean)false, (boolean)rs.isLast());
        RelativeTest.assertEquals((boolean)false, (boolean)rs.isAfterLast());
        rs.relative(-2);
        RelativeTest.assertEquals((String)"work1", (String)rs.getString("name"));
        rs.relative(10);
        try {
            rs.getString("name");
            RelativeTest.fail((String)"FAIL - Attempting to read from an invalid row should have thrown an exception");
        }
        catch (SQLException sqle) {
            String NO_CURRENT_ROW_SQL_STATE = "";
            NO_CURRENT_ROW_SQL_STATE = RelativeTest.usingDerbyNetClient() ? "XJ121" : "24000";
            RelativeTest.assertSQLState(NO_CURRENT_ROW_SQL_STATE, sqle);
        }
    }

    public void testScrolling_CONCUR_UPDATABLE() throws SQLException {
        int concurrency = 1008;
        Statement stmt1 = this.createStatement(1004, concurrency);
        ResultSet rs = stmt1.executeQuery("select * from testRelative");
        rs.next();
        RelativeTest.assertEquals((String)"work1", (String)rs.getString("name"));
        rs.relative(2);
        RelativeTest.assertEquals((String)"work3", (String)rs.getString("name"));
        RelativeTest.assertEquals((boolean)false, (boolean)rs.isFirst());
        RelativeTest.assertEquals((boolean)false, (boolean)rs.isLast());
        RelativeTest.assertEquals((boolean)false, (boolean)rs.isAfterLast());
        rs.relative(-2);
        RelativeTest.assertEquals((String)"work1", (String)rs.getString("name"));
        rs.relative(10);
        try {
            rs.getString("name");
            RelativeTest.fail((String)"FAIL - Attempting to read from an invalid row should have thrown an exception");
        }
        catch (SQLException sqle) {
            String NO_CURRENT_ROW_SQL_STATE = "";
            NO_CURRENT_ROW_SQL_STATE = RelativeTest.usingDerbyNetClient() ? "XJ121" : "24000";
            RelativeTest.assertSQLState(NO_CURRENT_ROW_SQL_STATE, sqle);
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("RelativeTest");
        suite.addTest(RelativeTest.baseSuite("RelativeTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(RelativeTest.baseSuite("RelativeTest:client")));
        return suite;
    }

    private static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(RelativeTest.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)suite, 2, 4)){

            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.execute("create table testRelative(name varchar(10), i int)");
                stmt.execute("insert into testRelative values ('work1', NULL)");
                stmt.execute("insert into testRelative values ('work2', NULL)");
                stmt.execute("insert into testRelative values ('work3', NULL)");
                stmt.execute("insert into testRelative values ('work4', NULL)");
            }
        };
    }
}

