/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UpdatableResultSetTest
extends BaseJDBCTestCase {
    private static final byte[] BYTES1 = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
    private static final byte[] BYTES2 = new byte[]{105, 104, 103, 102, 101, 101, 102, 103, 104, 105};
    private static int insertKey = 0;
    private int key = -1;

    public UpdatableResultSetTest(String name) {
        super(name);
    }

    protected void setUp() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.execute("create table UpdateTestTableResultSet (sno int not null unique,dBlob BLOB,dClob CLOB,dLongVarchar LONG VARCHAR,dLongBit LONG VARCHAR FOR BIT DATA)");
        stmt.executeUpdate("create table \"my \"\"quoted\"\" table\" (x int)");
        stmt.executeUpdate("insert into \"my \"\"quoted\"\" table\" (x) values (1), (2), (3)");
        stmt.executeUpdate("create table \"my quoted columns\" (\"my \"\"quoted\"\" column\" int)");
        stmt.executeUpdate("insert into \"my quoted columns\" values (1), (2), (3) ");
        stmt.executeUpdate("create table \"my \"\"quoted\"\" schema\".\"my quoted schema\" (x int)");
        stmt.executeUpdate("insert into \"my \"\"quoted\"\" schema\".\"my quoted schema\" values (1), (2), (3) ");
        stmt.executeUpdate("create table \"my table\" (x int)");
        stmt.executeUpdate("insert into \"my table\" values (1), (2), (3) ");
        stmt.close();
    }

    public static Test suite() {
        if (UpdatableResultSetTest.usingDB2Client()) {
            return new TestSuite();
        }
        return TestConfiguration.defaultSuite(UpdatableResultSetTest.class);
    }

    public void testInsertRowOnQuotedTable() throws SQLException {
        ResultSet rs = null;
        Statement stmt = this.createStatement(1003, 1008);
        rs = stmt.executeQuery("select * from \"my \"\"quoted\"\" table\"");
        rs.next();
        rs.moveToInsertRow();
        rs.updateInt(1, 4);
        rs.insertRow();
        rs.moveToCurrentRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my \"\"quoted\"\" table\" order by x");
        for (int i = 1; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)rs.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void testUpdateRowOnQuotedTable() throws SQLException {
        ResultSet rs = null;
        Statement stmt = this.createStatement(1003, 1008);
        rs = stmt.executeQuery("select * from \"my \"\"quoted\"\" table\"");
        rs.next();
        rs.updateInt(1, 4);
        rs.updateRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my \"\"quoted\"\" table\" order by x");
        for (int i = 2; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)rs.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void testDeleteRowOnQuotedTable() throws SQLException {
        ResultSet rs = null;
        Statement stmt = this.createStatement(1003, 1008);
        rs = stmt.executeQuery("select * from \"my \"\"quoted\"\" table\"");
        rs.next();
        rs.deleteRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my \"\"quoted\"\" table\" order by x");
        for (int i = 2; i <= 3; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)rs.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void testInsertRowOnQuotedColumn() throws SQLException {
        ResultSet rs = null;
        Statement stmt = this.createStatement(1003, 1008);
        rs = stmt.executeQuery("select * from \"my quoted columns\"");
        rs.next();
        rs.moveToInsertRow();
        rs.updateInt(1, 4);
        rs.insertRow();
        rs.moveToCurrentRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my quoted columns\" order by \"my \"\"quoted\"\" column\"");
        for (int i = 1; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)rs.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void testUpdateRowOnQuotedColumn() throws SQLException {
        ResultSet rs = null;
        Statement stmt = this.createStatement(1003, 1008);
        rs = stmt.executeQuery("select * from \"my quoted columns\"");
        rs.next();
        rs.updateInt(1, 4);
        rs.updateRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my quoted columns\" order by \"my \"\"quoted\"\" column\"");
        for (int i = 2; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)rs.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void testDeleteRowOnQuotedColumn() throws SQLException {
        ResultSet rs = null;
        Statement stmt = this.createStatement(1003, 1008);
        rs = stmt.executeQuery("select * from \"my quoted columns\"");
        rs.next();
        rs.deleteRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my quoted columns\" order by \"my \"\"quoted\"\" column\"");
        for (int i = 2; i <= 3; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)rs.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void testInsertRowOnQuotedSchema() throws SQLException {
        ResultSet rs = null;
        Statement stmt = this.createStatement(1003, 1008);
        rs = stmt.executeQuery("select * from \"my \"\"quoted\"\" schema\".\"my quoted schema\"");
        rs.next();
        rs.moveToInsertRow();
        rs.updateInt(1, 4);
        rs.insertRow();
        rs.moveToCurrentRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my \"\"quoted\"\" schema\".\"my quoted schema\" order by x");
        for (int i = 1; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)rs.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void testUpdateRowOnQuotedSchema() throws SQLException {
        ResultSet rs = null;
        Statement stmt = this.createStatement(1003, 1008);
        rs = stmt.executeQuery("select * from \"my \"\"quoted\"\" schema\".\"my quoted schema\"");
        rs.next();
        rs.updateInt(1, 4);
        rs.updateRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my \"\"quoted\"\" schema\".\"my quoted schema\" order by x");
        for (int i = 2; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)rs.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void testDeleteRowOnQuotedSchema() throws SQLException {
        ResultSet rs = null;
        Statement stmt = this.createStatement(1003, 1008);
        rs = stmt.executeQuery("select * from \"my \"\"quoted\"\" schema\".\"my quoted schema\"");
        rs.next();
        rs.deleteRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my \"\"quoted\"\" schema\".\"my quoted schema\" order by x");
        for (int i = 2; i <= 3; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)rs.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void testInsertRowOnQuotedCursor() throws SQLException {
        ResultSet rs = null;
        Statement stmt = this.createStatement(1003, 1008);
        stmt.setCursorName("my \"\"\"\"quoted\"\"\"\" cursor\"\"");
        rs = stmt.executeQuery("select * from \"my table\"");
        rs.next();
        rs.moveToInsertRow();
        rs.updateInt(1, 4);
        rs.insertRow();
        rs.moveToCurrentRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my table\" order by x");
        for (int i = 1; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)rs.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void testUpdateRowOnQuotedCursor() throws SQLException {
        ResultSet rs = null;
        Statement stmt = this.createStatement(1003, 1008);
        stmt.setCursorName("\"\"my quoted cursor");
        rs = stmt.executeQuery("select * from \"my table\"");
        rs.next();
        rs.updateInt(1, 4);
        rs.updateRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my table\" order by x");
        for (int i = 2; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)rs.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void testDeleteRowOnQuotedCursor() throws SQLException {
        ResultSet rs = null;
        Statement stmt = this.createStatement(1003, 1008);
        stmt.setCursorName("\"\"my quoted cursor\"\"");
        rs = stmt.executeQuery("select * from \"my table\"");
        rs.next();
        rs.deleteRow();
        rs.close();
        rs = stmt.executeQuery("select * from \"my table\" order by x");
        for (int i = 2; i <= 3; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)rs.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)rs.getInt(1));
        }
        rs.close();
        stmt.close();
    }

    public void testUpdateBlob() throws Exception {
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dBlob");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, (InputStream)is1, BYTES1.length);
        ps_sb.executeUpdate();
        int key2 = UpdatableResultSetTest.requestKey();
        ps_sb.setInt(1, key2);
        ps_sb.setBinaryStream(2, (InputStream)is2, BYTES2.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetch("dBlob", this.key);
        rs1.next();
        Blob blob = rs1.getBlob(1);
        rs1.close();
        rs1 = this.fetchUpd("dBlob", key2);
        rs1.next();
        rs1.updateBlob(1, blob);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dBlob", key2);
        rs1.next();
        UpdatableResultSetTest.assertEquals(blob, rs1.getBlob(1));
        rs1.close();
    }

    public void testUpdateBlobStringParameterName() throws Exception {
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dBlob");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, (InputStream)is1, BYTES1.length);
        ps_sb.executeUpdate();
        int key2 = UpdatableResultSetTest.requestKey();
        ps_sb.setInt(1, key2);
        ps_sb.setBinaryStream(2, (InputStream)is2, BYTES2.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetch("dBlob", this.key);
        rs1.next();
        Blob blob = rs1.getBlob(1);
        rs1.close();
        rs1 = this.fetchUpd("dBlob", key2);
        rs1.next();
        rs1.updateBlob("dBlob", blob);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dBlob", key2);
        rs1.next();
        UpdatableResultSetTest.assertEquals(blob, rs1.getBlob(1));
        rs1.close();
    }

    public void testUpdateClob() throws Exception {
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dClob");
        ps_sb.setInt(1, this.key);
        ps_sb.setAsciiStream(2, (InputStream)is1, BYTES1.length);
        ps_sb.executeUpdate();
        int key2 = UpdatableResultSetTest.requestKey();
        ps_sb.setInt(1, key2);
        ps_sb.setAsciiStream(2, (InputStream)is2, BYTES2.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dClob", this.key);
        rs1.next();
        Clob clob = rs1.getClob(1);
        rs1.close();
        rs1 = this.fetchUpd("dClob", key2);
        rs1.next();
        rs1.updateClob(1, clob);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dClob", key2);
        rs1.next();
        UpdatableResultSetTest.assertEquals(clob, rs1.getClob(1));
        rs1.close();
    }

    public void testUpdateClobStringParameterName() throws Exception {
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dClob");
        ps_sb.setInt(1, this.key);
        ps_sb.setAsciiStream(2, (InputStream)is1, BYTES1.length);
        ps_sb.executeUpdate();
        int key2 = UpdatableResultSetTest.requestKey();
        ps_sb.setInt(1, key2);
        ps_sb.setAsciiStream(2, (InputStream)is2, BYTES2.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetch("dClob", this.key);
        rs1.next();
        Clob clob = rs1.getClob(1);
        rs1.close();
        rs1 = this.fetchUpd("dClob", key2);
        rs1.next();
        rs1.updateClob("dClob", clob);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dClob", key2);
        rs1.next();
        UpdatableResultSetTest.assertEquals(clob, rs1.getClob(1));
        rs1.close();
    }

    private static final int requestKey() {
        return ++insertKey;
    }

    private PreparedStatement prep(String colName) throws SQLException {
        return this.prepareStatement("insert into UpdateTestTableResultSet (sno, " + colName + ") values (?,?)");
    }

    private ResultSet fetchUpd(String colName, int key) throws SQLException {
        Statement stmt = this.createStatement(1003, 1008);
        return stmt.executeQuery("select " + colName + " from UpdateTestTableResultSet where sno = " + key + " for update");
    }

    private ResultSet fetch(String colName, int key) throws SQLException {
        Statement stmt = this.createStatement();
        return stmt.executeQuery("select " + colName + " from UpdateTestTableResultSet where sno = " + key);
    }
}

