/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Collator;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.BatchUpdateTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest;
import org.apache.derbyTesting.functionTests.tests.lang.GroupByExpressionTest;
import org.apache.derbyTesting.functionTests.tests.lang.UpdatableResultSetTest;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public class CollationTest
extends BaseJDBCTestCase {
    private static final String[] NAMES = new String[]{"Smith", "Zebra", "\u0104corn", "\u017bebra", "Acorn", "\u015amith", "aacorn"};

    public CollationTest(String name) {
        super(name);
    }

    public void testDefaultCollation() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement s = this.createStatement();
        this.setUpTable(s);
        this.checkLangBasedQuery(s, "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')", new String[][]{{"UCS_BASIC"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER ORDER BY NAME", new String[][]{{"4", "Acorn"}, {"0", "Smith"}, {"1", "Zebra"}, {"6", "aacorn"}, {"2", "\u0104corn"}, {"5", "\u015amith"}, {"3", "\u017bebra"}});
        s.executeUpdate("CREATE FUNCTION mimic(val VARCHAR(32000)) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.CollationTest.mimic' LANGUAGE JAVA PARAMETER STYLE JAVA");
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER ORDER BY MIMIC(NAME)", new String[][]{{"4", "Acorn"}, {"0", "Smith"}, {"1", "Zebra"}, {"6", "aacorn"}, {"2", "\u0104corn"}, {"5", "\u015amith"}, {"3", "\u017bebra"}});
        s.executeUpdate("DROP FUNCTION mimic");
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' = 'Acorn' ", null);
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' < 'Acorn' ", null);
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER WHERE NAME <= 'Smith' ", new String[][]{{"0", "Smith"}, {"4", "Acorn"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER WHERE NAME between 'Acorn' and 'Zebra' ", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"4", "Acorn"}});
        s.executeUpdate("set schema SYS");
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM APP.CUSTOMER WHERE NAME <= 'Smith' ", new String[][]{{"0", "Smith"}, {"4", "Acorn"}});
        s.executeUpdate("set schema APP");
        this.checkLangBasedQuery(s, "SELECT 1 FROM SYS.SYSTABLES WHERE  TABLENAME = 'CUSTOMER' ", new String[][]{{"1"}});
        this.checkLangBasedQuery(s, "SELECT 1 FROM SYS.SYSTABLES WHERE CAST  (TABLENAME AS CHAR(15)) = 'CUSTOMER' ", new String[][]{{"1"}});
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE CASE  WHEN 1=1 THEN TABLENAME ELSE 'c' END = 'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE CAST  ((CASE WHEN 1=1 THEN TABLENAME ELSE 'c' END) AS CHAR(12)) =  'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TABLENAME || ' ' = 'SYSCOLUMNS '", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST (TABLENAME || ' ' AS CHAR(12)) =  'SYSCOLUMNS '", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  COALESCE(TABLENAME, 'c') = 'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST (COALESCE (TABLENAME, 'c') AS CHAR(12)) =  'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  NULLIF(TABLENAME, 'c') = 'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST (NULLIF (TABLENAME, 'c') AS CHAR(12)) =  'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(s, "SELECT count(*) FROM CUSTOMER WHERE CURRENT_USER = 'APP'", new String[][]{{"7"}});
        this.checkLangBasedQuery(s, "SELECT MAX(NAME) maxName FROM CUSTOMER ORDER BY maxName ", new String[][]{{"\u017bebra"}});
        this.checkLangBasedQuery(s, "SELECT MIN(NAME) minName FROM CUSTOMER ORDER BY minName ", new String[][]{{"Acorn"}});
        s.executeUpdate("set schema SYS");
        this.checkLangBasedQuery(s, "SELECT CHAR(ID) FROM APP.CUSTOMER WHERE  CHAR(ID)='0'", new String[][]{{"0"}});
        s.executeUpdate("set schema APP");
        if (XML.classpathMeetsXMLReqs()) {
            this.checkLangBasedQuery(s, "SELECT XMLSERIALIZE(x as CHAR(10))  FROM xmlTable, SYS.SYSTABLES WHERE  XMLSERIALIZE(x as CHAR(10)) = TABLENAME", null);
        }
        s.executeUpdate("set schema APP");
        PreparedStatement ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  ? = TABLENAME");
        ps.setString(1, "SYSCOLUMNS");
        ResultSet rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"SYSCOLUMNS"}});
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  SUBSTR(?,2) = TABLENAME");
        ps.setString(1, " SYSCOLUMNS");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"SYSCOLUMNS"}});
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  LTRIM(?) = TABLENAME");
        ps.setString(1, " SYSCOLUMNS");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"SYSCOLUMNS"}});
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  RTRIM(?) = TABLENAME");
        ps.setString(1, "SYSCOLUMNS  ");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"SYSCOLUMNS"}});
        ps = this.prepareStatement("SELECT COUNT(*) FROM CUSTOMER WHERE  ? IN (SELECT TABLENAME FROM SYS.SYSTABLES)");
        ps.setString(1, "SYSCOLUMNS");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"7"}});
        s.close();
        this.compareAgrave(1, 1, 2);
    }

    public void testFrenchCollation() throws SQLException {
        this.compareAgrave(2, 1, 1);
    }

    private void compareAgrave(int expectedMatchCountForEqual, int expectedMatchCountForLike, int expectedDistinctRows) throws SQLException {
        String[] dataTypes = new String[]{"VARCHAR(5)", "CHAR(5)"};
        for (int i = 0; i < dataTypes.length; ++i) {
            this.compareAgrave(dataTypes[i], expectedMatchCountForEqual, expectedMatchCountForLike, expectedDistinctRows);
        }
    }

    private void compareAgrave(String dataType, int expectedMatchCountForEqual, int expectedMatchCountForLike, int expectedDistinctRows) throws SQLException {
        String agrave = "\u00c0";
        String agraveCombined = "A\u0300";
        Statement s = this.createStatement();
        try {
            s.executeUpdate("DROP TABLE T");
        }
        catch (SQLException se) {
            // empty catch block
        }
        s.executeUpdate("CREATE TABLE T (vc " + dataType + ")");
        PreparedStatement ps = this.prepareStatement("INSERT INTO T VALUES (?)");
        ps.setString(1, agrave);
        ps.executeUpdate();
        ps.setString(1, agraveCombined);
        ps.executeUpdate();
        ps = this.prepareStatement("SELECT COUNT(*) FROM T WHERE VC = ?");
        ps.setString(1, agrave);
        ResultSet rs = ps.executeQuery();
        JDBC.assertSingleValueResultSet(rs, Integer.toString(expectedMatchCountForEqual));
        ps = this.prepareStatement("SELECT COUNT(*) FROM T WHERE VC LIKE ? || '%'");
        ps.setString(1, agrave);
        rs = ps.executeQuery();
        JDBC.assertSingleValueResultSet(rs, Integer.toString(expectedMatchCountForLike));
        int distinctRows = JDBC.assertDrainResults(s.executeQuery("SELECT DISTINCT VC FROM T"));
        CollationTest.assertEquals((String)"Unexpected number of distinct rows", (int)expectedDistinctRows, (int)distinctRows);
    }

    public void testPolishCollation() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        this.setUpTable(s);
        this.checkLangBasedQuery(s, "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')", new String[][]{{"TERRITORY_BASED"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER ORDER BY NAME", new String[][]{{"6", "aacorn"}, {"4", "Acorn"}, {"2", "\u0104corn"}, {"0", "Smith"}, {"5", "\u015amith"}, {"1", "Zebra"}, {"3", "\u017bebra"}});
        s.executeUpdate("CREATE FUNCTION mimic(val VARCHAR(32000)) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.CollationTest.mimic' LANGUAGE JAVA PARAMETER STYLE JAVA");
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER ORDER BY MIMIC(NAME)", new String[][]{{"6", "aacorn"}, {"4", "Acorn"}, {"2", "\u0104corn"}, {"0", "Smith"}, {"5", "\u015amith"}, {"1", "Zebra"}, {"3", "\u017bebra"}});
        s.executeUpdate("DROP FUNCTION mimic");
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' = 'Acorn' ", null);
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' < 'Acorn'", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"2", "\u0104corn"}, {"3", "\u017bebra"}, {"4", "Acorn"}, {"5", "\u015amith"}, {"6", "aacorn"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER WHERE NAME <= 'Smith' ", new String[][]{{"0", "Smith"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"6", "aacorn"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER WHERE NAME between 'Acorn' and 'Zebra' ", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"5", "\u015amith"}});
        s.executeUpdate("set schema SYS");
        CollationTest.assertStatementError("42818", s, "SELECT ID, NAME FROM APP.CUSTOMER WHERE NAME <= 'Smith' ");
        s.executeUpdate("set schema APP");
        this.checkLangBasedQuery(s, "SELECT MAX(NAME) maxName FROM CUSTOMER ORDER BY maxName ", new String[][]{{"\u017bebra"}});
        this.checkLangBasedQuery(s, "SELECT MIN(NAME) minName FROM CUSTOMER ORDER BY minName ", new String[][]{{"aacorn"}});
        this.commonTestingForTerritoryBasedDB(s);
    }

    public void testNorwayCollation() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        this.setUpTable(s);
        this.checkLangBasedQuery(s, "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')", new String[][]{{"TERRITORY_BASED"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER ORDER BY NAME", new String[][]{{"4", "Acorn"}, {"2", "\u0104corn"}, {"0", "Smith"}, {"5", "\u015amith"}, {"1", "Zebra"}, {"3", "\u017bebra"}, {"6", "aacorn"}});
        s.executeUpdate("CREATE FUNCTION mimic(val VARCHAR(32000)) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.CollationTest.mimic' LANGUAGE JAVA PARAMETER STYLE JAVA");
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER ORDER BY MIMIC(NAME)", new String[][]{{"4", "Acorn"}, {"2", "\u0104corn"}, {"0", "Smith"}, {"5", "\u015amith"}, {"1", "Zebra"}, {"3", "\u017bebra"}, {"6", "aacorn"}});
        s.executeUpdate("DROP FUNCTION mimic");
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' = 'Acorn' ", null);
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' < 'Acorn' ", null);
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER WHERE NAME <= 'Smith' ", new String[][]{{"0", "Smith"}, {"2", "\u0104corn"}, {"4", "Acorn"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER WHERE NAME between 'Acorn' and 'Zebra' ", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"5", "\u015amith"}});
        s.executeUpdate("set schema SYS");
        CollationTest.assertStatementError("42818", s, "SELECT ID, NAME FROM APP.CUSTOMER WHERE NAME <= 'Smith' ");
        s.executeUpdate("set schema APP");
        this.checkLangBasedQuery(s, "SELECT MAX(NAME) maxName FROM CUSTOMER ORDER BY maxName ", new String[][]{{"aacorn"}});
        this.checkLangBasedQuery(s, "SELECT MIN(NAME) minName FROM CUSTOMER ORDER BY minName ", new String[][]{{"Acorn"}});
        this.commonTestingForTerritoryBasedDB(s);
        s.close();
    }

    public void testEnglishCollation() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        this.setUpTable(s);
        this.checkLangBasedQuery(s, "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')", new String[][]{{"TERRITORY_BASED"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER ORDER BY NAME", new String[][]{{"6", "aacorn"}, {"4", "Acorn"}, {"2", "\u0104corn"}, {"0", "Smith"}, {"5", "\u015amith"}, {"1", "Zebra"}, {"3", "\u017bebra"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' = 'Acorn' ", null);
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' < 'Acorn'", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"2", "\u0104corn"}, {"3", "\u017bebra"}, {"4", "Acorn"}, {"5", "\u015amith"}, {"6", "aacorn"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER WHERE NAME <= 'Smith' ", new String[][]{{"0", "Smith"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"6", "aacorn"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER WHERE NAME between 'Acorn' and 'Zebra' ", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"5", "\u015amith"}});
        s.executeUpdate("set schema SYS");
        CollationTest.assertStatementError("42818", s, "SELECT ID, NAME FROM APP.CUSTOMER WHERE NAME <= 'Smith' ");
        s.executeUpdate("set schema APP");
        this.checkLangBasedQuery(s, "SELECT MAX(NAME) maxName FROM CUSTOMER ORDER BY maxName ", new String[][]{{"\u017bebra"}});
        this.checkLangBasedQuery(s, "SELECT MIN(NAME) minName FROM CUSTOMER ORDER BY minName ", new String[][]{{"aacorn"}});
        this.commonTestingForTerritoryBasedDB(s);
        s.close();
    }

    public void testSwedishCaseInsensitiveCollation() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        this.setUpTable(s);
        this.checkLangBasedQuery(s, "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')", new String[][]{{"TERRITORY_BASED:SECONDARY"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER ORDER BY NAME", new String[][]{{"6", "aacorn"}, {"4", "Acorn"}, {"2", "\u0104corn"}, {"0", "Smith"}, {"5", "\u015amith"}, {"1", "Zebra"}, {"3", "\u017bebra"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER where 'aacorn' = 'Acorn' ", null);
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER where NAME = 'AaCorn' ORDER BY NAME ", new String[][]{{"6", "aacorn"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER where NAME like 'a%'", new String[][]{{"4", "Acorn"}, {"6", "aacorn"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER WHERE NAME <= 'Smith' ", new String[][]{{"0", "Smith"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"6", "aacorn"}});
        this.checkLangBasedQuery(s, "SELECT ID, NAME FROM CUSTOMER WHERE NAME between 'acorn' and 'zebra' ", new String[][]{{"0", "Smith"}, {"1", "Zebra"}, {"2", "\u0104corn"}, {"4", "Acorn"}, {"5", "\u015amith"}});
        s.executeUpdate("set schema SYS");
        CollationTest.assertStatementError("42818", s, "SELECT ID, NAME FROM APP.CUSTOMER WHERE NAME <= 'Smith' ");
        s.executeUpdate("set schema APP");
        this.checkLangBasedQuery(s, "SELECT MAX(NAME) maxName FROM CUSTOMER ORDER BY maxName ", new String[][]{{"\u017bebra"}});
        this.checkLangBasedQuery(s, "SELECT MIN(NAME) minName FROM CUSTOMER ORDER BY minName ", new String[][]{{"aacorn"}});
        this.commonTestingForTerritoryBasedDB(s);
        s.close();
    }

    private void commonTestingForTerritoryBasedDB(Statement s) throws SQLException {
        Connection conn = s.getConnection();
        s.executeUpdate("set schema APP");
        CollationTest.assertStatementError("42818", s, "SELECT 1 FROM SYS.SYSTABLES WHERE  TABLENAME = 'CUSTOMER' ");
        this.checkLangBasedQuery(s, "SELECT 1 FROM SYS.SYSTABLES WHERE CAST  (TABLENAME AS CHAR(15)) = 'CUSTOMER' ", new String[][]{{"1"}});
        CollationTest.assertStatementError("42818", s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE CASE  WHEN 1=1 THEN TABLENAME ELSE 'c' END = 'SYSCOLUMNS'");
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE CAST  ((CASE WHEN 1=1 THEN TABLENAME ELSE 'c' END) AS CHAR(12)) =  'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        this.checkLangBasedQuery(s, "SELECT count(*) FROM CUSTOMER WHERE CASE WHEN  1=1 THEN NAMECHAR ELSE NAME END = NAMECHAR", new String[][]{{"7"}});
        this.checkLangBasedQuery(s, "SELECT count(*) FROM SYS.SYSTABLES WHERE CASE  WHEN 1=1 THEN TABLENAME ELSE TABLEID END = TABLENAME", new String[][]{{"25"}});
        CollationTest.assertStatementError("42818", s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TABLENAME || ' ' = 'SYSCOLUMNS '");
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST (TABLENAME || ' ' AS CHAR(12)) =  'SYSCOLUMNS '", new String[][]{{"SYSCOLUMNS"}});
        CollationTest.assertStatementError("42818", s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TABLENAME || ' ' = TABLENAME || 'SYSCOLUMNS '");
        CollationTest.assertStatementError("42818", s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  COALESCE(TABLENAME, 'c') = 'SYSCOLUMNS'");
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST (COALESCE (TABLENAME, 'c') AS CHAR(12)) =  'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        CollationTest.assertStatementError("42818", s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  NULLIF(TABLENAME, 'c') = 'SYSCOLUMNS'");
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  NULLIF (CAST (TABLENAME AS CHAR(12)), 'c' ) =  'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        s.executeUpdate("set schema SYS");
        this.checkLangBasedQuery(s, "SELECT CHAR(ID) FROM APP.CUSTOMER WHERE  CHAR(ID)='0'", new String[][]{{"0"}});
        this.checkLangBasedQuery(s, "SELECT ID FROM APP.CUSTOMER WHERE  VARCHAR(NAME)='Smith'", new String[][]{{"0"}});
        s.executeUpdate("set schema APP");
        CollationTest.assertStatementError("42818", s, "SELECT CHAR(TABLENAME) FROM  SYS.SYSTABLES WHERE CHAR(TABLENAME)= TABLENAME AND  VARCHAR(TABLENAME) = 'SYSCOLUMNS'");
        this.checkLangBasedQuery(s, "SELECT CHAR(TABLENAME) FROM SYS.SYSTABLES WHERE  CHAR(TABLENAME)= (CAST (TABLENAME AS CHAR(12))) AND  VARCHAR(TABLENAME) = 'SYSCOLUMNS'", new String[][]{{"SYSCOLUMNS"}});
        CollationTest.assertStatementError("42818", s, "SELECT count(*) FROM CUSTOMER WHERE CURRENT_USER = 'APP'");
        this.checkLangBasedQuery(s, "SELECT count(*) FROM CUSTOMER WHERE CAST(CURRENT_USER AS CHAR(12)) = 'APP'", new String[][]{{"7"}});
        this.checkLangBasedQuery(s, "SELECT count(*) FROM CUSTOMER WHERE SESSION_USER = USER", new String[][]{{"7"}});
        CollationTest.assertStatementError("42818", s, "SELECT count(*) FROM CUSTOMER WHERE CURRENT ISOLATION = 'CS'");
        this.checkLangBasedQuery(s, "SELECT count(*) FROM CUSTOMER WHERE CAST(CURRENT ISOLATION AS CHAR(12)) = 'CS'", new String[][]{{"7"}});
        s.executeUpdate("set schema SYS");
        this.checkLangBasedQuery(s, "SELECT count(*) FROM APP.CUSTOMER WHERE CURRENT SCHEMA = 'SYS'", new String[][]{{"7"}});
        s.executeUpdate("set schema APP");
        if (XML.classpathMeetsXMLReqs()) {
            CollationTest.assertStatementError("42818", s, "SELECT XMLSERIALIZE(x as CHAR(10))  FROM xmlTable, SYS.SYSTABLES WHERE  XMLSERIALIZE(x as CHAR(10)) = TABLENAME");
            this.checkLangBasedQuery(s, "SELECT XMLSERIALIZE(x as CHAR(10)) FROM  xmlTable, SYS.SYSTABLES WHERE XMLSERIALIZE(x as CHAR(10)) =  CAST(TABLENAME AS CHAR(10))", null);
            this.assertCompileError("42Z70", "SELECT XMLSERIALIZE(x as CHAR(10))  FROM xmlTable, SYS.SYSTABLES WHERE  XMLSERIALIZE(? as CHAR(10)) = TABLENAME");
            this.assertCompileError("42Z70", "SELECT XMLSERIALIZE(x as CHAR(10)) FROM  xmlTable, SYS.SYSTABLES WHERE XMLSERIALIZE(? as CHAR(10)) =  CAST(TABLENAME AS CHAR(10))");
        }
        s.executeUpdate("set schema APP");
        s.executeUpdate("CREATE FUNCTION CONCAT_NOCALL(VARCHAR(10), VARCHAR(10))  RETURNS VARCHAR(20) RETURNS NULL ON NULL INPUT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.RoutineTest.concat'  LANGUAGE JAVA PARAMETER STYLE JAVA");
        s.executeUpdate("CREATE FUNCTION AA.B() RETURNS VARCHAR(10) NO SQL PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME 'aaa.bbb.ccc' ");
        CollationTest.assertStatementError("XJ001", s, "SELECT AA.B() FROM CUSTOMER ");
        s.executeUpdate("set schema APP");
        PreparedStatement ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  ? = TABLENAME");
        ps.setString(1, "SYSCOLUMNS");
        ResultSet rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"SYSCOLUMNS"}});
        this.assertCompileError("42818", "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  SUBSTR(?,2) = TABLENAME");
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  SUBSTR(?,2) = CAST(TABLENAME AS CHAR(10))");
        ps.setString(1, "aSYSCOLUMNS");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"SYSCOLUMNS"}});
        this.assertCompileError("42ZA2", "SELECT TABLENAME FROM SYS.SYSTABLES  WHERE TABLENAME || ? LIKE 'SYSCOLUMNS '");
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST((TABLENAME || ?) AS CHAR(20)) LIKE 'SYSCOLUMNS'");
        s.executeUpdate("set schema SYS");
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES  WHERE TABLENAME || ? LIKE 'SYSCOLUMNS'");
        s.executeUpdate("set schema APP");
        CollationTest.assertStatementError("42ZA2", s, "SELECT TABLENAME FROM SYS.SYSTABLES  WHERE TABLENAME || 'AA' LIKE 'SYSCOLUMNS '");
        this.checkLangBasedQuery(s, "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST ((TABLENAME || 'AA') AS CHAR(12)) LIKE 'SYSCOLUMNS '", null);
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  ? IS NULL");
        ps.setString(1, " ");
        rs = ps.executeQuery();
        JDBC.assertEmpty(rs);
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  ? IS NOT NULL");
        ps.setNull(1, 12);
        rs = ps.executeQuery();
        JDBC.assertEmpty(rs);
        this.assertCompileError("42X36", "SELECT COUNT(*) FROM CUSTOMER WHERE  LENGTH(?) != 0");
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TABLENAME NOT BETWEEN ? AND TABLENAME");
        ps.setString(1, " ");
        rs = ps.executeQuery();
        JDBC.assertEmpty(rs);
        this.assertCompileError("42818", "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TABLENAME NOT BETWEEN ? AND 'SYSCOLUMNS'");
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  COALESCE(TABLENAME, ?) = ?");
        ps.setString(1, " ");
        ps.setString(2, "SYSCOLUMNS ");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"SYSCOLUMNS"}});
        this.assertCompileError("42818", "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  LTRIM(?) = TABLENAME");
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  LTRIM(?) = CAST(TABLENAME AS CHAR(10))");
        ps.setString(1, " SYSCOLUMNS");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"SYSCOLUMNS"}});
        this.assertCompileError("42818", "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  RTRIM(?) = TABLENAME");
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  RTRIM(?) = CAST(TABLENAME AS CHAR(10))");
        ps.setString(1, "SYSCOLUMNS  ");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"SYSCOLUMNS"}});
        this.assertCompileError("42818", "SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TRIM('a' FROM ?) = TABLENAME");
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TRIM('a' FROM ?) = CAST(TABLENAME AS CHAR(10))");
        ps.setString(1, "aSYSCOLUMNS");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"SYSCOLUMNS"}});
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  TRIM(LEADING SUBSTR(TABLENAME, LENGTH(TABLENAME)) FROM ?) = TABLENAME");
        ps.setString(1, "SYSCOLUMNS");
        rs = ps.executeQuery();
        JDBC.assertEmpty(rs);
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  LOCATE(?, TABLENAME) != 0");
        ps.setString(1, "ABC");
        rs = ps.executeQuery();
        JDBC.assertEmpty(rs);
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  LOCATE(TABLENAME, ?) != 0");
        ps.setString(1, "ABC");
        rs = ps.executeQuery();
        JDBC.assertEmpty(rs);
        ps = this.prepareStatement("SELECT COUNT(*) FROM CUSTOMER WHERE ? IN  (SELECT TABLENAME FROM SYS.SYSTABLES)");
        ps.setString(1, "SYSCOLUMNS");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"7"}});
        this.assertCompileError("42818", "SELECT TABLENAME FROM SYS.SYSTABLES  WHERE TABLENAME NOT IN (?, ' SYSCOLUMNS ') AND  CAST(TABLENAME AS CHAR(10)) = 'SYSCOLUMNS' ");
        s.executeUpdate("set schema SYS");
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES  WHERE TABLENAME NOT IN (?, ' SYSCOLUMNS ') AND  CAST(TABLENAME AS CHAR(10)) = 'SYSCOLUMNS' ");
        ps.setString(1, "aSYSCOLUMNS");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"SYSCOLUMNS"}});
        s.executeUpdate("set schema APP");
        ps = this.prepareStatement("SELECT TABLENAME FROM SYS.SYSTABLES WHERE  CAST(TABLENAME AS CHAR(10)) NOT IN (?, ' SYSCOLUMNS ') AND  CAST(TABLENAME AS CHAR(10)) = 'SYSCOLUMNS' ");
        ps.setString(1, "aSYSCOLUMNS");
        rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"SYSCOLUMNS"}});
        s.executeUpdate("set schema SYS");
        ps = this.prepareStatement("INSERT INTO APP.CUSTOMER(NAME) VALUES(?)");
        ps.setString(1, "SYSCOLUMNS");
        ps.executeUpdate();
        ps.close();
        s.executeUpdate("INSERT INTO APP.CUSTOMER(NAME) VALUES('abc')");
        rs = s.executeQuery("SELECT COUNT(*) FROM APP.CUSTOMER ");
        JDBC.assertFullResultSet(rs, new String[][]{{"9"}});
        CollationTest.assertStatementError("42818", s, "DELETE FROM APP.CUSTOMER WHERE NAME = 'abc'");
        s.executeUpdate("set schema APP");
        s.executeUpdate("DELETE FROM APP.CUSTOMER WHERE NAME = 'abc'");
        rs = s.executeQuery("SELECT COUNT(*) FROM APP.CUSTOMER ");
        JDBC.assertFullResultSet(rs, new String[][]{{"8"}});
        s.executeUpdate("set schema APP");
        CollationTest.assertStatementError("42ZA3", s, "CREATE TABLE T AS SELECT TABLENAME  FROM SYS.SYSTABLES WITH NO DATA");
        s.executeUpdate("CREATE TABLE T AS SELECT COLUMNNUMBER FROM  SYS.SYSCOLUMNS WITH NO DATA");
        s.execute("create table assoc (x char(10) not null primary key,  y char(100))");
        s.execute("create table assocout(x char(10))");
        ps = this.prepareStatement("insert into assoc values (?, 'hello')");
        ps.setString(1, new Integer(10).toString());
        ps.executeUpdate();
        s.execute("CREATE TABLE DERBY_2955 (EMPNAME CHAR(20), CONSTRAINT  STAFF9_EMPNAME CHECK (EMPNAME NOT LIKE 'T%'))");
        s.execute("CREATE TABLE DERBY_2960 (C CHAR(10), V VARCHAR(50))");
        s.execute("INSERT INTO DERBY_2960 VALUES ('duplicate', 'is duplicated')");
        rs = s.executeQuery("SELECT SUBSTR(c||v, 1, 4), COUNT(*) FROM DERBY_2960 GROUP BY SUBSTR(c||v, 1, 4)");
        JDBC.assertFullResultSet(rs, new String[][]{{"dupl", "1"}});
        ps = conn.prepareStatement("SELECT * FROM CUSTOMER FOR UPDATE", 1003, 1008);
        rs = ps.executeQuery();
        rs.moveToInsertRow();
        rs.close();
        ps.close();
        s.execute("CREATE TABLE DERBY_2973 (V VARCHAR(40))");
        s.execute("CREATE INDEX DERBY_2973_I1 ON DERBY_2973 (V)");
        s.execute("ALTER TABLE DERBY_2973 ALTER V SET DATA TYPE VARCHAR(4096)");
        s.execute("INSERT INTO DERBY_2973 VALUES('hello')");
        s.executeUpdate("create table DERBY_2967(c11 int)");
        s.executeUpdate("insert into DERBY_2967 values 1");
        ps = this.prepareStatement("select 1 from DERBY_2967 where '\ufa2d' like ?");
        String[] match = new String[]{"%", "_", "\ufa2d"};
        for (int i = 0; i < match.length; ++i) {
            ps.setString(1, match[i]);
            rs = ps.executeQuery();
            JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
        }
        s.executeUpdate("set schema APP");
        if (XML.classpathMeetsXMLReqs()) {
            this.checkLangBasedQuery(s, "SELECT ID, XMLSERIALIZE(V AS CLOB)  FROM DERBY_2961 ORDER BY 1", new String[][]{{"1", null}});
        }
        s.executeUpdate("CREATE FUNCTION HELLO () RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.CollationTest.hello' LANGUAGE JAVA PARAMETER STYLE JAVA");
        s.executeUpdate("create table testing (a varchar(2024))");
        s.executeUpdate("insert into testing values('hello')");
        rs = s.executeQuery("select * from testing where a = HELLO()");
        JDBC.assertSingleValueResultSet(rs, "hello");
        s.executeUpdate("DROP FUNCTION hello");
        s.executeUpdate("DROP TABLE  testing");
        CollationTest.assertStatementError("42818", s, "VALUES case WHEN SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.stream.error.logSeverityLevel') = '50000'  THEN 'LOGSHUTDOWN  ERRORS' ELSE 'DONT KNOW' END");
        rs = s.executeQuery("VALUES case WHEN CAST(SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.stream.error.logSeverityLevel') AS VARCHAR(30000))   = '50000'  THEN 'LOGSHUTDOWN  ERRORS' ELSE 'DONT KNOW' END");
        JDBC.assertSingleValueResultSet(rs, "DONT KNOW");
        s.executeUpdate("create table lockfunctesttable (i int)");
        conn.setAutoCommit(false);
        s.executeUpdate("insert into lockfunctesttable values(1)");
        CollationTest.assertStatementError("42818", s, "select * from SYSCS_DIAG.LOCK_TABLE where tablename = 'LOCKFUNCTESTTABLE'");
        ps = this.prepareStatement("select * from SYSCS_DIAG.LOCK_TABLE where tablename = ?");
        ps.setString(1, "LOCKFUNCTESTTABLE");
        rs = ps.executeQuery();
        JDBC.assertDrainResults(rs, 2);
        s.executeUpdate("drop table lockfunctesttable");
        s.executeUpdate("create table a (vc varchar(30))");
        s.executeUpdate("insert into a values(CURRENT_DATE)");
        rs = s.executeQuery("select vc from a where vc <= CURRENT_DATE");
        CollationTest.assertEquals((int)1, (int)JDBC.assertDrainResults(rs));
        rs = s.executeQuery("select vc from a where vc <= UPPER(CURRENT_DATE)");
        JDBC.assertDrainResults(rs, 1);
        rs = s.executeQuery("select vc from a where vc <= LOWER(CURRENT_DATE)");
        JDBC.assertDrainResults(rs, 1);
        rs = s.executeQuery("select vc from a where vc <=  '' || CURRENT_DATE");
        JDBC.assertDrainResults(rs, 1);
        rs = s.executeQuery("select vc from a where '' || CURRENT_DATE >= vc");
        JDBC.assertDrainResults(rs, 1);
        CollationTest.assertStatementError("42818", s, "select TABLENAME FROM SYS.SYSTABLES WHERE UPPER(CURRENT_DATE) = TABLENAME");
        ps = this.prepareStatement("select vc from a where  CAST (? AS VARCHAR(30)) = vc");
        ps.setString(1, "hello");
        rs = ps.executeQuery();
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select vc from a where '1.2' + 1.2 = 2.4");
        JDBC.assertDrainResults(rs, 1);
        s.executeUpdate("create table t1 (vc varchar(30))");
        s.executeUpdate("create table t2 (vc varchar(30))");
        s.executeUpdate("insert into t2 values('hello2')");
        rs = s.executeQuery("select vc from t2 where vc = (select vc from t2 union select vc from t)");
        JDBC.assertFullResultSet(rs, new String[][]{{"hello2"}});
        s.executeUpdate("drop table t1");
        s.executeUpdate("drop table t2");
        rs = s.executeQuery("VALUES CURRENT_DATE");
        rs.next();
        Date d = rs.getDate(1);
        s.executeUpdate("create table t1 (vc varchar(30))");
        s.executeUpdate("insert into t1 values(CURRENT_DATE)");
        ps = this.prepareStatement("select vc from t1 where vc like ? escape '%'");
        ps.setDate(1, d);
        rs = ps.executeQuery();
        JDBC.assertDrainResults(rs);
        s.executeUpdate("drop table t1");
        s.close();
    }

    public static String hello() {
        return "hello";
    }

    public static String mimic(String val) {
        return val;
    }

    private void setUpTable(Statement s) throws SQLException {
        s.execute("CREATE TABLE CUSTOMER(ID INT, NAME VARCHAR(40), NAMECHAR CHAR(40))");
        Connection conn = s.getConnection();
        PreparedStatement ps = conn.prepareStatement("INSERT INTO CUSTOMER VALUES(?,?,?)");
        for (int i = 0; i < NAMES.length; ++i) {
            ps.setInt(1, i);
            ps.setString(2, NAMES[i]);
            ps.setString(3, NAMES[i]);
            ps.executeUpdate();
        }
        s.execute("create table xmlTable (x xml)");
        s.executeUpdate("insert into xmlTable values(null)");
        s.execute("create table DERBY_2961 (ID INT  GENERATED ALWAYS AS  IDENTITY PRIMARY KEY, V XML)");
        s.executeUpdate("insert into DERBY_2961(V) values(null)");
        conn.commit();
        ps.close();
    }

    private void dropTable(Statement s) throws SQLException {
        s.execute("DROP TABLE APP.CUSTOMER");
        s.getConnection().commit();
    }

    private void checkLangBasedQuery(Statement s, String query, String[][] expectedResult) throws SQLException {
        ResultSet rs = s.executeQuery(query);
        if (expectedResult == null) {
            JDBC.assertEmpty(rs);
        } else {
            JDBC.assertFullResultSet(rs, expectedResult);
        }
    }

    public void testMissingCollatorSupport() throws SQLException {
        String createDBurl = ";create=true;territory=xx;collation=TERRITORY_BASED";
        try {
            TestUtil.getConnection("missingCollatorDB", createDBurl);
        }
        catch (SQLException sqle) {
            BaseJDBCTestCase.assertSQLState("Unexpected error when connecting to database ", "XBM04", sqle);
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("CollationTest");
        CollationTest missingCollatorDbTest = new CollationTest("testMissingCollatorSupport");
        suite.addTest((Test)missingCollatorDbTest);
        suite.addTest((Test)new CleanDatabaseTestSetup((Test)new CollationTest("testDefaultCollation")));
        suite.addTest(CollationTest.collatedSuite("en", false, "testEnglishCollation"));
        Locale[] availableLocales = Collator.getAvailableLocales();
        boolean norwegian = false;
        boolean polish = false;
        boolean french = false;
        boolean swedish = false;
        for (int i = 0; i < availableLocales.length; ++i) {
            if ("no".equals(availableLocales[i].getLanguage())) {
                norwegian = true;
            }
            if ("pl".equals(availableLocales[i].getLanguage())) {
                polish = true;
            }
            if ("fr".equals(availableLocales[i].getLanguage())) {
                french = true;
            }
            if (!"sv".equals(availableLocales[i].getLanguage())) continue;
            swedish = true;
        }
        if (norwegian) {
            suite.addTest(CollationTest.collatedSuite("no", false, "testNorwayCollation"));
        }
        if (polish) {
            suite.addTest(CollationTest.collatedSuite("pl", false, "testPolishCollation"));
        }
        if (french) {
            suite.addTest(CollationTest.collatedSuite("fr", false, "testFrenchCollation"));
        }
        if (swedish && !CollationTest.hasBuggySwedishLocale()) {
            suite.addTest(CollationTest.collatedSuite("sv", true, "testSwedishCaseInsensitiveCollation"));
        }
        return suite;
    }

    private static boolean hasBuggySwedishLocale() {
        Collator c = Collator.getInstance(new Locale("sv"));
        return c.compare("aa", "ab") >= 0;
    }

    private static void loadDriver() {
        String driverClass = TestConfiguration.getCurrent().getJDBCClient().getJDBCDriverName();
        try {
            Class.forName(driverClass).newInstance();
        }
        catch (Exception e) {
            CollationTest.fail((String)"could not instantiate driver");
        }
    }

    private static Test collatedSuite(String locale, boolean caseInsensitive, String baseFixture) {
        TestSuite suite = new TestSuite("CollationTest:territory=" + locale);
        suite.addTest((Test)new CollationTest(baseFixture));
        if ("en".equals(locale)) {
            suite.addTest(DatabaseMetaDataTest.suite());
            suite.addTest(BatchUpdateTest.embeddedSuite());
            suite.addTest(GroupByExpressionTest.suite());
            suite.addTest(UpdatableResultSetTest.suite());
        }
        return caseInsensitive ? Decorator.territoryCollatedCaseInsensitiveDatabase((Test)suite, locale) : Decorator.territoryCollatedDatabase((Test)suite, locale);
    }
}

