/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class CommentTest
extends BaseJDBCTestCase {
    public CommentTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(CommentTest.class);
    }

    public void testBracketedComments() throws Exception {
        Statement stmt = this.createStatement();
        JDBC.assertFullResultSet(stmt.executeQuery("/* a comment */ VALUES 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("-- eof comment\nVALUES 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES 1 /* a comment */"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* a comment */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* a comment \n with newline */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* SELECT * from FOO */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* a comment /* nested comment */ */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /*/* XXX /*/*/* deeply nested comment */*/*/YYY*/*/ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES 1 --/*/* XXX /*/*/* deeply nested comment */*/*/YYY*/*/ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES 1 --/*/* XXX /*/*/* deeply nested comment */*/*/YYY*/*/ 1--/*"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* a comment --\n with newline */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* a comment -- */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* a comment \n-- */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES '/* a comment \n-- */'"), new String[][]{{"/* a comment \n-- */"}});
        this.assertCompileError("42X02", "VALUES 1 /*");
        this.assertCompileError("42X02", "VALUES 1 /* comment");
        this.assertCompileError("42X02", "VALUES 1 /* comment /*");
        this.assertCompileError("42X02", "VALUES 1 /* comment /* nested */");
        this.assertCompileError("42X01", "/* this is a comment */");
        this.assertCompileError("42X01", "/* this is a comment */ /* /* foo */ */");
        this.assertCompileError("42X01", "\n\r\r\n/* Weird newlines in front of a comment */ /* /* foo */ */");
        this.assertCompileError("42X01", "-- this is a comment \n");
        this.assertCompileError("42X02", "/* this is not quite a comment");
    }

    public void testInitialComment_derby4338() throws Exception {
        Statement s = this.createStatement();
        JDBC.assertDrainResults(s.executeQuery("/* comment */ select * from sys.systables"));
        JDBC.assertDrainResults(s.executeQuery("/* */\nSELECT * from sys.systables"));
        JDBC.assertDrainResults(s.executeQuery("/* --*/\n\rSELECT * from sys.systables"));
        JDBC.assertDrainResults(s.executeQuery("--\nselect * from sys.systables"));
        s.executeUpdate("/* /* foo*/ */ create table t (i int)");
        s.executeUpdate("--\n drop table t");
        PreparedStatement ps = this.prepareStatement("{call syscs_util.syscs_set_database_property('foo', ?)}");
        ps.setString(1, "bar");
        ps.execute();
        if (CommentTest.usingEmbedded()) {
            Assert.assertTrue((ps.getUpdateCount() == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((ps.getUpdateCount() == -1 ? 1 : 0) != 0);
        }
        ps = this.prepareStatement("--\n{call syscs_util.syscs_set_database_property('foo', ?)}");
        ps.setString(1, "bar");
        ps.execute();
        if (CommentTest.usingEmbedded()) {
            Assert.assertEquals((int)0, (int)ps.getUpdateCount());
        } else {
            Assert.assertEquals((int)-1, (int)ps.getUpdateCount());
        }
        ps.setNull(1, 12);
        ps.execute();
    }

    public void testWrongKeywordLexing_derby4338() throws Exception {
        Statement s = this.createStatement();
        JDBC.assertDrainResults(s.executeQuery("select* from sys.systables"));
        JDBC.assertDrainResults(s.executeQuery("select'a' from sys.systables"));
        JDBC.assertDrainResults(s.executeQuery("select\"TABLEID\" from sys.systables"));
        this.assertCompileError("42X01", "commit");
        this.assertCompileError("42X01", "commit;");
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }
}

