/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CompressTableTest
extends BaseJDBCTestCase {
    public CompressTableTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(CompressTableTest.class));
    }

    public void testCompressTableWithDoubleQuoteInName() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table app.\"abc\"\"def\" (x int)");
        s.execute("call syscs_util.syscs_compress_table('APP','abc\"def',1)");
        s.execute("call syscs_util.syscs_inplace_compress_table('APP','abc\"def', 1, 1, 1)");
        s.execute("drop table app.\"abc\"\"def\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentInvalidation() throws Exception {
        Statement s = this.createStatement();
        s.execute("create table d4275(x int)");
        s.execute("insert into d4275 values 1");
        final List<Boolean> stop = Collections.synchronizedList(new ArrayList());
        final Throwable[] error = new Throwable[1];
        Connection c2 = this.openDefaultConnection();
        final PreparedStatement ps = c2.prepareStatement("select * from d4275");
        Thread t = new Thread(){

            public void run() {
                try {
                    while (stop.isEmpty()) {
                        JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
                    }
                }
                catch (Throwable t) {
                    error[0] = t;
                }
            }
        };
        t.start();
        try {
            for (int i = 0; i < 100; ++i) {
                s.execute("call syscs_util.syscs_compress_table('APP', 'D4275', 1)");
            }
        }
        finally {
            stop.add(Boolean.TRUE);
        }
        t.join();
        if (error[0] != null) {
            CompressTableTest.fail("Helper thread failed", error[0]);
        }
        ps.close();
        c2.close();
    }
}

