/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;

public class DeadlockModeTest
extends BaseJDBCTestCase {
    private static final int THREAD_COUNT = 20;
    private Object syncObject = new Object();
    private int startedCount = 0;
    private LinkedList listExceptions = new LinkedList();

    public DeadlockModeTest(String name) {
        super(name);
    }

    public void testThreadsUpdatingTable() throws Exception {
        Thread[] t = new Thread[20];
        this.createThreads(t);
        this.waitForThreads(t);
        if (!this.listExceptions.isEmpty()) {
            DeadlockModeTest.fail((String)("FAIL - " + this.listExceptions.size() + " threads threw exceptions"));
        }
    }

    private void createThreads(Thread[] t) throws SQLException {
        for (int i = 0; i < 20; ++i) {
            final Connection c = this.openDefaultConnection();
            t[i] = new Thread(new Runnable(){

                public void run() {
                    DeadlockModeTest.this.threadWorker(c);
                }
            });
            t[i].start();
        }
    }

    private void waitForThreads(Thread[] t) throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                t[i].join();
                continue;
            }
            catch (InterruptedException e) {
                DeadlockModeTest.assertNull((String)"FAIL - Exception thrown waiting for the threads", (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadWorker(Connection threadConnection) {
        try {
            Object object = this.syncObject;
            synchronized (object) {
                ++this.startedCount;
                this.syncObject.notifyAll();
                while (this.startedCount < 20) {
                    this.syncObject.wait();
                }
            }
            Statement stmt = threadConnection.createStatement();
            stmt.executeUpdate("update t set i = 456 where i = 456");
            threadConnection.setAutoCommit(false);
            stmt.execute("set isolation serializable");
            for (int i = 0; i < 100; ++i) {
                stmt.executeUpdate("update t set i = 456 where i = 456");
                threadConnection.commit();
            }
            threadConnection.close();
        }
        catch (Exception e) {
            Object object = this.syncObject;
            synchronized (object) {
                this.listExceptions.add(e);
            }
        }
    }

    protected static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(DeadlockModeTest.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)suite, 2, 4)){

            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.execute("create table t (i int)");
                stmt.executeUpdate("insert into t values (1956)");
                stmt.executeUpdate("insert into t values (180)");
                stmt.executeUpdate("insert into t values (3)");
            }
        };
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("DeadlockModeTest ");
        suite.addTest(DeadlockModeTest.baseSuite("DeadlockModeTest:embedded"));
        if (JDBC.vmSupportsJDBC3()) {
            suite.addTest(Decorator.encryptedDatabase(DeadlockModeTest.baseSuite("DeadlockModeTest:encrypted")));
        }
        return suite;
    }
}

