/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI;

public class IntegerArrayVTI
extends StringArrayVTI
implements RestrictedVTI {
    private static String[] _lastProjection;
    private static Restriction _lastRestriction;
    private static int _lastQualifedRowCount;

    public IntegerArrayVTI(String[] columnNames, int[][] rows) {
        super(columnNames, IntegerArrayVTI.stringify(rows));
    }

    public IntegerArrayVTI(String[] columnNames, Integer[][] rows) {
        super(columnNames, IntegerArrayVTI.stringify(rows));
    }

    private static String[][] stringify(int[][] rows) {
        int outerCount = rows.length;
        String[][] retval = new String[outerCount][];
        for (int i = 0; i < outerCount; ++i) {
            int[] rawRow = rows[i];
            int innerCount = rawRow.length;
            String[] row = new String[innerCount];
            retval[i] = row;
            for (int j = 0; j < innerCount; ++j) {
                row[j] = Integer.toString(rawRow[j]);
            }
        }
        return retval;
    }

    private static String[][] stringify(Integer[][] rows) {
        int outerCount = rows.length;
        String[][] retval = new String[outerCount][];
        for (int i = 0; i < outerCount; ++i) {
            Integer[] rawRow = rows[i];
            int innerCount = rawRow.length;
            String[] row = new String[innerCount];
            retval[i] = row;
            for (int j = 0; j < innerCount; ++j) {
                String value;
                Integer raw = rawRow[j];
                row[j] = value = raw == null ? null : raw.toString();
            }
        }
        return retval;
    }

    public boolean next() throws SQLException {
        do {
            boolean anotherRow;
            if (anotherRow = super.next()) continue;
            return false;
        } while (!this.qualifyCurrentRow());
        ++_lastQualifedRowCount;
        return true;
    }

    public void initScan(String[] columnNames, Restriction restriction) throws SQLException {
        _lastProjection = columnNames;
        _lastRestriction = restriction;
        _lastQualifedRowCount = 0;
    }

    private boolean qualifyCurrentRow() throws SQLException {
        if (_lastRestriction == null) {
            return true;
        }
        return this.qualifyCurrentRow(_lastRestriction);
    }

    private boolean qualifyCurrentRow(Restriction restriction) throws SQLException {
        if (restriction instanceof Restriction.AND) {
            Restriction.AND and = (Restriction.AND)restriction;
            return this.qualifyCurrentRow(and.getLeftChild()) && this.qualifyCurrentRow(and.getRightChild());
        }
        if (restriction instanceof Restriction.OR) {
            Restriction.OR or = (Restriction.OR)restriction;
            return this.qualifyCurrentRow(or.getLeftChild()) || this.qualifyCurrentRow(or.getRightChild());
        }
        if (restriction instanceof Restriction.ColumnQualifier) {
            return this.applyColumnQualifier((Restriction.ColumnQualifier)restriction);
        }
        throw new SQLException("Unknown type of Restriction: " + restriction.getClass().getName());
    }

    private boolean applyColumnQualifier(Restriction.ColumnQualifier qc) throws SQLException {
        int operator = qc.getComparisonOperator();
        int column = this.getInt(qc.getColumnName());
        boolean columnWasNull = this.wasNull();
        if (columnWasNull) {
            if (operator == 5) {
                return true;
            }
            if (operator == 6) {
                return false;
            }
            return false;
        }
        if (operator == 5) {
            return false;
        }
        if (operator == 6) {
            return true;
        }
        int constant = (Integer)qc.getConstantOperand();
        switch (operator) {
            case 1: {
                return column == constant;
            }
            case 4: {
                return column >= constant;
            }
            case 3: {
                return column > constant;
            }
            case 2: {
                return column <= constant;
            }
            case 0: {
                return column < constant;
            }
        }
        throw new SQLException("Unknown comparison operator: " + operator);
    }

    public static String getLastProjection() {
        return _lastProjection == null ? null : Arrays.asList(_lastProjection).toString();
    }

    public static String getLastRestriction() {
        return _lastRestriction == null ? null : _lastRestriction.toSQL();
    }

    public static int getLastQualifiedRowCount() {
        return _lastQualifedRowCount;
    }
}

