/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SequenceTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String ALPHA = "ALPHA";
    private static final String BETA = "BETA";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALPHA", "BETA"};

    public SequenceTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SequenceTest.class, "Sequence Test");
        if (!JDBC.vmSupportsJSR169() && !JDBC.vmSupportsJDBC3()) {
            return suite;
        }
        CleanDatabaseTestSetup cleanTest = new CleanDatabaseTestSetup((Test)suite);
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication((Test)cleanTest, LEGAL_USERS, "sequence");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecorator(authenticatedTest);
        return authorizedTest;
    }

    public void test_01_CreateSequence() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE SEQUENCE mySeq");
    }

    public void test_02_DropSequence() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE SEQUENCE mySeq1");
        s.executeUpdate("DROP SEQUENCE mySeq1 restrict");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_03_DuplicateCreationFailure() throws SQLException {
        Statement s = null;
        try {
            s = this.createStatement();
            s.executeUpdate("CREATE SEQUENCE mySeq1");
            s.executeUpdate("CREATE SEQUENCE mySeq1");
        }
        catch (SQLException sqle) {
            SequenceTest.assertSQLState("X0Y68", sqle);
        }
        finally {
            s.executeUpdate("DROP SEQUENCE mySeq1 restrict");
        }
    }

    public void test_04_ImplicitSchemaCreation() throws SQLException {
        Connection adminCon = this.openUserConnection(TEST_DBO);
        Connection alphaCon = this.openUserConnection(ALPHA);
        Statement stmt = alphaCon.createStatement();
        stmt.executeUpdate("CREATE SEQUENCE alpha_seq");
        stmt.executeUpdate("DROP SEQUENCE alpha_seq restrict");
        stmt.close();
        alphaCon.close();
        adminCon.close();
    }

    public void test_05CreateWithSchemaSpecified() throws SQLException {
        Connection alphaCon = this.openUserConnection(ALPHA);
        Statement stmt = alphaCon.createStatement();
        stmt.executeUpdate("CREATE SEQUENCE alpha.alpha_seq");
        stmt.executeUpdate("DROP SEQUENCE alpha.alpha_seq restrict");
        stmt.close();
        alphaCon.close();
    }

    public void test_06_CreateWithSchemaSpecifiedCreateTrue() throws SQLException {
        Connection alphaCon = this.openUserConnection(ALPHA);
        Statement stmt = alphaCon.createStatement();
        stmt.executeUpdate("CREATE SEQUENCE alpha.alpha_seq");
        stmt.executeUpdate("DROP SEQUENCE alpha.alpha_seq restrict");
        stmt.close();
        alphaCon.close();
    }

    public void test_07_CreateWithSchemaDropWithNoSchema() throws SQLException {
        Connection alphaCon = this.openUserConnection(ALPHA);
        Statement stmt = alphaCon.createStatement();
        stmt.executeUpdate("CREATE SEQUENCE alpha.alpha_seq");
        stmt.executeUpdate("DROP SEQUENCE alpha_seq restrict");
        stmt.close();
        alphaCon.close();
    }

    public void test_08_DropOtherSchemaSequence() throws SQLException {
        Connection adminCon = this.openUserConnection(TEST_DBO);
        Connection alphaCon = this.openUserConnection(ALPHA);
        Statement stmtAlpha = alphaCon.createStatement();
        stmtAlpha.executeUpdate("CREATE SEQUENCE alpha_seq");
        Connection betaCon = this.openUserConnection(BETA);
        Statement stmtBeta = betaCon.createStatement();
        SequenceTest.assertStatementError("42507", stmtBeta, "DROP SEQUENCE alpha.alpha_seq restrict");
        stmtAlpha.executeUpdate("DROP SEQUENCE alpha_seq restrict");
        stmtAlpha.close();
        stmtBeta.close();
        alphaCon.close();
        betaCon.close();
        adminCon.close();
    }

    public void test_09_CreateOtherSchemaSequence() throws SQLException {
        Connection adminCon = this.openUserConnection(TEST_DBO);
        Connection alphaCon = this.openUserConnection(ALPHA);
        Statement stmtAlpha = alphaCon.createStatement();
        stmtAlpha.executeUpdate("CREATE SEQUENCE alpha_seq");
        Connection betaCon = this.openUserConnection(BETA);
        Statement stmtBeta = betaCon.createStatement();
        SequenceTest.assertStatementError("42507", stmtBeta, "CREATE SEQUENCE alpha.alpha_seq3");
        stmtAlpha.executeUpdate("DROP SEQUENCE alpha_seq restrict");
        stmtAlpha.close();
        stmtBeta.close();
        alphaCon.close();
        betaCon.close();
        adminCon.close();
    }

    public void test_09a_createSequenceWithArguments() throws Exception {
        Connection alphaCon = this.openUserConnection(ALPHA);
        this.goodStatement(alphaCon, "CREATE SEQUENCE small1 AS SMALLINT START WITH 0 INCREMENT BY 1");
        this.goodStatement(alphaCon, "CREATE SEQUENCE small2 AS SMALLINT START WITH -32768 MAXVALUE 32767");
        this.goodStatement(alphaCon, "CREATE SEQUENCE small3 AS SMALLINT START WITH 1200 INCREMENT BY -5 MAXVALUE 32000 NO MINVALUE CYCLE");
        this.expectCompilationError(alphaCon, "42XAE", "CREATE SEQUENCE small3 AS SMALLINT START WITH -32768 MAXVALUE 2147483647");
        this.expectCompilationError(alphaCon, "42XAG", "CREATE SEQUENCE small4 AS SMALLINT START WITH -2147483648");
        this.expectCompilationError(alphaCon, "42XAF", "CREATE SEQUENCE small5 AS SMALLINT MAXVALUE -20000 MINVALUE -1");
        this.goodStatement(alphaCon, "CREATE SEQUENCE int1 AS INTEGER START WITH -2147483648 INCREMENT BY -10 CYCLE");
        this.goodStatement(alphaCon, "CREATE SEQUENCE int2 AS INTEGER INCREMENT BY 5 MAXVALUE 2147483647");
        this.goodStatement(alphaCon, "CREATE SEQUENCE int3 AS INTEGER START WITH 1200 INCREMENT BY 5 NO MAXVALUE MINVALUE -320000 CYCLE");
        this.expectCompilationError(alphaCon, "42XAE", "CREATE SEQUENCE int4 AS INTEGER START WITH -2147483648 MAXVALUE 32767 MINVALUE -9223372036854775808");
        this.expectCompilationError(alphaCon, "42XAC", "CREATE SEQUENCE int5 AS INTEGER INCREMENT BY 0");
        this.goodStatement(alphaCon, "CREATE SEQUENCE long1 AS BIGINT START WITH -9223372036854775808 INCREMENT BY -100 NO CYCLE");
        this.goodStatement(alphaCon, "CREATE SEQUENCE long2 AS BIGINT INCREMENT BY 25 MAXVALUE 2147483647");
        this.goodStatement(alphaCon, "CREATE SEQUENCE long3 AS BIGINT START WITH 0 INCREMENT BY 5 NO MAXVALUE MINVALUE -9223372036854775808 CYCLE");
        this.expectCompilationError(alphaCon, "42XAE", "CREATE SEQUENCE long4 AS BIGINT START WITH 2147483647 MINVALUE 9223372036854775807");
        this.expectCompilationError(alphaCon, "42XAF", "CREATE SEQUENCE long5 AS BIGINT START WITH 0 MAXVALUE 100000 MINVALUE 100001");
        this.expectCompilationError(alphaCon, "42X01", "CREATE SEQUENCE char1 AS CHAR INCREMENT BY 1");
    }

    public void test_10_NextValue() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE SEQUENCE mySeq1");
        s.execute("SELECT NEXT VALUE FOR mySeq1 from sys.systables");
        s.execute("DROP SEQUENCE mySeq1 restrict");
    }

    public void test_11_forbiddenContexts() throws Exception {
        Connection conn = this.openUserConnection(ALPHA);
        this.goodStatement(conn, "create sequence seq_11_a\n");
        this.goodStatement(conn, "create sequence seq_11_b\n");
        String illegalSequence = "42XAH";
        this.expectCompilationError(conn, illegalSequence, "select * from sys.systables where ( next value for seq_11_a ) > 100\n");
        this.expectCompilationError(conn, illegalSequence, "select max( conglomeratenumber ), tableid\nfrom sys.sysconglomerates\ngroup by tableid\nhaving max( conglomeratenumber ) > ( next value for seq_11_a )\n");
        this.expectCompilationError(conn, illegalSequence, "select * from sys.sysconglomerates left join sys.sysschemas on conglomeratenumber = ( next value for seq_11_a )\n");
        this.expectCompilationError(conn, illegalSequence, "create table t_11_1( a int check ( a > ( next value for seq_11_a ) ) )\n");
        this.expectCompilationError(conn, illegalSequence, "create table t_11_1( a int, b generated always as ( a + ( next value for seq_11_a ) ) )\n");
        this.expectCompilationError(conn, illegalSequence, "select max( next value for seq_11_a ) from sys.systables\n");
        this.expectCompilationError(conn, illegalSequence, "values case when ( next value for seq_11_a ) < 0 then 100 else 200 end\n");
        this.expectCompilationError(conn, illegalSequence, "select distinct( next value for seq_11_a ) from sys.systables\n");
        this.expectCompilationError(conn, illegalSequence, "select tableid, ( next value for seq_11_a ) a from sys.systables order by a\n");
        this.expectCompilationError(conn, illegalSequence, "select max( tableid ), ( next value for seq_11_a ) from sys.systables group by ( next value for seq_11_a )\n");
        this.expectCompilationError(conn, "42XAI", "select next value for seq_11_a, next value for seq_11_a from sys.systables where 1=2\n");
        this.goodStatement(conn, "select next value for seq_11_a, next value for seq_11_b from sys.systables where 1=2\n");
    }

    public void test_12_clauseOrder() throws Exception {
        Connection conn = this.openUserConnection(ALPHA);
        this.goodSequence(conn, "seq_12_a", "", "INTEGER", Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, 1L, false);
        this.goodSequence(conn, "seq_12_b", "minvalue 5 increment by 3 cycle start with 100 maxvalue 1000000 as bigint", "BIGINT", 100L, 5L, 1000000L, 3L, true);
        this.goodSequence(conn, "seq_12_c", "increment by 3 as smallint no cycle no maxvalue", "SMALLINT", -32768L, -32768L, 32767L, 3L, false);
        this.goodSequence(conn, "seq_12_d", "maxvalue 1000000000 start with -50 increment by -3 cycle no minvalue", "INTEGER", -50L, Integer.MIN_VALUE, 1000000000L, -3L, true);
        this.expectCompilationError(conn, "42XAJ", "create sequence bad_12 as smallint as bigint\n");
        this.expectCompilationError(conn, "42XAJ", "create sequence bad_12 start with 3 start with 7\n");
        this.expectCompilationError(conn, "42XAJ", "create sequence bad_12 minvalue 5 no minvalue\n");
        this.expectCompilationError(conn, "42XAJ", "create sequence bad_12 maxvalue 5 no maxvalue\n");
        this.expectCompilationError(conn, "42XAJ", "create sequence bad_12 increment by 7 increment by -7\n");
        this.expectCompilationError(conn, "42XAJ", "create sequence bad_12 no cycle cycle\n");
    }

    private void goodSequence(Connection conn, String sequenceName, String clauses, String datatype, long initialValue, long minValue, long maxValue, long stepValue, boolean cycle) throws Exception {
        String statement = "create sequence " + sequenceName + " " + clauses;
        this.goodStatement(conn, statement);
        PreparedStatement ps = this.chattyPrepare(conn, "select sequencedatatype, startvalue, minimumvalue, maximumvalue, increment, cycleoption\nfrom sys.syssequences\nwhere sequencename = ?");
        ps.setString(1, sequenceName.toUpperCase());
        ResultSet rs = ps.executeQuery();
        rs.next();
        int col = 1;
        SequenceTest.assertEquals((String)datatype, (String)rs.getString(col++));
        SequenceTest.assertEquals((long)initialValue, (long)rs.getLong(col++));
        SequenceTest.assertEquals((long)minValue, (long)rs.getLong(col++));
        SequenceTest.assertEquals((long)maxValue, (long)rs.getLong(col++));
        SequenceTest.assertEquals((long)stepValue, (long)rs.getLong(col++));
        SequenceTest.assertEquals((boolean)cycle, (boolean)rs.getString(col++).equals("Y"));
        rs.close();
        ps.close();
    }

    public void test_13_restrictedDrop() throws Exception {
        Connection conn = this.openUserConnection(ALPHA);
        this.goodStatement(conn, "create table t_13_a( a int )");
        this.goodStatement(conn, "create table t_13_b( a int )");
        String createStatement = "create sequence seq_13_a";
        String dropStatement = "drop sequence seq_13_a restrict";
        String createDependentObject = "create trigger trig_13 after insert on t_13_a for each row insert into t_13_b( a ) values ( next value for seq_13_a )\n";
        String dropDependentObject = "drop trigger trig_13";
        String badDropState = "X0Y24";
        this.verifyRestrictedDrop(conn, createDependentObject, dropDependentObject, createStatement, dropStatement, badDropState);
        createStatement = "create sequence seq_13_b";
        dropStatement = "drop sequence seq_13_b restrict";
        createDependentObject = "create view v_13( a, b ) as select a, next value for seq_13_b from t_13_a\n";
        dropDependentObject = "drop view v_13";
        badDropState = "X0Y23";
        this.verifyRestrictedDrop(conn, createDependentObject, dropDependentObject, createStatement, dropStatement, badDropState);
    }

    public void test_14_insertSelect() throws Exception {
        Connection conn = this.openUserConnection(ALPHA);
        this.goodStatement(conn, "create sequence sequence_is");
        this.goodStatement(conn, "create table tis_1( a int )");
        this.goodStatement(conn, "create table tis_2( a int, b int )");
        this.goodStatement(conn, "insert into tis_1( a ) values ( 1 ), ( 2 )");
        this.goodStatement(conn, "insert into tis_2 select next value for sequence_is, a from tis_1");
        this.assertResults(conn, "select * from tis_2 order by b", new String[][]{{"-2147483648", "1"}, {"-2147483647", "2"}}, true);
    }

    public void test_15_5254() throws Exception {
        Connection conn = this.openUserConnection(ALPHA);
        this.goodStatement(conn, "create table t_5254( cycle int, minvalue int, maxvalue int )");
        this.goodStatement(conn, "drop table t_5254");
    }
}

