/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SQLUtilities;

public class StalePlansTest
extends BaseJDBCTestCase {
    public StalePlansTest(String name) {
        super(name);
    }

    public static Test suite() {
        Properties props = new Properties();
        props.setProperty("derby.language.stalePlanCheckInterval", "10");
        DatabasePropertyTestSetup suite = new DatabasePropertyTestSetup((Test)new TestSuite(StalePlansTest.class), props, true);
        return new CleanDatabaseTestSetup((Test)suite);
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table t (c1 int, c2 int, c3 varchar(255))");
        stmt.executeUpdate("create index idx on t (c1)");
        stmt.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        stmt.close();
        this.commit();
    }

    protected void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("drop table t");
        this.commit();
        super.tearDown();
    }

    private void flushRowCount(Statement stmt) throws SQLException {
        stmt.execute("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
    }

    public void testStalePlanCheckIntervalOutOfRange() throws SQLException {
        Statement stmt = this.createStatement();
        StalePlansTest.assertStatementError("XCY00", stmt, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.stalePlanCheckInterval', '2')");
        stmt.close();
    }

    public void testStalePlansOnSmallTable() throws SQLException {
        int i;
        Statement stmt = this.createStatement();
        PreparedStatement insert = this.prepareStatement("insert into t values (?,?,?)");
        insert.setInt(1, 1);
        insert.setInt(2, 100);
        insert.setString(3, Formatters.padString("abc", 255));
        insert.executeUpdate();
        this.commit();
        this.flushRowCount(stmt);
        PreparedStatement ps = this.prepareStatement("select count(c1 + c2) from t where c1 = 1");
        String[][] expected = new String[][]{{"1"}};
        JDBC.assertFullResultSet(ps.executeQuery(), expected);
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(stmt).usedIndexScan());
        for (i = 0; i < 11; ++i) {
            JDBC.assertFullResultSet(ps.executeQuery(), expected);
        }
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(stmt).usedIndexScan());
        this.commit();
        insert.setInt(2, 100);
        for (i = 2; i <= 10; ++i) {
            insert.setInt(1, i);
            insert.executeUpdate();
        }
        this.commit();
        this.flushRowCount(stmt);
        for (i = 0; i < 11; ++i) {
            JDBC.assertFullResultSet(ps.executeQuery(), expected);
        }
        JDBC.assertFullResultSet(ps.executeQuery(), expected);
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(stmt).usedIndexScan());
        this.commit();
        stmt.executeUpdate("delete from t where c1 >= 2");
        for (i = 0; i < 11; ++i) {
            JDBC.assertFullResultSet(ps.executeQuery(), expected);
        }
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(stmt).usedIndexScan());
        stmt.close();
        ps.close();
        insert.close();
    }

    public void testStalePlansOnLargeTable() throws SQLException {
        int i;
        Statement stmt = this.createStatement();
        PreparedStatement insert = this.prepareStatement("insert into t values (?,?,?)");
        insert.setInt(1, 1);
        insert.setInt(2, 1);
        insert.setString(3, Formatters.padString("abc", 255));
        insert.executeUpdate();
        PreparedStatement insert2 = this.prepareStatement("insert into t select c1+?, c2+?, c3 from t");
        for (int i2 = 1; i2 <= 512; i2 *= 2) {
            insert2.setInt(1, i2);
            insert2.setInt(2, i2);
            insert2.executeUpdate();
        }
        this.commit();
        this.flushRowCount(stmt);
        PreparedStatement ps = this.prepareStatement("select count(c1 + c2) from t where c1 = 1");
        String[][] expected = new String[][]{{"1"}};
        JDBC.assertFullResultSet(ps.executeQuery(), expected);
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(stmt).usedIndexScan());
        this.commit();
        for (i = 1025; i <= 1250; ++i) {
            insert.setInt(1, i);
            insert.setInt(2, i);
            insert.executeUpdate();
        }
        this.commit();
        stmt.executeUpdate("update t set c1 = 1 where c1 > 0");
        this.flushRowCount(stmt);
        for (i = 0; i < 11; ++i) {
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "1250");
        }
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(stmt).usedTableScan());
        stmt.executeUpdate("insert into t select c1,c2,c3 from t where c1<128");
        this.flushRowCount(stmt);
        for (i = 0; i < 11; ++i) {
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "2500");
        }
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(stmt).usedTableScan());
        stmt.executeUpdate("update t set c1 = c2");
        stmt.executeUpdate("insert into t select c1, c2, c3 from t");
        this.flushRowCount(stmt);
        for (i = 0; i < 11; ++i) {
            JDBC.assertFullResultSet(ps.executeQuery(), new String[][]{{"4"}});
        }
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(stmt).usedIndexRowToBaseRow());
        stmt.close();
        insert.close();
        insert2.close();
        ps.close();
    }
}

