/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JDBC;

public class TimestampArithTest
extends BaseJDBCTestCase {
    private final OneDiffTest[] diffBetweenTsTests = new OneDiffTest[]{new OneDiffTest(0, TimestampArithTest.ts("2005-05-10 08:25:00"), TimestampArithTest.ts("2005-05-10 08:25:00.000001"), 1000, null, null), new OneDiffTest(1, TimestampArithTest.ts("2005-05-10 08:25:01"), TimestampArithTest.ts("2005-05-10 08:25:00"), -1, null, null), new OneDiffTest(1, TimestampArithTest.ts("2005-05-10 08:25:00.1"), TimestampArithTest.ts("2005-05-10 08:25:00"), 0, null, null), new OneDiffTest(1, TimestampArithTest.ts("2005-05-10 08:25:00"), TimestampArithTest.ts("2005-05-10 08:26:00"), 60, null, null), new OneDiffTest(2, TimestampArithTest.ts("2005-05-11 08:25:00"), TimestampArithTest.ts("2005-05-10 08:25:00"), -1440, null, null), new OneDiffTest(3, TimestampArithTest.ts("2005-05-10 08:25:00"), TimestampArithTest.ts("2005-05-11 08:25:00"), 24, null, null), new OneDiffTest(4, TimestampArithTest.ts("2005-05-10 08:25:00"), TimestampArithTest.ts("2005-05-11 08:25:00"), 1, null, null), new OneDiffTest(4, TimestampArithTest.ts("2005-05-10 08:25:01"), TimestampArithTest.ts("2005-05-11 08:25:00"), 0, null, null), new OneDiffTest(5, TimestampArithTest.ts("2005-02-23 08:25:00"), TimestampArithTest.ts("2005-03-01 08:25:00"), 0, null, null), new OneDiffTest(6, TimestampArithTest.ts("2005-02-23 08:25:00"), TimestampArithTest.ts("2005-03-23 08:25:00"), 1, null, null), new OneDiffTest(6, TimestampArithTest.ts("2005-02-23 08:25:01"), TimestampArithTest.ts("2005-03-23 08:25:00"), 0, null, null), new OneDiffTest(7, TimestampArithTest.ts("2005-02-23 08:25:00"), TimestampArithTest.ts("2005-05-23 08:25:00"), 1, null, null), new OneDiffTest(7, TimestampArithTest.ts("2005-02-23 08:25:01"), TimestampArithTest.ts("2005-05-23 08:25:00"), 0, null, null), new OneDiffTest(8, TimestampArithTest.ts("2005-02-23 08:25:00"), TimestampArithTest.ts("2005-05-23 08:25:00"), 0, null, null), new OneDiffTest(8, TimestampArithTest.ts("2005-02-23 08:25:00"), TimestampArithTest.ts("2006-02-23 08:25:00"), 1, null, null)};
    private final OneDiffTest[] diffBetweenTsAndDateTests = new OneDiffTest[]{new OneDiffTest(0, TimestampArithTest.ts("2004-05-10 00:00:00.123456"), TimestampArithTest.dt("2004-05-10"), -123456000, null, null), new OneDiffTest(1, TimestampArithTest.ts("2004-05-10 08:25:01"), TimestampArithTest.dt("2004-05-10"), -30301, null, null), new OneDiffTest(2, TimestampArithTest.ts("2004-05-11 08:25:00"), TimestampArithTest.dt("2004-05-10"), -1945, null, null), new OneDiffTest(3, TimestampArithTest.ts("2004-02-28 08:25:00"), TimestampArithTest.dt("2004-03-01"), 39, null, null), new OneDiffTest(4, TimestampArithTest.ts("2004-05-10 08:25:00"), TimestampArithTest.dt("2004-05-11"), 0, null, null), new OneDiffTest(5, TimestampArithTest.ts("2004-02-23 00:00:00"), TimestampArithTest.dt("2004-03-01"), 1, null, null), new OneDiffTest(6, TimestampArithTest.ts("2004-02-23 08:25:00"), TimestampArithTest.dt("2004-03-24"), 1, null, null), new OneDiffTest(7, TimestampArithTest.ts("2004-02-23 08:25:00"), TimestampArithTest.dt("2004-05-24"), 1, null, null), new OneDiffTest(8, TimestampArithTest.ts("2004-02-23 08:25:00"), TimestampArithTest.dt("2004-05-23"), 0, null, null)};
    private final OneDiffTest[] diffBetweenDateAndTsTests = new OneDiffTest[]{new OneDiffTest(0, TimestampArithTest.dt("2004-05-10"), TimestampArithTest.ts("2004-05-10 00:00:00.123456"), 123456000, null, null), new OneDiffTest(1, TimestampArithTest.dt("2004-05-10"), TimestampArithTest.ts("2004-05-09 23:59:00"), -60, null, null), new OneDiffTest(2, TimestampArithTest.dt("2004-05-10"), TimestampArithTest.ts("2004-05-11 08:25:00"), 1945, null, null), new OneDiffTest(3, TimestampArithTest.dt("2005-03-01"), TimestampArithTest.ts("2005-02-28 08:25:00"), -15, null, null), new OneDiffTest(4, TimestampArithTest.dt("2004-05-10"), TimestampArithTest.ts("2004-05-11 08:25:00"), 1, null, null), new OneDiffTest(5, TimestampArithTest.dt("2004-03-01"), TimestampArithTest.ts("2004-02-23 00:00:00"), -1, null, null), new OneDiffTest(6, TimestampArithTest.dt("2005-03-24"), TimestampArithTest.ts("2004-02-23 08:25:00"), -13, null, null), new OneDiffTest(7, TimestampArithTest.dt("2004-05-23"), TimestampArithTest.ts("2004-02-23 08:25:01"), 0, null, null), new OneDiffTest(8, TimestampArithTest.dt("2004-05-23"), TimestampArithTest.ts("2003-02-23 08:25:00"), -1, null, null)};
    private final OneAddTest[] addBetweenTsTests = new OneAddTest[]{new OneAddTest(0, 1000, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-05-11 15:55:00.000001"), null, null), new OneAddTest(1, 60, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-05-11 15:56:00"), null, null), new OneAddTest(2, -1, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-05-11 15:54:00"), null, null), new OneAddTest(3, 2, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-05-11 17:55:00"), null, null), new OneAddTest(4, 1, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-05-12 15:55:00"), null, null), new OneAddTest(5, 1, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-05-18 15:55:00"), null, null), new OneAddTest(6, 1, TimestampArithTest.ts("2005-05-11 15:55:00"), TimestampArithTest.ts("2005-06-11 15:55:00"), null, null), new OneAddTest(7, 1, TimestampArithTest.ts("2005-10-11 15:55:00"), TimestampArithTest.ts("2006-01-11 15:55:00"), null, null), new OneAddTest(8, -10, TimestampArithTest.ts("2005-10-11 15:55:00"), TimestampArithTest.ts("1995-10-11 15:55:00"), null, null)};
    private final OneAddTest[] addBetweenDateAndTsTests = new OneAddTest[]{new OneAddTest(0, -1000, TimestampArithTest.dt("2005-05-11"), TimestampArithTest.ts("2005-05-10 23:59:59.999999"), null, null), new OneAddTest(1, 60, TimestampArithTest.dt("2005-05-11"), TimestampArithTest.ts("2005-05-11 00:01:00"), null, null), new OneAddTest(2, 1, TimestampArithTest.dt("2005-05-11"), TimestampArithTest.ts("2005-05-11 00:01:00"), null, null), new OneAddTest(3, -2, TimestampArithTest.dt("2005-05-11"), TimestampArithTest.ts("2005-05-10 22:00:00"), null, null), new OneAddTest(4, 1, TimestampArithTest.dt("2005-05-11"), TimestampArithTest.ts("2005-05-12 00:00:00"), null, null), new OneAddTest(5, 1, TimestampArithTest.dt("2005-05-11"), TimestampArithTest.ts("2005-05-18 00:00:00"), null, null), new OneAddTest(6, -1, TimestampArithTest.dt("2005-03-29"), TimestampArithTest.ts("2005-02-28 00:00:00"), null, null), new OneAddTest(7, -2, TimestampArithTest.dt("2005-05-05"), TimestampArithTest.ts("2004-11-05 00:00:00"), null, null), new OneAddTest(8, 2, TimestampArithTest.dt("2005-05-05"), TimestampArithTest.ts("2007-05-05 00:00:00"), null, null)};
    private final OneStringDiffTest[] diffBetweenStringTests = new OneStringDiffTest[]{new OneStringDiffTest(1, "2005-05-10 08:25:00", "2005-05-10 08:26:00", 60, null, null)};
    private final OneStringAddTest[] addBetweenStringTests = new OneStringAddTest[]{new OneStringAddTest(4, 1, "2005-05-11 15:55:00", TimestampArithTest.ts("2005-05-12 15:55:00"), null, null)};
    private final OneTest[] overflowTests = new OneTest[]{new OneDiffTest(0, TimestampArithTest.ts("2004-05-10 00:00:00.123456"), TimestampArithTest.ts("2004-05-10 00:00:10.123456"), 0, "22003", "The resulting value is outside the range for the data type INTEGER."), new OneDiffTest(0, TimestampArithTest.ts("2004-05-10 00:00:00.123456"), TimestampArithTest.ts("2005-05-10 00:00:00.123456"), 0, "22003", "The resulting value is outside the range for the data type INTEGER."), new OneDiffTest(1, TimestampArithTest.ts("1904-05-10 00:00:00"), TimestampArithTest.ts("2205-05-10 00:00:00"), 0, "22003", "The resulting value is outside the range for the data type INTEGER."), new OneAddTest(8, 99999, TimestampArithTest.ts("2004-05-10 00:00:00.123456"), null, "22003", "The resulting value is outside the range for the data type TIMESTAMP.")};
    private final String[][] invalid = new String[][]{{"values( {fn TIMESTAMPDIFF( SECOND, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)})", "42X01", "Syntax error: Encountered \"SECOND\" at line 1, column 28."}, {"values( {fn TIMESTAMPDIFF( , CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)})", "42X01", "Syntax error: Encountered \",\" at line 1, column 28."}, {"values( {fn TIMESTAMPDIFF( SQL_TSI_SECOND, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 5)})", "42X01", "Syntax error: Encountered \",\" at line 1, column 80."}, {"values( {fn TIMESTAMPDIFF( SQL_TSI_SECOND, CURRENT_TIMESTAMP, 'x')})", "42X45", "CHAR is an invalid type for argument number 3 of TIMESTAMPDIFF."}, {"values( {fn TIMESTAMPDIFF( SQL_TSI_SECOND, 'x', CURRENT_TIMESTAMP)})", "42X45", "CHAR is an invalid type for argument number 2 of TIMESTAMPDIFF."}, {"values( {fn TIMESTAMPDIFF( SQL_TSI_SECOND, CURRENT_TIMESTAMP)})", "42X01", "Syntax error: Encountered \")\" at line 1, column 61."}, {"values( {fn TIMESTAMPDIFF( SQL_TSI_SECOND)})", "42X01", "Syntax error: Encountered \")\" at line 1, column 42."}, {"values( {fn TIMESTAMPADD( x, 1, CURRENT_TIMESTAMP)})", "42X01", "Syntax error: Encountered \"x\" at line 1, column 27."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND, CURRENT_DATE, CURRENT_TIMESTAMP)})", "42X45", "DATE is an invalid type for argument number 2 of TIMESTAMPADD."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND, 'XX', CURRENT_TIMESTAMP)})", "42X45", "CHAR is an invalid type for argument number 2 of TIMESTAMPADD."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND, 1.1, CURRENT_TIMESTAMP)})", "42X45", "DECIMAL is an invalid type for argument number 2 of TIMESTAMPADD."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND, 1, 2.1)})", "42X45", "DECIMAL is an invalid type for argument number 3 of TIMESTAMPADD."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND, 1, 'XX')})", "42X45", "CHAR is an invalid type for argument number 3 of TIMESTAMPADD."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND, 1)})", "42X01", "Syntax error: Encountered \")\" at line 1, column 44."}, {"values( {fn TIMESTAMPADD( SQL_TSI_SECOND)})", "42X01", "Syntax error: Encountered \")\" at line 1, column 41."}};
    private static final String[] intervalJdbcNames = new String[]{"SQL_TSI_FRAC_SECOND", "SQL_TSI_SECOND", "SQL_TSI_MINUTE", "SQL_TSI_HOUR", "SQL_TSI_DAY", "SQL_TSI_WEEK", "SQL_TSI_MONTH", "SQL_TSI_QUARTER", "SQL_TSI_YEAR"};
    private static Statement stmt;
    private static PreparedStatement[] tsAddPS;
    private static PreparedStatement[] tsDiffPS;
    private static final int FRAC_SECOND_INTERVAL = 0;
    private static final int SECOND_INTERVAL = 1;
    private static final int MINUTE_INTERVAL = 2;
    private static final int HOUR_INTERVAL = 3;
    private static final int DAY_INTERVAL = 4;
    private static final int WEEK_INTERVAL = 5;
    private static final int MONTH_INTERVAL = 6;
    private static final int QUARTER_INTERVAL = 7;
    private static final int YEAR_INTERVAL = 8;

    public TimestampArithTest(String name) {
        super(name);
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public static Test suite() {
        return new BaseJDBCTestSetup((Test)new TestSuite(TimestampArithTest.class, "TimestampArithTest")){

            protected void setUp() throws Exception {
                super.setUp();
                for (int i = 0; i < intervalJdbcNames.length; ++i) {
                    tsAddPS[i] = this.getConnection().prepareStatement(TimestampArithTest.composeSqlStr("ADD", i, "?", "?"));
                    tsDiffPS[i] = this.getConnection().prepareStatement(TimestampArithTest.composeSqlStr("DIFF", i, "?", "?"));
                }
                stmt = this.getConnection().createStatement();
            }
        };
    }

    public void testDiffBetweenTimestamp() throws SQLException {
        this.getConnection();
        for (int i = 0; i < this.diffBetweenTsTests.length; ++i) {
            this.diffBetweenTsTests[i].runTest();
        }
    }

    public void testDiffBetweenTimestampAndDate() throws SQLException {
        for (int i = 0; i < this.diffBetweenTsAndDateTests.length; ++i) {
            this.diffBetweenTsAndDateTests[i].runTest();
        }
    }

    public void testDiffBetweenDateAndTimestamp() throws SQLException {
        for (int i = 0; i < this.diffBetweenDateAndTsTests.length; ++i) {
            this.diffBetweenDateAndTsTests[i].runTest();
        }
    }

    public void testAddBetweenTimestamp() throws SQLException {
        for (int i = 0; i < this.addBetweenTsTests.length; ++i) {
            this.addBetweenTsTests[i].runTest();
        }
    }

    public void testAddBetweenDateAndTimestamps() throws SQLException {
        for (int i = 0; i < this.addBetweenDateAndTsTests.length; ++i) {
            this.addBetweenDateAndTsTests[i].runTest();
        }
    }

    public void testDiffBetweenString() throws SQLException {
        for (int i = 0; i < this.diffBetweenStringTests.length; ++i) {
            this.diffBetweenStringTests[i].runTest();
        }
    }

    public void testAddBetweenString() throws SQLException {
        for (int i = 0; i < this.addBetweenStringTests.length; ++i) {
            this.addBetweenStringTests[i].runTest();
        }
    }

    public void testOverflow() throws SQLException {
        for (int i = 0; i < this.overflowTests.length; ++i) {
            this.overflowTests[i].runTest();
        }
    }

    public void testNullInputs() throws SQLException {
        tsDiffPS[3].setTimestamp(1, TimestampArithTest.ts("2005-05-11 15:26:00"));
        tsDiffPS[3].setNull(2, 93);
        TimestampArithTest.expectNullResult(tsDiffPS[3]);
        tsDiffPS[3].setNull(2, 91);
        TimestampArithTest.expectNullResult(tsDiffPS[3]);
        tsDiffPS[3].setTimestamp(2, TimestampArithTest.ts("2005-05-11 15:26:00"));
        tsDiffPS[3].setNull(1, 93);
        TimestampArithTest.expectNullResult(tsDiffPS[3]);
        tsDiffPS[3].setNull(1, 91);
        TimestampArithTest.expectNullResult(tsDiffPS[3]);
        tsAddPS[2].setTimestamp(2, TimestampArithTest.ts("2005-05-11 15:26:00"));
        tsAddPS[2].setNull(1, 4);
        TimestampArithTest.expectNullResult(tsAddPS[2]);
        tsAddPS[2].setInt(1, 1);
        tsAddPS[2].setNull(2, 93);
        TimestampArithTest.expectNullResult(tsAddPS[2]);
        tsAddPS[2].setNull(2, 91);
        TimestampArithTest.expectNullResult(tsAddPS[2]);
    }

    public void testInvalidLengths() throws SQLException {
        for (int i = 0; i < this.invalid.length; ++i) {
            try {
                ResultSet rs = stmt.executeQuery(this.invalid[i][0]);
                rs.next();
                TimestampArithTest.fail((String)(this.invalid[i][0] + " did not throw an exception."));
                continue;
            }
            catch (SQLException sqle) {
                TimestampArithTest.assertSQLState("Unexpected SQLState from " + this.invalid[i][0], this.invalid[i][1], sqle);
            }
        }
    }

    public void testInvalidArgTypes() throws SQLException {
        TimestampArithTest.expectException(tsDiffPS[3], TimestampArithTest.ts("2005-05-21 15:26:00"), new Double(2.0), "XCL12", "TIMESTAMPDIFF with double ts2");
        TimestampArithTest.expectException(tsDiffPS[3], new Double(2.0), TimestampArithTest.ts("2005-05-11 15:26:00"), "XCL12", "TIMESTAMPDIFF with double ts1");
        TimestampArithTest.expectException(tsAddPS[2], new Integer(1), new Integer(-1), "XCL12", "TIMESTAMPADD with int ts");
        TimestampArithTest.expectException(tsAddPS[2], TimestampArithTest.ts("2005-05-11 15:26:00"), TimestampArithTest.ts("2005-05-11 15:26:00"), "XCL12", "TIMESTAMPADD with timestamp count");
    }

    private static void expectException(PreparedStatement ps, Object obj1, Object obj2, String expectedSQLState, String label) {
        try {
            ps.setObject(1, obj1);
            ps.setObject(2, obj2);
            ResultSet rs = ps.executeQuery();
            rs.next();
            TimestampArithTest.fail((String)(label + " did not throw an exception."));
        }
        catch (SQLException sqle) {
            TimestampArithTest.assertSQLState("Unexpected SQLState from " + label, expectedSQLState, sqle);
        }
    }

    private static void expectNullResult(PreparedStatement ps) throws SQLException {
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
    }

    private static String dateTimeToLiteral(Object ts) {
        if (ts instanceof Timestamp) {
            return "{ts '" + ((Timestamp)ts).toString() + "'}";
        }
        if (ts instanceof Time) {
            return "{t '" + ((Time)ts).toString() + "'}";
        }
        if (ts instanceof Date) {
            return "{d '" + ((Date)ts).toString() + "'}";
        }
        if (ts instanceof String) {
            return "TIMESTAMP( '" + (String)ts + "')";
        }
        return ts.toString();
    }

    private static String composeSqlStr(String fn, int interval, String parm1, String parm2) {
        return "values( {fn TIMESTAMP" + fn + "( " + intervalJdbcNames[interval] + ", " + parm1 + "," + parm2 + ")})";
    }

    private static void setDateTime(PreparedStatement ps, int parameterIdx, java.util.Date dateTime) throws SQLException {
        if (dateTime instanceof Timestamp) {
            ps.setTimestamp(parameterIdx, (Timestamp)dateTime);
        } else if (dateTime instanceof Date) {
            ps.setDate(parameterIdx, (Date)dateTime);
        } else if (dateTime instanceof Time) {
            ps.setTime(parameterIdx, (Time)dateTime);
        } else {
            ps.setTimestamp(parameterIdx, (Timestamp)dateTime);
        }
    }

    private static Timestamp ts(String s) {
        if (s.length() < 29) {
            StringBuffer sb = new StringBuffer(s);
            if (s.length() == 19) {
                sb.append('.');
            }
            while (sb.length() < 29) {
                sb.append('0');
            }
            s = sb.toString();
        }
        return Timestamp.valueOf(s);
    }

    private static Date dt(String s) {
        return Date.valueOf(s);
    }

    static {
        tsAddPS = new PreparedStatement[intervalJdbcNames.length];
        tsDiffPS = new PreparedStatement[intervalJdbcNames.length];
    }

    private class OneStringAddTest
    extends OneAddTest {
        private final String ts;

        OneStringAddTest(int interval, int count, String ts, Timestamp expected, String expectedSQLState, String expectedMsg) {
            super(interval, count, null, expected, expectedSQLState, expectedMsg);
            this.ts = ts;
        }

        String composeSQL() {
            return TimestampArithTest.composeSqlStr("ADD", this.interval, String.valueOf(this.count), TimestampArithTest.dateTimeToLiteral(this.ts));
        }

        ResultSet executePS() throws SQLException {
            tsAddPS[this.interval].setInt(1, this.count);
            tsAddPS[this.interval].setString(2, this.ts);
            return tsAddPS[this.interval].executeQuery();
        }
    }

    private class OneAddTest
    extends OneTest {
        private final java.util.Date ts;
        final int count;
        final Timestamp expected;

        OneAddTest(int interval, int count, java.util.Date ts, Timestamp expected, String expectedSQLState, String expectedMsg) {
            super(interval, expectedSQLState, expectedMsg);
            this.count = count;
            this.ts = ts;
            this.expected = expected;
        }

        String composeSQL() {
            return TimestampArithTest.composeSqlStr("ADD", this.interval, String.valueOf(this.count), TimestampArithTest.dateTimeToLiteral(this.ts));
        }

        void checkResultRow(ResultSet rs, String sql) throws SQLException {
            Timestamp actual = rs.getTimestamp(1);
            Assert.assertFalse((String)("Unexpected null result from '" + sql + "'."), ((rs.wasNull() || actual == null) && this.expected != null ? 1 : 0) != 0);
            Assert.assertFalse((String)("Expected null result from '" + sql + "'."), (!rs.wasNull() && actual != null && this.expected == null ? 1 : 0) != 0);
            Assert.assertEquals((String)("Unexpected result from '" + sql + "'."), (Object)this.expected, (Object)actual);
        }

        ResultSet executePS() throws SQLException {
            tsAddPS[this.interval].setInt(1, this.count);
            TimestampArithTest.setDateTime(tsAddPS[this.interval], 2, this.ts);
            return tsAddPS[this.interval].executeQuery();
        }
    }

    private class OneStringDiffTest
    extends OneDiffTest {
        private final String ts1;
        private final String ts2;

        OneStringDiffTest(int interval, String ts1, String ts2, int expectedDiff, String expectedSQLState, String expectedMsg) {
            super(interval, null, null, expectedDiff, expectedSQLState, expectedMsg);
            this.ts1 = ts1;
            this.ts2 = ts2;
            this.expectNull = ts1 == null || ts2 == null;
        }

        String composeSQL() {
            return TimestampArithTest.composeSqlStr("DIFF", this.interval, TimestampArithTest.dateTimeToLiteral(this.ts1), TimestampArithTest.dateTimeToLiteral(this.ts2));
        }

        ResultSet executePS() throws SQLException {
            tsDiffPS[this.interval].setString(1, this.ts1);
            tsDiffPS[this.interval].setString(2, this.ts2);
            return tsDiffPS[this.interval].executeQuery();
        }
    }

    private class OneDiffTest
    extends OneTest {
        private final java.util.Date ts1;
        private final java.util.Date ts2;
        private final int expectedDiff;
        protected boolean expectNull;

        OneDiffTest(int interval, java.util.Date ts1, java.util.Date ts2, int expectedDiff, String expectedSQLState, String expectedMsg) {
            super(interval, expectedSQLState, expectedMsg);
            this.ts1 = ts1;
            this.ts2 = ts2;
            this.expectedDiff = expectedDiff;
            this.expectNull = ts1 == null || ts2 == null;
        }

        void checkResultRow(ResultSet rs, String sql) throws SQLException {
            int actualDiff = rs.getInt(1);
            Assert.assertFalse((String)("Unexpected null result from '" + sql + "'."), (rs.wasNull() && !this.expectNull ? 1 : 0) != 0);
            Assert.assertFalse((String)("Expected null result from '" + sql + "'."), (!rs.wasNull() && this.expectNull ? 1 : 0) != 0);
            Assert.assertEquals((String)("Unexpected result from '" + sql + "'."), (int)this.expectedDiff, (int)actualDiff);
        }

        String composeSQL() {
            return TimestampArithTest.composeSqlStr("DIFF", this.interval, TimestampArithTest.dateTimeToLiteral(this.ts1), TimestampArithTest.dateTimeToLiteral(this.ts2));
        }

        ResultSet executePS() throws SQLException {
            TimestampArithTest.setDateTime(tsDiffPS[this.interval], 1, this.ts1);
            TimestampArithTest.setDateTime(tsDiffPS[this.interval], 2, this.ts2);
            return tsDiffPS[this.interval].executeQuery();
        }
    }

    private abstract class OneTest {
        final int interval;
        final String expectedSQLState;
        final String expectedMsg;
        String sql;

        OneTest(int interval, String expectedSQLState, String expectedMsg) {
            this.interval = interval;
            this.expectedSQLState = expectedSQLState;
            this.expectedMsg = expectedMsg;
        }

        void runTest() throws SQLException {
            ResultSet rs = null;
            this.sql = this.composeSQL();
            try {
                rs = stmt.executeQuery(this.sql);
                this.checkResultSet(rs, this.sql);
                if (this.expectedSQLState != null) {
                    Assert.fail((String)("Statement '" + this.sql + "' did not generate an exception"));
                }
            }
            catch (SQLException sqle) {
                if (this.expectedSQLState == null) {
                    BaseTestCase.fail("Unexpected exception from statement '" + this.sql + "'", sqle);
                }
                BaseJDBCTestCase.assertSQLState("Incorrect SQLState from statement '" + this.sql + "'", this.expectedSQLState, sqle);
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            try {
                rs = this.executePS();
                this.checkResultSet(rs, this.sql);
                if (this.expectedSQLState != null) {
                    Assert.fail((String)("Prepared Statement '" + this.sql + "' did not generate an exception"));
                }
            }
            catch (SQLException sqle) {
                if (this.expectedSQLState == null) {
                    BaseTestCase.fail("Unexpected exception from prepared statement '" + this.sql + "'", sqle);
                }
                BaseJDBCTestCase.assertSQLState("Incorrect SQLState from prepared statement '" + this.sql + "'", this.expectedSQLState, sqle);
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }

        private void checkResultSet(ResultSet rs, String sql) throws SQLException {
            Assert.assertTrue((String)("'" + sql + "' did not return any rows."), (boolean)rs.next());
            this.checkResultRow(rs, sql);
            Assert.assertFalse((String)("'" + sql + "' returned more than one row."), (boolean)rs.next());
        }

        abstract String composeSQL();

        abstract void checkResultRow(ResultSet var1, String var2) throws SQLException;

        abstract ResultSet executePS() throws SQLException;
    }
}

