/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.lang.DBOperations;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UniqueConstraintMultiThreadedTest
extends BaseJDBCTestCase {
    private DataSource ds;

    public UniqueConstraintMultiThreadedTest() {
        super("Multi Threaded Unique Constraint Test");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeThreads(int isolation1, int isolation2, boolean commit) throws Exception {
        Connection con1 = this.ds.getConnection();
        con1.setTransactionIsolation(isolation1);
        Connection con2 = this.ds.getConnection();
        try {
            con2.setTransactionIsolation(isolation2);
            DBOperations dbo1 = new DBOperations(con1, 5);
            DBOperations dbo2 = new DBOperations(con2, 5);
            dbo1.delete();
            Thread t = new Thread(dbo2);
            t.start();
            Thread.sleep(2000L);
            if (commit) {
                dbo1.rollback();
                t.join();
                UniqueConstraintMultiThreadedTest.assertSQLState("isolation levels: " + isolation1 + " " + isolation2, "23505", dbo2.getException());
            } else {
                dbo1.commit();
                t.join();
                UniqueConstraintMultiThreadedTest.assertNull((String)("isolation levels: " + isolation1 + " " + isolation2), (Object)dbo2.getException());
            }
            UniqueConstraintMultiThreadedTest.assertNull((String)("unexpected failure: " + isolation1 + " " + isolation2), (Object)dbo2.getUnexpectedException());
        }
        finally {
            con1.commit();
            con2.commit();
            con1.close();
            con2.close();
        }
    }

    public void testLockingWithcommit() throws Exception {
        this.ds = JDBCDataSource.getDataSource();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.executeThreads((int)Math.pow(2.0, i), (int)Math.pow(2.0, j), true);
            }
        }
    }

    public void testLockingWithRollback() throws Exception {
        this.ds = JDBCDataSource.getDataSource();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.executeThreads((int)Math.pow(2.0, i), (int)Math.pow(2.0, j), false);
            }
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("UniqueConstraintTest");
        suite.addTest(TestConfiguration.embeddedSuite(UniqueConstraintMultiThreadedTest.class));
        return suite;
    }

    protected void setUp() throws Exception {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.execute("create table tab1 (i integer)");
        stmt.executeUpdate("alter table tab1 add constraint con1 unique (i)");
        PreparedStatement ps = con.prepareStatement("insert into tab1 values (?)");
        for (int i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        con.commit();
    }

    protected void tearDown() throws Exception {
        Connection con = this.getConnection();
        con.createStatement().executeUpdate("drop table tab1");
    }
}

