/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.IndexStatsUtil;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UpdateStatisticsTest
extends BaseJDBCTestCase {
    public UpdateStatisticsTest(String name) {
        super(name);
    }

    public static Test suite() {
        Test test = TestConfiguration.defaultSuite(UpdateStatisticsTest.class);
        Test statsDisabled = DatabasePropertyTestSetup.singleProperty(test, "derby.storage.indexStats.auto", "false", true);
        return statsDisabled;
    }

    public void testUpdateStatistics() throws SQLException {
        IndexStatsUtil stats = new IndexStatsUtil(this.openDefaultConnection());
        Statement s = this.createStatement();
        UpdateStatisticsTest.assertStatementError("42Y55", s, "CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',null)");
        s.executeUpdate("CREATE TABLE t1 (c11 int, c12 varchar(128))");
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',null)");
        UpdateStatisticsTest.assertStatementError("42X65", s, "CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        s.executeUpdate("CREATE INDEX i1 on t1(c12)");
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        stats.assertNoStats();
        s.executeUpdate("INSERT INTO T1 VALUES(1,'a'),(2,'b'),(3,'c'),(4,'d')");
        s.executeUpdate("CREATE INDEX i2 ON t1(c11)");
        stats.assertStats(1);
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        stats.assertStats(2);
        UpdateStatisticsTest.assertStatementError("42X01", s, "ALTER TABLE APP.T1 ALL UPDATE STATISTICS");
        UpdateStatisticsTest.assertStatementError("42X01", s, "ALTER TABLE APP.T1 UPDATE STATISTICS I1");
        s.executeUpdate("DROP TABLE t1");
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit delete rows not logged");
        s.executeUpdate("insert into session.t1 values(11, 1)");
        UpdateStatisticsTest.assertStatementError("42995", s, "CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('SESSION','T1',null)");
        s.executeUpdate("CREATE TABLE t2(c21 int, c22 char(14), c23 char(200))");
        s.executeUpdate("CREATE INDEX t2i1 ON t2(c21)");
        s.executeUpdate("CREATE INDEX t2i2 ON t2(c22)");
        stats.assertNoStats();
        PreparedStatement ps = this.prepareStatement("INSERT INTO T2 VALUES(?,?,?)");
        for (int i = 0; i < 1000; ++i) {
            ps.setInt(1, i % 2);
            ps.setString(2, "Tuple " + i);
            ps.setString(3, "any value");
            ps.addBatch();
        }
        ps.executeBatch();
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ps = this.prepareStatement("SELECT * FROM t2 WHERE c21=? AND c22=?");
        ps.setInt(1, 0);
        ps.setString(2, "Tuple 4");
        JDBC.assertDrainResults(ps.executeQuery());
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        UpdateStatisticsTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T2", "T2I1"));
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T2','T2I2')");
        stats.assertIndexStats("T2I2", 1);
        JDBC.assertDrainResults(ps.executeQuery());
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        UpdateStatisticsTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T2", "T2I2"));
        s.executeUpdate("DROP TABLE t2");
        stats.release();
    }

    public void testNoExclusiveLockOnTable() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t (x char(1))");
        s.execute("create index ti on t(x)");
        s.execute("insert into t values 'a','b','c','d'");
        this.setAutoCommit(false);
        s.execute("lock table t in share mode");
        Connection c2 = this.openDefaultConnection();
        Statement s2 = c2.createStatement();
        s2.execute("call syscs_util.syscs_update_statistics('APP', 'T', null)");
        s2.close();
        c2.close();
        s.execute("drop table t");
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelCompilationAndUpdate() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table derby5153(a int, b int, c int, d int)");
        s.execute("create index idx on derby5153(a,b,c,d)");
        PreparedStatement ins = this.prepareStatement("insert into derby5153 values (1,2,3,4)");
        for (int i = 0; i < 100; ++i) {
            ins.execute();
        }
        this.commit();
        Connection updateConn = this.openDefaultConnection();
        IndexUpdateThread t = new IndexUpdateThread(updateConn, "APP", "DERBY5153", "IDX");
        t.start();
        try {
            for (int i = 0; i < 100; ++i) {
                ResultSet rs = s.executeQuery("select * from derby5153 t1, derby5153 t2 where t1.a = t2.a");
                rs.close();
            }
        }
        finally {
            t.done = true;
        }
        t.join();
        if (t.exception != null) {
            throw t.exception;
        }
        updateConn.close();
        this.dropTable("derby5153");
        this.commit();
    }

    private static class IndexUpdateThread
    extends Thread {
        private final CallableStatement updateStats;
        private volatile boolean done;
        private Exception exception;

        private IndexUpdateThread(Connection c, String schema, String table, String index) throws SQLException {
            this.updateStats = c.prepareCall("call syscs_util.syscs_update_statistics(?,?,?)");
            this.updateStats.setString(1, schema);
            this.updateStats.setString(2, table);
            this.updateStats.setString(3, index);
        }

        public void run() {
            try {
                while (!this.done) {
                    this.updateStats.execute();
                }
                this.updateStats.close();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

