/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.memorydb.ClusMog;
import org.apache.derbyTesting.functionTests.tests.memorydb.ClusMogSQL;
import org.apache.derbyTesting.functionTests.tests.memorydb.GenMog;
import org.apache.derbyTesting.functionTests.tests.memorydb.SampMog;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MogTest
extends BaseJDBCTestCase {
    public MogTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(MogTest.class);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testClusMogOnDisk() throws SQLException {
        long start = System.currentTimeMillis();
        this.doTestClusMog(this.getConnection());
        MogTest.println("duration-on-disk: " + (System.currentTimeMillis() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClusMogInMemory() throws SQLException {
        long start = System.currentTimeMillis();
        Connection conn = this.obtainConnection();
        try {
            this.doTestClusMog(conn);
        }
        finally {
            try {
                conn.rollback();
                conn.close();
            }
            catch (SQLException sqle) {}
            this.dropInMemoryDb();
        }
        MogTest.println("duration-in-memory: " + (System.currentTimeMillis() - start));
    }

    public void doTestClusMog(Connection conn) throws SQLException {
        long _seed = 1241411544935L;
        Random rng = new Random(1241411544935L);
        GenMog genMog = new GenMog(rng);
        SampMog sampMog = new SampMog(rng);
        ClusMog clusMog = new ClusMog();
        ClusMogSQL clusMogSql = new ClusMogSQL(conn);
        clusMogSql.setUnique(rng.nextInt());
        MogTest.println(this.getName() + " using random seed: " + 1241411544935L);
        int max_ns = 1920;
        double[] sample = new double[1920];
        double[] center = new double[6];
        boolean niter = true;
        for (int i = 1; i > 0; --i) {
            genMog.generate();
            int min_ns = 32 * genMog.n;
            int ns = min_ns + rng.nextInt(1920 - min_ns);
            MogTest.println("ns = " + ns);
            sampMog.set(genMog.n, genMog.weight, genMog.mean, genMog.var);
            sampMog.generate(ns, sample);
            ClusMog.uniform(genMog.n, center, ns, sample);
            clusMog.cluster(genMog.n, center, ns, sample);
            clusMogSql.clusterSQL(genMog.n, center, ns, sample);
            MogTest.assertEquals((String)"MOG configurations differ, seed=1241411544935", (int)clusMog.n, (int)clusMogSql.n);
            this.compare(clusMog.n, clusMog.weight, clusMogSql.weight, 1241411544935L);
            this.compare(clusMog.n, clusMog.mean, clusMogSql.mean, 1241411544935L);
            this.compare(clusMog.n, clusMog.var, clusMogSql.var, 1241411544935L);
            ClusMog.random(genMog.n, center, ns, sample, rng);
            clusMog.cluster(genMog.n, center, ns, sample);
            clusMogSql.clusterSQL(genMog.n, center, ns, sample);
            MogTest.assertEquals((String)"MOG configurations differ, seed=1241411544935", (int)clusMog.n, (int)clusMogSql.n);
            this.compare(clusMog.n, clusMog.weight, clusMogSql.weight, 1241411544935L);
            this.compare(clusMog.n, clusMog.mean, clusMogSql.mean, 1241411544935L);
            this.compare(clusMog.n, clusMog.var, clusMogSql.var, 1241411544935L);
        }
    }

    private void compare(int n, double[] ones, double[] oths, long seed) {
        double thresh = 1.0E-6;
        for (int i = 0; i < n; ++i) {
            double one = ones[i];
            double oth = oths[i];
            double dif = Math.abs(one - oth);
            double err = dif / (1.0 + Math.abs(one));
            if (!(err >= 1.0E-6)) continue;
            MogTest.fail((String)("Error too big;" + err + " >= " + 1.0E-6 + ", seed=" + seed));
        }
    }

    private Connection obtainConnection() throws SQLException {
        try {
            if (MogTest.usingDerbyNetClient()) {
                Class.forName("org.apache.derby.jdbc.ClientDriver");
            } else {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            }
        }
        catch (Exception e) {
            SQLException sqle = new SQLException(e.getMessage());
            sqle.initCause(e);
            throw sqle;
        }
        StringBuffer sb = this.constructUrl().append(";create=true");
        return DriverManager.getConnection(sb.toString());
    }

    private void dropInMemoryDb() throws SQLException {
        StringBuffer sb = this.constructUrl().append(";drop=true");
        try {
            DriverManager.getConnection(sb.toString());
            MogTest.fail((String)"Dropping database should have raised exception.");
        }
        catch (SQLException sqle) {
            MogTest.assertSQLState("08006", sqle);
        }
    }

    private StringBuffer constructUrl() {
        StringBuffer sb = new StringBuffer("jdbc:derby:");
        if (MogTest.usingEmbedded()) {
            sb.append("memory:");
        } else {
            sb.append("//");
            sb.append(TestConfiguration.getCurrent().getHostName());
            sb.append(':');
            sb.append(TestConfiguration.getCurrent().getPort());
            sb.append('/');
            sb.append("memory:");
        }
        sb.append("MogTestDb");
        return sb;
    }
}

