/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.perf;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.util.JarUtil;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public class StartupExistingDBTest
extends BaseJDBCTestCase {
    public StartupExistingDBTest(String name) {
        super(name);
    }

    public void testExistingDB() throws Exception {
        JarUtil.unjar("existingDb.jar", null);
        long startTime = System.currentTimeMillis();
        System.out.println("Testing startup with an EXISTING database... All measurements are in milliseconds.");
        Class<?> driver = Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        long currentTime = System.currentTimeMillis();
        System.out.println("Loading driver:  " + (currentTime - startTime));
        startTime = System.currentTimeMillis();
        Connection conn = DriverManager.getConnection("jdbc:derby:../existingDb");
        currentTime = System.currentTimeMillis();
        System.out.println("Open connection with existing database:  " + (currentTime - startTime));
        startTime = System.currentTimeMillis();
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE test_table(id integer primary key, last_name varchar(80), first_name varchar(80), mi char(1), address varchar(100), city varchar(80))");
        currentTime = System.currentTimeMillis();
        System.out.println("Creating a table:  " + (currentTime - startTime));
    }
}

