/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.store.StoreBaseTest;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class Derby4577Test
extends StoreBaseTest {
    public Derby4577Test(String name) {
        super(name);
    }

    public void testDERBY_4577() throws SQLException {
        int i;
        Statement stmt = this.createStatement();
        PreparedStatement insert_stmt = this.prepareStatement("INSERT INTO testBadUpdate VALUES(?, ?)");
        PreparedStatement update_stmt = this.prepareStatement("UPDATE testBadUpdate set value = ? where id = ?");
        byte[] pad_blob = new byte[1];
        for (i = 0; i < 3; ++i) {
            insert_stmt.setInt(1, i);
            insert_stmt.setBytes(2, pad_blob);
            insert_stmt.executeUpdate();
        }
        this.commit();
        pad_blob = new byte[32000];
        insert_stmt.setInt(1, 3);
        insert_stmt.setBytes(2, pad_blob);
        insert_stmt.executeUpdate();
        pad_blob = new byte[4000];
        for (i = 0; i < 3; ++i) {
            update_stmt.setBytes(1, pad_blob);
            update_stmt.setInt(2, i);
            update_stmt.executeUpdate();
        }
        this.commit();
        pad_blob = new byte[32566];
        update_stmt.setBytes(1, pad_blob);
        update_stmt.setInt(2, 3);
        update_stmt.executeUpdate();
        this.commit();
        pad_blob = new byte[60000];
        update_stmt.setBytes(1, pad_blob);
        update_stmt.setInt(2, 0);
        update_stmt.executeUpdate();
        this.commit();
        pad_blob = new byte[32500];
        update_stmt.setBytes(1, pad_blob);
        update_stmt.setInt(2, 1);
        update_stmt.executeUpdate();
        this.commit();
        pad_blob = new byte[32646];
        update_stmt.setBytes(1, pad_blob);
        update_stmt.setInt(2, 2);
        update_stmt.executeUpdate();
        this.commit();
        pad_blob = new byte[120000];
        update_stmt.setBytes(1, pad_blob);
        update_stmt.setInt(2, 0);
        update_stmt.executeUpdate();
        this.commit();
        stmt.close();
        insert_stmt.close();
        update_stmt.close();
    }

    public void testSmallRow1() throws SQLException {
        int i;
        Statement stmt = this.createStatement();
        PreparedStatement insert_stmt = this.prepareStatement("INSERT INTO testSmallRow1 VALUES(?)");
        insert_stmt.setString(1, "a");
        for (int i2 = 0; i2 < 4000; ++i2) {
            insert_stmt.executeUpdate();
        }
        insert_stmt.close();
        this.commit();
        stmt.executeUpdate("CREATE INDEX idx1 on testSmallRow1(id)");
        ResultSet rs = stmt.executeQuery("VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'TESTSMALLROW1')");
        Object[][] expRS = new String[][]{{"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        stmt.executeUpdate("CREATE INDEX idx2 on testSmallRow2(id)");
        insert_stmt = this.prepareStatement("INSERT INTO testSmallRow2 VALUES(?)");
        insert_stmt.setString(1, "a");
        for (i = 0; i < 4000; ++i) {
            insert_stmt.executeUpdate();
        }
        insert_stmt.close();
        this.commit();
        rs = stmt.executeQuery("VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'TESTSMALLROW2')");
        expRS = new String[][]{{"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        stmt.executeUpdate("CREATE INDEX idx3 on testSmallRow3(id)");
        insert_stmt = this.prepareStatement("INSERT INTO testSmallRow3 VALUES(?, ?)");
        insert_stmt.setString(1, null);
        for (i = 0; i < 100; ++i) {
            insert_stmt.setInt(2, i);
            insert_stmt.executeUpdate();
        }
        this.commit();
        stmt.executeUpdate("UPDATE testSmallRow3 set id = null where id2 > 1");
        stmt.executeUpdate("DELETE from testSmallRow3 where id2 = 40 or id2 = 41 or id2 = 80 or id2 = 81");
        this.commit();
        insert_stmt.setString(1, null);
        for (i = 101; i < 600; ++i) {
            insert_stmt.executeUpdate();
            insert_stmt.setInt(2, i);
        }
        insert_stmt.close();
        this.commit();
        rs = stmt.executeQuery("VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'TESTSMALLROW3')");
        expRS = new String[][]{{"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        stmt.close();
    }

    protected static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(Derby4577Test.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)suite, 2, 4)){

            protected void decorateSQL(Statement stmt) throws SQLException {
                Connection conn = stmt.getConnection();
                stmt.executeUpdate("CREATE TABLE testBadUpdate (id int, value blob(1M))");
                stmt.executeUpdate("CREATE TABLE testSmallRow1 (id char(1))");
                stmt.executeUpdate("CREATE TABLE testSmallRow2 (id char(1))");
                stmt.executeUpdate("CREATE TABLE testSmallRow3 (id char(20), id2 int)");
                conn.setAutoCommit(false);
            }
        };
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Derby4577Test");
        suite.addTest(Derby4577Test.baseSuite("Derby4577Test:embedded"));
        return suite;
    }
}

