/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.storetests;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.store.BaseTest;

public class st_derby715
extends BaseTest {
    static boolean verbose = false;

    private static void setup() throws Exception {
        Connection conn = ij.startJBMS();
        Statement stmt = conn.createStatement();
        try {
            stmt.executeUpdate("drop table a");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            stmt.executeUpdate("drop table b");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stmt.executeUpdate("create table a (a integer)");
        stmt.executeUpdate("create table b (b integer)");
        stmt.close();
        conn.commit();
        conn.close();
    }

    public void testList(Connection conn) throws SQLException {
    }

    public static void main(String[] argv) throws Throwable {
        ij.getPropertyArg((String[])argv);
        st_derby715 setup_ddl = new st_derby715();
        setup_ddl.setup();
        setup_ddl = null;
        for (int i = 0; i < 5; ++i) {
            Thread test1 = new Thread(new t1(argv));
            Thread test2 = new Thread(new t2(argv));
            test1.start();
            test2.start();
            test1.join();
            test2.join();
        }
    }

    public static class t2
    implements Runnable {
        String[] argv;

        public t2(String[] argv) {
        }

        public void run() {
            try {
                ij.getPropertyArg((String[])this.argv);
                Connection conn = ij.startJBMS();
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(8);
                Statement stmt = conn.createStatement();
                if (verbose) {
                    System.out.println("Thread 2 before selecting from a");
                }
                ResultSet rs = stmt.executeQuery("select * from a");
                if (verbose) {
                    System.out.println("Thread 2 before selecting next from a");
                }
                while (rs.next()) {
                    if (!verbose) continue;
                    System.out.println("Thread t2 got " + rs.getString(1));
                }
                if (verbose) {
                    System.out.println("Thread 2 after all next.");
                }
                Thread.sleep(500L);
                if (verbose) {
                    System.out.println("Thread 2 before inserting into b");
                }
                stmt.executeUpdate("insert into b values(2)");
                if (verbose) {
                    System.out.println("Thread 2 after inserting into b");
                }
                conn.rollback();
            }
            catch (SQLException sqle) {
                if (verbose) {
                    System.out.println("Thread 1 got exception:\n");
                }
                if (sqle.getSQLState().equals("40001")) {
                    System.out.println("Got a Deadlock.");
                } else {
                    JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
                    sqle.printStackTrace(System.out);
                }
            }
            catch (Exception ex) {
                System.out.println("got unexpected exception: " + ex);
            }
        }
    }

    public static class t1
    implements Runnable {
        String[] argv;

        public t1(String[] argv) {
        }

        public void run() {
            try {
                ij.getPropertyArg((String[])this.argv);
                Connection conn = ij.startJBMS();
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(8);
                Statement stmt = conn.createStatement();
                if (verbose) {
                    System.out.println("Thread 1 before selecting from b");
                }
                ResultSet rs = stmt.executeQuery("select * from b");
                if (verbose) {
                    System.out.println("Thread 1 before selecting next from b");
                }
                while (rs.next()) {
                    if (!verbose) continue;
                    System.out.println("Thread t1 got " + rs.getString(1));
                }
                if (verbose) {
                    System.out.println("Thread 1 after all next.");
                }
                Thread.sleep(500L);
                if (verbose) {
                    System.out.println("Thread 1 before inserting into a...");
                }
                stmt.executeUpdate("insert into a values(1)");
                if (verbose) {
                    System.out.println("Thread 1 after inserting into a...");
                }
                conn.rollback();
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().equals("40001")) {
                    System.out.println("Got a Deadlock.");
                } else {
                    JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
                    sqle.printStackTrace(System.out);
                }
                if (verbose) {
                    System.out.println("Thread 1 got exception:\n");
                }
            }
            catch (Exception ex) {
                System.out.println("got unexpected exception: " + ex);
            }
        }
    }
}

