/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.ScriptTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class IjConnNameTest
extends ScriptTestCase {
    private static String test_script = "ijConnName";

    public IjConnNameTest(String name) {
        super(name, true);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("IjConnNameTest");
        if (JDBC.vmSupportsJSR169()) {
            return suite;
        }
        Properties props = new Properties();
        props.setProperty("ij.connection.connOne", "jdbc:derby:wombat;create=true");
        props.setProperty("ij.connection.connFour", "jdbc:derby:nevercreated");
        props.setProperty("ij.showNoConnectionsAtStart", "true");
        props.setProperty("ij.showNoCountForSelect", "true");
        TestSetup test = new SystemPropertyTestSetup((Test)new IjConnNameTest(test_script), props);
        test = new CleanDatabaseTestSetup((Test)test);
        return IjConnNameTest.getIJConfig((Test)test);
    }

    public void tearDown() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                this.removeDatabase("lemming");
                return null;
            }

            void removeDatabase(String dbName) {
                dbName = dbName.replace('/', File.separatorChar);
                String dsh = IjConnNameTest.getSystemProperty("derby.system.home");
                if (dsh == null) {
                    Assert.fail((String)"not implemented");
                } else {
                    dbName = dsh + File.separator + dbName;
                }
                this.removeDirectory(dbName);
            }

            void removeDirectory(String path) {
                File dir = new File(path);
                this.removeDir(dir);
            }

            private void removeDir(File dir) {
                if (!dir.exists()) {
                    return;
                }
                String[] list = dir.list();
                if (list != null) {
                    for (int i = 0; i < list.length; ++i) {
                        File entry = new File(dir, list[i]);
                        if (entry.isDirectory()) {
                            this.removeDir(entry);
                            continue;
                        }
                        entry.delete();
                    }
                }
                dir.delete();
            }
        });
        super.tearDown();
    }
}

