/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_8
extends UpgradeChange {
    public Changes10_8(String name) {
        super(name);
    }

    public static Test suite(int phase) {
        TestSuite suite = new TestSuite("Upgrade test for 10.8");
        suite.addTestSuite(Changes10_8.class);
        return new SupportFilesSetup((Test)suite);
    }

    public void testDERBY5121TriggerTest2() throws Exception {
        Statement s = this.createStatement();
        boolean modeDb2SqlOptional = this.oldAtLeast(10, 3);
        String updateSQL = "update media set name = 'Mon Liza', description = 'Something snarky.' where mediaID = 1";
        switch (this.getPhase()) {
            case 0: {
                s.execute("create table folder ( folderType\tint\tnot null, folderID\tint\tnot null, folderParent int, folderName varchar(50) not null)");
                s.execute("create table media ( mediaID int not null, name varchar(50)\tnot null, description clob not null, mediaType varchar(50), mediaContents\tblob, folderID int not null\tdefault 7)");
                s.execute("create trigger mediaInsrtDupTrgr after INSERT on media referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "values( nr.folderID, 7, nr.name)");
                s.execute("create trigger mediaUpdtDupTrgr after UPDATE of folderID, name on media referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "values( nr.folderID, 7, nr.name)");
                s.executeUpdate("insert into folder(folderType, folderID, folderParent, folderName ) values ( 7, 7, null, 'media' )");
                s.executeUpdate("insert into media(mediaID, name, description)values (1, 'Mona Lisa', 'A photo of the Mona Lisa')");
                if (this.oldIs(10, 7, 1, 1)) {
                    Changes10_8.assertStatementError("XCL12", s, updateSQL);
                    break;
                }
                s.executeUpdate(updateSQL);
                break;
            }
            case 1: {
                s.executeUpdate(updateSQL);
                break;
            }
            case 2: {
                if (this.oldIs(10, 7, 1, 1)) {
                    Changes10_8.assertStatementError("S0022", s, updateSQL);
                    break;
                }
                s.executeUpdate(updateSQL);
                break;
            }
            case 3: {
                s.executeUpdate(updateSQL);
                break;
            }
            case 4: {
                s.executeUpdate(updateSQL);
                s.executeUpdate("drop table media");
                s.executeUpdate("drop table folder");
            }
        }
    }

    public void testDERBY5121TriggerDataCorruption() throws Exception {
        Statement s = this.createStatement();
        boolean modeDb2SqlOptional = this.oldAtLeast(10, 3);
        switch (this.getPhase()) {
            case 0: {
                s.execute("CREATE TABLE UPGRADE_tab1(id int, name varchar(20))");
                s.execute("CREATE TABLE UPGRADE_tab2(name varchar(20) not null, description int not null, id int)");
                s.execute("create trigger UPGRADE_Trg1 after UPDATE of name on UPGRADE_tab2 referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into UPGRADE_tab1 values ( nr.id, nr.name )");
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet rs = s.executeQuery("select * from UPGRADE_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                s.execute("CREATE TABLE POSTSFT_UPGRD_tab1(id int, name varchar(20))");
                s.execute("CREATE TABLE POSTSFT_UPGRD_tab2(name varchar(20) not null, description int not null, id int)");
                s.execute("create trigger POSTSFT_UPGRD_Trg1 after UPDATE of name on POSTSFT_UPGRD_tab2 referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into POSTSFT_UPGRD_tab1 values ( nr.id, nr.name )");
                s.execute("insert into POSTSFT_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update POSTSFT_UPGRD_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from POSTSFT_UPGRD_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from POSTSFT_UPGRD_tab1");
                s.execute("delete from POSTSFT_UPGRD_tab2");
                s.execute("CREATE TABLE HARD_UPGRADE_tab1(id int, name varchar(20))");
                s.execute("CREATE TABLE HARD_UPGRADE_tab2(name varchar(20) not null, description int not null, id int)");
                s.execute("create trigger HARD_UPGRADE_Trg1 after UPDATE of name on HARD_UPGRADE_tab2 referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into HARD_UPGRADE_tab1 values ( nr.id, nr.name )");
                s.execute("insert into HARD_UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update HARD_UPGRADE_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from HARD_UPGRADE_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from HARD_UPGRADE_tab1");
                s.execute("delete from HARD_UPGRADE_tab2");
                s.execute("CREATE TABLE POSTHRD_UPGRD_tab1(id int, name varchar(20))");
                s.execute("CREATE TABLE POSTHRD_UPGRD_tab2(name varchar(20) not null, description int not null, id int)");
                s.execute("create trigger POSTHRD_UPGRD_Trg1 after UPDATE of name on POSTHRD_UPGRD_tab2 referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into POSTHRD_UPGRD_tab1 values ( nr.id, nr.name )");
                s.execute("insert into POSTHRD_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update POSTHRD_UPGRD_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from POSTHRD_UPGRD_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from POSTHRD_UPGRD_tab1");
                s.execute("delete from POSTHRD_UPGRD_tab2");
                break;
            }
            case 1: {
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet rs = s.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                s.execute("drop trigger UPGRADE_Trg1");
                s.execute("create trigger UPGRADE_Trg1 after UPDATE of name on UPGRADE_tab2 referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into UPGRADE_tab1 values ( nr.id, nr.name )");
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                break;
            }
            case 2: {
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet rs = s.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                s.execute("drop trigger UPGRADE_Trg1");
                s.execute("create trigger UPGRADE_Trg1 after UPDATE of name on UPGRADE_tab2 referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into UPGRADE_tab1 values ( nr.id, nr.name )");
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from UPGRADE_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                s.execute("insert into POSTSFT_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update POSTSFT_UPGRD_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from POSTSFT_UPGRD_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from POSTSFT_UPGRD_tab1");
                s.execute("delete from POSTSFT_UPGRD_tab2");
                s.execute("insert into HARD_UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update HARD_UPGRADE_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from HARD_UPGRADE_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from HARD_UPGRADE_tab1");
                s.execute("delete from HARD_UPGRADE_tab2");
                s.execute("insert into POSTHRD_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update POSTHRD_UPGRD_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from POSTHRD_UPGRD_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from POSTHRD_UPGRD_tab1");
                s.execute("delete from POSTHRD_UPGRD_tab2");
                break;
            }
            case 3: {
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet rs = s.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                s.execute("insert into HARD_UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update HARD_UPGRADE_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from HARD_UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from HARD_UPGRADE_tab1");
                s.execute("delete from HARD_UPGRADE_tab2");
                break;
            }
            case 4: {
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet rs = s.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                s.execute("insert into HARD_UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update HARD_UPGRADE_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from HARD_UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from HARD_UPGRADE_tab1");
                s.execute("delete from HARD_UPGRADE_tab2");
                s.execute("insert into POSTHRD_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update POSTHRD_UPGRD_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from POSTHRD_UPGRD_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from POSTHRD_UPGRD_tab1");
                s.execute("delete from POSTHRD_UPGRD_tab2");
            }
        }
    }
}

