/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JDBC {
    public static final String[] GET_TABLES_TABLE;
    public static final String[] GET_TABLES_VIEW;
    public static final String[] GET_TABLES_SYNONYM;
    public static final int SQLXML = 2009;
    private static final boolean HAVE_DRIVER;
    private static final boolean HAVE_SAVEPOINT;
    private static final boolean HAVE_SQLXML;
    private static final boolean HAVE_AUTO_CLOSEABLE_RESULT_SET;

    static boolean haveClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean vmSupportsJDBC41() {
        return JDBC.vmSupportsJDBC4() && HAVE_AUTO_CLOSEABLE_RESULT_SET;
    }

    public static boolean vmSupportsJDBC4() {
        return HAVE_DRIVER && HAVE_SQLXML;
    }

    public static boolean vmSupportsJDBC3() {
        return HAVE_DRIVER && HAVE_SAVEPOINT;
    }

    public static boolean vmSupportsJSR169() {
        return !HAVE_DRIVER && HAVE_SAVEPOINT;
    }

    public static void cleanup(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        if (conn.isClosed()) {
            return;
        }
        SQLException sqle = null;
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            sqle = e;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            if (sqle == null) {
                sqle = e;
            } else {
                sqle.setNextException(e);
            }
            throw sqle;
        }
    }

    public static void dropSchema(DatabaseMetaData dmd, String schema) throws SQLException {
        Connection conn = dmd.getConnection();
        Assert.assertFalse((boolean)conn.getAutoCommit());
        Statement s = dmd.getConnection().createStatement();
        PreparedStatement psf = conn.prepareStatement("SELECT ALIAS FROM SYS.SYSALIASES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID  AND CHAR(A.ALIASTYPE) = ?  AND S.SCHEMANAME = ?");
        psf.setString(1, "F");
        psf.setString(2, schema);
        ResultSet rs = psf.executeQuery();
        JDBC.dropUsingDMD(s, rs, schema, "ALIAS", "FUNCTION");
        rs = dmd.getProcedures(null, schema, null);
        JDBC.dropUsingDMD(s, rs, schema, "PROCEDURE_NAME", "PROCEDURE");
        rs = dmd.getTables(null, schema, null, GET_TABLES_VIEW);
        JDBC.dropUsingDMD(s, rs, schema, "TABLE_NAME", "VIEW");
        rs = dmd.getTables(null, schema, null, GET_TABLES_TABLE);
        JDBC.dropUsingDMD(s, rs, schema, "TABLE_NAME", "TABLE");
        ResultSet table_rs = dmd.getTables(null, schema, null, GET_TABLES_TABLE);
        while (table_rs.next()) {
            String tablename = table_rs.getString("TABLE_NAME");
            rs = dmd.getExportedKeys(null, schema, tablename);
            while (rs.next()) {
                String fkName;
                short keyPosition = rs.getShort("KEY_SEQ");
                if (keyPosition != 1 || (fkName = rs.getString("FK_NAME")) == null) continue;
                String fkSchema = rs.getString("FKTABLE_SCHEM");
                String fkTable = rs.getString("FKTABLE_NAME");
                String ddl = "ALTER TABLE " + JDBC.escape(fkSchema, fkTable) + " DROP FOREIGN KEY " + JDBC.escape(fkName);
                s.executeUpdate(ddl);
            }
            rs.close();
        }
        table_rs.close();
        conn.commit();
        rs = dmd.getTables(null, schema, null, GET_TABLES_TABLE);
        JDBC.dropUsingDMD(s, rs, schema, "TABLE_NAME", "TABLE");
        psf.setString(1, "A");
        psf.setString(2, schema);
        rs = psf.executeQuery();
        JDBC.dropUsingDMD(s, rs, schema, "ALIAS", "TYPE");
        psf.close();
        rs = dmd.getTables(null, schema, null, GET_TABLES_SYNONYM);
        JDBC.dropUsingDMD(s, rs, schema, "TABLE_NAME", "SYNONYM");
        if (JDBC.sysSequencesExists(conn)) {
            psf = conn.prepareStatement("SELECT SEQUENCENAME FROM SYS.SYSSEQUENCES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID  AND S.SCHEMANAME = ?");
            psf.setString(1, schema);
            rs = psf.executeQuery();
            JDBC.dropUsingDMD(s, rs, schema, "SEQUENCENAME", "SEQUENCE");
            psf.close();
        }
        if (!schema.equals("APP")) {
            s.executeUpdate("DROP SCHEMA " + JDBC.escape(schema) + " RESTRICT");
        }
        conn.commit();
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sysSequencesExists(Connection conn) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement("select count(*) from sys.systables t, sys.sysschemas s\nwhere t.schemaid = s.schemaid\nand ( cast(s.schemaname as varchar(128)))= 'SYS'\nand ( cast(t.tablename as varchar(128))) = 'SYSSEQUENCES'");
            rs = ps.executeQuery();
            rs.next();
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    private static void dropUsingDMD(Statement s, ResultSet rs, String schema, String mdColumn, String dropType) throws SQLException {
        boolean hadError;
        int[] results;
        String dropLeadIn = "DROP " + dropType + " ";
        ArrayList<String> ddl = new ArrayList<String>();
        while (rs.next()) {
            String objectName = rs.getString(mdColumn);
            String raw = dropLeadIn + JDBC.escape(schema, objectName);
            if ("TYPE".equals(dropType) || "SEQUENCE".equals(dropType)) {
                raw = raw + " restrict ";
            }
            ddl.add(raw);
        }
        rs.close();
        if (ddl.isEmpty()) {
            return;
        }
        s.clearBatch();
        int batchCount = 0;
        Iterator i = ddl.iterator();
        while (i.hasNext()) {
            Object sql = i.next();
            if (sql == null) continue;
            s.addBatch(sql.toString());
            ++batchCount;
        }
        try {
            results = s.executeBatch();
            Assert.assertNotNull((Object)results);
            Assert.assertEquals((String)"Incorrect result length from executeBatch", (int)batchCount, (int)results.length);
            hadError = false;
        }
        catch (BatchUpdateException batchException) {
            results = batchException.getUpdateCounts();
            Assert.assertNotNull((Object)results);
            Assert.assertTrue((String)"Too many results in BatchUpdateException", (results.length <= batchCount ? 1 : 0) != 0);
            hadError = true;
        }
        boolean didDrop = false;
        for (int i2 = 0; i2 < results.length; ++i2) {
            int result = results[i2];
            if (result == -3) {
                hadError = true;
                continue;
            }
            if (result == -2 || result >= 0) {
                didDrop = true;
                ddl.set(i2, null);
                continue;
            }
            Assert.fail((String)"Negative executeBatch status");
        }
        s.clearBatch();
        if (didDrop) {
            s.getConnection().commit();
        }
        if (hadError) {
            do {
                hadError = false;
                didDrop = false;
                ListIterator i3 = ddl.listIterator();
                while (i3.hasNext()) {
                    Object sql = i3.next();
                    if (sql == null) continue;
                    try {
                        s.executeUpdate(sql.toString());
                        i3.set(null);
                        didDrop = true;
                    }
                    catch (SQLException e) {
                        hadError = true;
                    }
                }
                if (!didDrop) continue;
                s.getConnection().commit();
            } while (hadError && didDrop);
        }
    }

    public static void assertMetaDataMatch(DatabaseMetaData dmd, ResultSetMetaData rsmd) throws SQLException {
        for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
            ResultSet column = dmd.getColumns(rsmd.getCatalogName(col), rsmd.getSchemaName(col), rsmd.getTableName(col), rsmd.getColumnName(col));
            Assert.assertTrue((String)("Column missing " + rsmd.getColumnName(col)), (boolean)column.next());
            Assert.assertEquals((int)column.getInt("DATA_TYPE"), (int)rsmd.getColumnType(col));
            Assert.assertEquals((int)column.getInt("NULLABLE"), (int)rsmd.isNullable(col));
            Assert.assertEquals((String)column.getString("TYPE_NAME"), (String)rsmd.getColumnTypeName(col));
            column.close();
        }
    }

    public static void assertEmpty(ResultSet rs) throws SQLException {
        JDBC.assertDrainResults(rs, 0);
    }

    public static void assertClosed(ResultSet rs) {
        try {
            rs.next();
            Assert.fail((String)"ResultSet not closed");
        }
        catch (SQLException sqle) {
            Assert.assertEquals((String)"XCL16", (String)sqle.getSQLState());
        }
    }

    public static void assertNoWarnings(SQLWarning warning) {
        if (warning == null) {
            return;
        }
        Assert.fail((String)("Expected no SQLWarnings - got: " + warning.getSQLState() + " " + warning.getMessage()));
    }

    public static void assertNoMoreResults(Statement s) throws SQLException {
        Assert.assertFalse((boolean)s.getMoreResults());
        Assert.assertTrue((s.getUpdateCount() == -1 ? 1 : 0) != 0);
        Assert.assertNull((Object)s.getResultSet());
    }

    public static void assertGeneratedKeyResultSet(String description, ResultSet keys) throws SQLException {
        Assert.assertNotNull((String)description, (Object)keys);
        Assert.assertEquals((String)(description + " - Required CONCUR_READ_ONLY for generated key result sets"), (int)1007, (int)keys.getConcurrency());
        int type = keys.getType();
        if (type != 1003 && type != 1004) {
            Assert.fail((String)(description + " - Invalid type for generated key result set" + type));
        }
    }

    public static void assertDrainResultsHasData(ResultSet rs) throws SQLException {
        int rowCount = JDBC.assertDrainResults(rs, -1);
        Assert.assertTrue((String)"ResultSet expected to have data", (rowCount > 0 ? 1 : 0) != 0);
    }

    public static int assertDrainResults(ResultSet rs) throws SQLException {
        return JDBC.assertDrainResults(rs, -1);
    }

    public static int assertDrainResults(ResultSet rs, int expectedRows) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int rows = 0;
        while (rs.next()) {
            for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                String s = rs.getString(col);
                Assert.assertEquals((s == null ? 1 : 0) != 0, (boolean)rs.wasNull());
                if (!rs.wasNull()) continue;
                JDBC.assertResultColumnNullable(rsmd, col);
            }
            ++rows;
        }
        rs.close();
        if (expectedRows >= 0) {
            Assert.assertEquals((String)"Unexpected row count:", (int)expectedRows, (int)rows);
        }
        return rows;
    }

    private static void assertResultColumnNullable(ResultSetMetaData rsmd, int col) throws SQLException {
        Assert.assertFalse((rsmd.isNullable(col) == 0 ? 1 : 0) != 0);
    }

    public static void assertColumnNames(ResultSet rs, String[] expectedColNames) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int actualCols = rsmd.getColumnCount();
        Assert.assertEquals((String)"Unexpected column count:", (int)expectedColNames.length, (int)rsmd.getColumnCount());
        for (int i = 0; i < actualCols; ++i) {
            Assert.assertEquals((String)"Column names do not match:", (String)expectedColNames[i], (String)rsmd.getColumnName(i + 1));
        }
    }

    public static void assertColumnTypes(ResultSet rs, int[] expectedTypes) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int actualCols = rsmd.getColumnCount();
        Assert.assertEquals((String)"Unexpected column count:", (int)expectedTypes.length, (int)rsmd.getColumnCount());
        for (int i = 0; i < actualCols; ++i) {
            Assert.assertEquals((String)("Column types do not match for column " + (i + 1)), (int)expectedTypes[i], (int)rsmd.getColumnType(i + 1));
        }
    }

    public static void assertParameterTypes(PreparedStatement ps, int[] expectedTypes) throws SQLException {
        ParameterMetaData pmd = ps.getParameterMetaData();
        int actualParams = pmd.getParameterCount();
        Assert.assertEquals((String)"Unexpected parameter count:", (int)expectedTypes.length, (int)pmd.getParameterCount());
        for (int i = 0; i < actualParams; ++i) {
            Assert.assertEquals((String)("Types do not match for parameter " + (i + 1)), (int)expectedTypes[i], (int)pmd.getParameterType(i + 1));
        }
    }

    public static void assertNullability(ResultSet rs, boolean[] nullability) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int actualCols = rsmd.getColumnCount();
        Assert.assertEquals((String)"Unexpected column count:", (int)nullability.length, (int)rsmd.getColumnCount());
        for (int i = 0; i < actualCols; ++i) {
            int expected = nullability[i] ? 1 : 0;
            Assert.assertEquals((String)("Column nullability do not match for column " + (i + 1)), (int)expected, (int)rsmd.isNullable(i + 1));
        }
    }

    public static void assertSingleValueResultSet(ResultSet rs, String value) throws SQLException {
        String[] row = new String[]{value};
        String[][] set = new String[][]{row};
        JDBC.assertFullResultSet(rs, set);
    }

    public static void assertFullResultSet(ResultSet rs, String[][] expectedRows) throws SQLException {
        JDBC.assertFullResultSet(rs, (Object[][])expectedRows, true);
    }

    public static void assertFullResultSet(ResultSet rs, Object[][] expectedRows, boolean allAsTrimmedStrings) throws SQLException {
        JDBC.assertFullResultSet(rs, expectedRows, allAsTrimmedStrings, true);
    }

    public static void assertFullResultSet(ResultSet rs, Object[][] expectedRows, boolean allAsTrimmedStrings, boolean closeResultSet) throws SQLException {
        JDBC.assertFullResultSetMinion(rs, expectedRows, allAsTrimmedStrings, closeResultSet, null);
    }

    public static void assertFullResultSet(ResultSet rs, Object[][] expectedRows, String[] warnings) throws SQLException {
        JDBC.assertFullResultSetMinion(rs, expectedRows, true, true, warnings);
    }

    private static void assertFullResultSetMinion(ResultSet rs, Object[][] expectedRows, boolean allAsTrimmedStrings, boolean closeResultSet, String[] warnings) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        if (expectedRows.length > 0) {
            Assert.assertEquals((String)"Unexpected column count:", (int)expectedRows[0].length, (int)rsmd.getColumnCount());
        }
        int rows = 0;
        while (rs.next()) {
            if (TestConfiguration.getCurrent().getJDBCClient().isEmbedded() && warnings != null) {
                SQLWarning w = rs.getWarnings();
                String wstr = null;
                if (w != null) {
                    wstr = w.getSQLState();
                }
                Assert.assertEquals((String)("Warning assertion error on row " + (rows + 1)), (String)warnings[rows], (String)wstr);
            }
            if (rows < expectedRows.length) {
                JDBC.assertRowInResultSet(rs, rows + 1, expectedRows[rows], allAsTrimmedStrings);
            }
            ++rows;
        }
        if (closeResultSet) {
            rs.close();
        }
        Assert.assertEquals((String)"Unexpected row count:", (int)expectedRows.length, (int)rows);
    }

    public static void assertPartialResultSet(ResultSet rs, Object[][] expectedRows, BitSet colsToCheck) throws SQLException {
        if (expectedRows.length > 0) {
            Assert.assertEquals((String)"Unexpected column count:", (int)expectedRows[0].length, (int)colsToCheck.cardinality());
        }
        int rows = 0;
        while (rs.next()) {
            if (rows < expectedRows.length) {
                JDBC.assertRowInResultSet(rs, rows + 1, expectedRows[rows], true, colsToCheck);
            }
            ++rows;
        }
        rs.close();
        Assert.assertEquals((String)"Unexpected row count:", (int)expectedRows.length, (int)rows);
    }

    private static void assertRowInResultSet(ResultSet rs, int rowNum, Object[] expectedRow, boolean asTrimmedStrings) throws SQLException {
        JDBC.assertRowInResultSet(rs, rowNum, expectedRow, asTrimmedStrings, null);
    }

    private static void assertRowInResultSet(ResultSet rs, int rowNum, Object[] expectedRow, boolean asTrimmedStrings, BitSet colsToCheck) throws SQLException {
        int cPos = 0;
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 0; i < expectedRow.length; ++i) {
            boolean ok;
            Object obj;
            int n = cPos = colsToCheck == null ? i + 1 : colsToCheck.nextSetBit(cPos) + 1;
            if (asTrimmedStrings) {
                String s;
                if (expectedRow[i] != null) {
                    expectedRow[i] = ((String)expectedRow[i]).trim();
                }
                obj = expectedRow[i] != null && rsmd.getColumnType(cPos) == 5 ? ((s = expectedRow[i].toString()).equals("true") || s.equals("false") ? (rs.getShort(cPos) == 0 ? "false" : "true") : rs.getString(cPos)) : rs.getString(cPos);
                if (obj != null) {
                    obj = ((String)obj).trim();
                }
            } else {
                obj = rs.getObject(cPos);
            }
            boolean bl = ok = rs.wasNull() && expectedRow[i] == null || !rs.wasNull() && expectedRow[i] != null && (expectedRow[i].equals(obj) || obj instanceof byte[] && Arrays.equals((byte[])obj, (byte[])expectedRow[i]));
            if (!ok) {
                Object expected = expectedRow[i];
                Object found = obj;
                if (obj instanceof byte[]) {
                    expected = JDBC.bytesToString((byte[])expectedRow[i]);
                    found = JDBC.bytesToString((byte[])obj);
                }
                Assert.fail((String)("Column value mismatch @ column '" + rsmd.getColumnName(cPos) + "', row " + rowNum + ":\n    Expected: >" + expected + "<\n    Found:    >" + found + "<"));
            }
            if (!rs.wasNull()) continue;
            JDBC.assertResultColumnNullable(rsmd, cPos);
        }
    }

    public static void assertSameContents(ResultSet rs1, ResultSet rs2) throws SQLException, IOException {
        ResultSetMetaData rsmd = rs1.getMetaData();
        int columnCount = rsmd.getColumnCount();
        while (rs1.next()) {
            Assert.assertTrue((boolean)rs2.next());
            for (int col = 1; col <= columnCount; ++col) {
                switch (rsmd.getColumnType(col)) {
                    case 4: 
                    case 5: {
                        Assert.assertEquals((int)rs1.getInt(col), (int)rs2.getInt(col));
                        break;
                    }
                    case -5: {
                        Assert.assertEquals((long)rs1.getLong(col), (long)rs2.getLong(col));
                        break;
                    }
                    case 2004: {
                        BaseJDBCTestCase.assertEquals(rs1.getBlob(col), rs2.getBlob(col));
                        break;
                    }
                    case 2005: {
                        BaseJDBCTestCase.assertEquals(rs1.getClob(col), rs2.getClob(col));
                        break;
                    }
                    default: {
                        Assert.assertEquals((String)rs1.getString(col), (String)rs2.getString(col));
                    }
                }
                Assert.assertEquals((boolean)rs1.wasNull(), (boolean)rs2.wasNull());
            }
        }
        Assert.assertFalse((boolean)rs2.next());
        rs1.close();
        rs2.close();
    }

    public static void assertUnorderedResultSet(ResultSet rs, String[][] expectedRows) throws SQLException {
        JDBC.assertUnorderedResultSet(rs, expectedRows, true);
    }

    public static void assertUnorderedResultSet(ResultSet rs, Object[][] expectedRows, boolean asTrimmedStrings) throws SQLException {
        ArrayList<Object> row;
        if (expectedRows.length == 0) {
            JDBC.assertEmpty(rs);
            return;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        Assert.assertEquals((String)"Unexpected column count", (int)expectedRows[0].length, (int)rsmd.getColumnCount());
        ArrayList<List<Object>> expected = new ArrayList<List<Object>>(expectedRows.length);
        for (int i = 0; i < expectedRows.length; ++i) {
            Assert.assertEquals((String)"Different column count in expectedRows", (int)expectedRows[0].length, (int)expectedRows[i].length);
            if (asTrimmedStrings) {
                row = new ArrayList(expectedRows[i].length);
                for (int j = 0; j < expectedRows[i].length; ++j) {
                    String val = (String)expectedRows[i][j];
                    row.add(val == null ? null : val.trim());
                }
                expected.add(row);
                continue;
            }
            expected.add(Arrays.asList(expectedRows[i]));
        }
        ArrayList actual = new ArrayList(expectedRows.length);
        while (rs.next()) {
            row = new ArrayList<Object>(expectedRows[0].length);
            for (int i = 1; i <= expectedRows[0].length; ++i) {
                if (asTrimmedStrings) {
                    String s = rs.getString(i);
                    row.add(s == null ? null : s.trim());
                } else {
                    row.add(rs.getObject(i));
                }
                if (!rs.wasNull()) continue;
                JDBC.assertResultColumnNullable(rsmd, i);
            }
            actual.add(row);
        }
        rs.close();
        Assert.assertEquals((String)"Unexpected row count", (int)expectedRows.length, (int)actual.size());
        Assert.assertTrue((String)"Missing rows in ResultSet", (boolean)actual.containsAll(expected));
        actual.removeAll(expected);
        Assert.assertTrue((String)"Extra rows in ResultSet", (boolean)actual.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertCurrentSchema(Connection con, String schema) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            JDBC.assertSingleValueResultSet(stmt.executeQuery("VALUES CURRENT SCHEMA"), schema);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertCurrentUser(Connection con, String user) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            JDBC.assertSingleValueResultSet(stmt.executeQuery("VALUES CURRENT_USER"), user);
        }
        finally {
            stmt.close();
        }
    }

    private static String bytesToString(byte[] ba) {
        if (ba == null) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < ba.length; ++i) {
            s.append(Integer.toHexString(ba[i] & 0xFF));
        }
        return s.toString();
    }

    public static String escape(String name) {
        StringBuffer buffer = new StringBuffer(name.length() + 2);
        buffer.append('\"');
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\"') {
                buffer.append('\"');
            }
            buffer.append(c);
        }
        buffer.append('\"');
        return buffer.toString();
    }

    private static String compressQuotes(String source, String quotes) {
        String result = source;
        int index = result.indexOf(quotes);
        while (index != -1) {
            result = result.substring(0, index + 1) + result.substring(index + 2);
            index = result.indexOf(quotes, index + 1);
        }
        return result;
    }

    public static String identifierToCNF(String id) {
        if (id == null || id.length() == 0) {
            return id;
        }
        if (id.charAt(0) == '\"' && id.length() >= 3 && id.charAt(id.length() - 1) == '\"') {
            return JDBC.compressQuotes(id.substring(1, id.length() - 1), "\"\"");
        }
        return id.toUpperCase(Locale.ENGLISH);
    }

    public static String escape(String schema, String name) {
        return JDBC.escape(schema) + "." + JDBC.escape(name);
    }

    public static String sqlNameFromJdbc(int jdbcType) {
        switch (jdbcType) {
            case -7: {
                return "Types.BIT";
            }
            case 16: {
                return "Types.BOOLEAN";
            }
            case -6: {
                return "Types.TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "Types.NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONG VARCHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "CHAR () FOR BIT DATA";
            }
            case -3: {
                return "VARCHAR () FOR BIT DATA";
            }
            case -4: {
                return "LONG VARCHAR FOR BIT DATA";
            }
            case 2004: {
                return "BLOB";
            }
            case 1111: {
                return "Types.OTHER";
            }
            case 0: {
                return "Types.NULL";
            }
        }
        return String.valueOf(jdbcType);
    }

    public static void checkPlan(Statement s, String[] sequence) throws SQLException {
        ResultSet rs = s.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        rs.next();
        String rts = rs.getString(1);
        rs.close();
        RuntimeStatisticsParser rtsp = new RuntimeStatisticsParser(rts);
        rtsp.assertSequence(sequence);
    }

    static {
        boolean autoCloseable;
        GET_TABLES_TABLE = new String[]{"TABLE"};
        GET_TABLES_VIEW = new String[]{"VIEW"};
        GET_TABLES_SYNONYM = new String[]{"SYNONYM"};
        HAVE_DRIVER = JDBC.haveClass("java.sql.Driver");
        HAVE_SAVEPOINT = JDBC.haveClass("java.sql.Savepoint");
        HAVE_SQLXML = JDBC.haveClass("java.sql.SQLXML");
        try {
            Class<?> acClass = Class.forName("java.lang.AutoCloseable");
            autoCloseable = acClass.isAssignableFrom(ResultSet.class);
        }
        catch (Throwable t) {
            autoCloseable = false;
        }
        HAVE_AUTO_CLOSEABLE_RESULT_SET = autoCloseable;
    }

    public static class GeneratedId {
        public boolean equals(Object o) {
            if (JDBC.vmSupportsJDBC3()) {
                return o instanceof String && ((String)o).matches("SQL[0-9]{15}");
            }
            String tmpstr = (String)o;
            boolean b = true;
            if (!(o instanceof String)) {
                b = false;
            }
            if (!tmpstr.startsWith("SQL")) {
                b = false;
            }
            if (tmpstr.length() != 18) {
                b = false;
            }
            for (int i = 3; i < 18; ++i) {
                if (Character.isDigit(tmpstr.charAt(i))) continue;
                b = false;
                break;
            }
            return b;
        }

        public String toString() {
            return "xxxxGENERATED-IDxxxx";
        }
    }
}

