/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SystemPropertyTestSetup
extends TestSetup {
    protected Properties newValues;
    private Properties oldValues;
    private boolean staticProperties;

    public SystemPropertyTestSetup(Test test, Properties newValues, boolean staticProperties) {
        super(test);
        this.newValues = newValues;
        this.oldValues = new Properties();
        this.staticProperties = staticProperties;
    }

    public SystemPropertyTestSetup(Test test, Properties newValues) {
        super(test);
        this.newValues = newValues;
        this.oldValues = new Properties();
        this.staticProperties = false;
    }

    protected void setUp() throws Exception {
        this.setProperties(this.newValues);
        if (this.staticProperties) {
            TestConfiguration.getCurrent().shutdownEngine();
        }
    }

    protected void tearDown() throws Exception {
        Enumeration<?> e = this.newValues.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (this.oldValues.getProperty(key) != null) continue;
            BaseTestCase.removeSystemProperty(key);
        }
        this.setProperties(this.oldValues);
        if (this.staticProperties) {
            TestConfiguration.getCurrent().shutdownEngine();
        }
        this.newValues = null;
        this.oldValues = null;
    }

    private void setProperties(Properties values) throws PrivilegedActionException {
        Enumeration<?> e = values.propertyNames();
        while (e.hasMoreElements()) {
            boolean change;
            String key = (String)e.nextElement();
            String value = values.getProperty(key);
            String old = BaseTestCase.getSystemProperty(key);
            if (old != null) {
                boolean bl = change = !old.equals(value);
                if (change && values != this.oldValues) {
                    this.oldValues.setProperty(key, old);
                }
            } else {
                change = true;
            }
            if (!change) continue;
            BaseTestCase.setSystemProperty(key, value);
        }
    }
}

