/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JAXPFinder;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class XML {
    private static final boolean HAVE_JAXP = JDBC.haveClass("org.w3c.dom.Document");
    private static final boolean HAVE_JAXP_IMPL = HAVE_JAXP && XML.checkJAXPImplementation();
    private static final boolean HAVE_XPATH_LEVEL_3 = HAVE_JAXP_IMPL && XML.checkXPathSupport();
    private static final String HELPER_FILE_LOCATION = "org/apache/derbyTesting/functionTests/tests/lang/xmlTestFiles/";

    public static boolean classpathHasJAXP() {
        return HAVE_JAXP_IMPL;
    }

    public static boolean classpathMeetsXMLReqs() {
        return HAVE_XPATH_LEVEL_3;
    }

    public static void insertFile(Connection conn, String tableName, String colName, String fName, int numRows) throws IOException, SQLException, PrivilegedActionException {
        fName = HELPER_FILE_LOCATION + fName;
        URL xFile = BaseTestCase.getTestResource(fName);
        Assert.assertNotNull((String)("XML input file missing: " + fName), (Object)xFile);
        int charCount = 0;
        char[] cA = new char[1024];
        InputStreamReader reader = new InputStreamReader(BaseTestCase.openTestResource(xFile));
        int len = reader.read(cA, 0, cA.length);
        while (len != -1) {
            charCount += len;
            len = reader.read(cA, 0, cA.length);
        }
        reader.close();
        PreparedStatement pSt = conn.prepareStatement("insert into " + tableName + "(" + colName + ") values " + "(xmlparse(document cast (? as clob) preserve whitespace))");
        for (int i = 0; i < numRows; ++i) {
            reader = new InputStreamReader(BaseTestCase.openTestResource(xFile));
            pSt.setCharacterStream(1, (Reader)reader, charCount);
            pSt.execute();
            reader.close();
        }
        pSt.close();
    }

    public static void insertDocWithDTD(Connection conn, String tableName, String colName, String fName, String dtdName, int numRows) throws IOException, SQLException, PrivilegedActionException {
        fName = HELPER_FILE_LOCATION + fName;
        URL xFile = BaseTestCase.getTestResource(fName);
        Assert.assertNotNull((String)("XML input file missing: " + fName), (Object)xFile);
        int charCount = 0;
        char[] cA = new char[1024];
        StringBuffer sBuf = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(BaseTestCase.openTestResource(xFile));
        int len = reader.read(cA, 0, cA.length);
        while (len != -1) {
            sBuf.append(cA, 0, len);
            charCount += len;
            len = reader.read(cA, 0, cA.length);
        }
        reader.close();
        URL dtdURL = SupportFilesSetup.getReadOnlyURL(dtdName);
        Assert.assertNotNull((String)("DTD file missing: " + dtdName), (Object)dtdURL);
        String docAsString = sBuf.toString();
        int pos = docAsString.indexOf(dtdName);
        if (pos != -1) {
            sBuf.replace(pos, pos + dtdName.length(), dtdURL.toExternalForm());
        }
        docAsString = sBuf.toString();
        PreparedStatement pSt = conn.prepareStatement("insert into " + tableName + "(" + colName + ") values " + "(xmlparse(document cast (? as clob) preserve whitespace))");
        for (int i = 0; i < numRows; ++i) {
            pSt.setString(1, docAsString);
            pSt.execute();
        }
        pSt.close();
    }

    private static boolean checkXPathSupport() {
        boolean supportsXPath;
        try {
            Class<?> factoryClass = Class.forName("javax.xml.parsers.DocumentBuilderFactory");
            Method newFactory = factoryClass.getMethod("newInstance", new Class[0]);
            Object factory = newFactory.invoke(null, new Object[0]);
            Method newBuilder = factoryClass.getMethod("newDocumentBuilder", new Class[0]);
            Object builder = newBuilder.invoke(factory, new Object[0]);
            Class<?> builderClass = Class.forName("javax.xml.parsers.DocumentBuilder");
            Method getImpl = builderClass.getMethod("getDOMImplementation", new Class[0]);
            Object impl = getImpl.invoke(builder, new Object[0]);
            Class<?> domImplClass = Class.forName("org.w3c.dom.DOMImplementation");
            Method getFeature = domImplClass.getMethod("getFeature", String.class, String.class);
            Object ret = getFeature.invoke(impl, "+XPath", "3.0");
            supportsXPath = ret != null;
        }
        catch (Throwable t) {
            supportsXPath = false;
        }
        return supportsXPath;
    }

    private static boolean checkJAXPImplementation() {
        try {
            Class<?> factoryClass = Class.forName("javax.xml.parsers.DocumentBuilderFactory");
            Method newFactory = factoryClass.getMethod("newInstance", new Class[0]);
            Object factory = newFactory.invoke(null, new Object[0]);
            return factory != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static String getJAXPParserLocation() {
        if (!XML.classpathHasJAXP()) {
            return null;
        }
        return JAXPFinder.getJAXPParserLocation();
    }
}

