/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.client;

import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derbyTesting.system.oe.client.Display;
import org.apache.derbyTesting.system.oe.client.Operations;
import org.apache.derbyTesting.system.oe.util.OERandom;

public class Submitter {
    public static final int STOCK_LEVEL = 0;
    public static final int ORDER_STATUS_BY_NAME = 1;
    public static final int ORDER_STATUS_BY_ID = 2;
    public static final int PAYMENT_BY_NAME = 3;
    public static final int PAYMENT_BY_ID = 4;
    public static final int DELIVERY_SCHEDULE = 5;
    public static final int NEW_ORDER = 6;
    public static final int NEW_ORDER_ROLLBACK = 7;
    private final Display display;
    private final Operations ops;
    private final OERandom rand;
    private final short maxW;
    private final int[] transactionCount;

    public static OERandom getRuntimeRandom(Connection conn) throws SQLException {
        int c;
        int delta;
        OERandom rand = new OERandom(-1);
        ResultSet rs = conn.createStatement().executeQuery("SELECT CLOAD FROM C");
        rs.next();
        int cload = rs.getInt(1);
        rs.close();
        while ((delta = Math.abs(cload - (c = rand.randomInt(0, 255)))) == 96 || delta == 112 || delta < 65 || delta > 119) {
        }
        rand = new OERandom(c);
        return rand;
    }

    public static Submitter stockLevelOnly(Display display, Operations ops, OERandom rand, short maxW) {
        return new Submitter(display, ops, rand, maxW){

            protected int mixType(int chooseType) {
                return 0;
            }
        };
    }

    public static Submitter orderStatusByIdOnly(Display display, Operations ops, OERandom rand, short maxW) {
        return new Submitter(display, ops, rand, maxW){

            protected int mixType(int chooseType) {
                return 2;
            }
        };
    }

    public static Submitter orderStatusByNameOnly(Display display, Operations ops, OERandom rand, short maxW) {
        return new Submitter(display, ops, rand, maxW){

            protected int mixType(int chooseType) {
                return 1;
            }
        };
    }

    public static Submitter paymentByIdOnly(Display display, Operations ops, OERandom rand, short maxW) {
        return new Submitter(display, ops, rand, maxW){

            protected int mixType(int chooseType) {
                return 4;
            }
        };
    }

    public static Submitter paymentByNameOnly(Display display, Operations ops, OERandom rand, short maxW) {
        return new Submitter(display, ops, rand, maxW){

            protected int mixType(int chooseType) {
                return 3;
            }
        };
    }

    public static Submitter newOrderOnly(Display display, Operations ops, OERandom rand, short maxW) {
        return new Submitter(display, ops, rand, maxW){

            protected int mixType(int chooseType) {
                return 6;
            }
        };
    }

    public Submitter(Display display, Operations ops, OERandom rand, short maxW) {
        this.display = display;
        this.ops = ops;
        this.rand = rand;
        this.maxW = maxW;
        this.transactionCount = new int[8];
    }

    public void clearTransactionCount() {
        Arrays.fill(this.transactionCount, 0);
    }

    public long runTransactions(Object displayData, int count) throws Exception {
        long startms = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            this.runTransaction(displayData);
        }
        long endms = System.currentTimeMillis();
        return endms - startms;
    }

    public void runTransaction(Object displayData) throws Exception {
        int chooseType = this.rand.randomInt(1, 100);
        int type = this.mixType(chooseType);
        switch (type) {
            case 5: {
                this.runScheduleDelivery(displayData);
                break;
            }
            case 6: {
                this.runNewOrder(displayData, false);
                break;
            }
            case 7: {
                this.runNewOrder(displayData, true);
                break;
            }
            case 2: {
                this.runOrderStatus(displayData, false);
                break;
            }
            case 1: {
                this.runOrderStatus(displayData, true);
                break;
            }
            case 4: {
                this.runPayment(displayData, false);
                break;
            }
            case 3: {
                this.runPayment(displayData, true);
                break;
            }
            case 0: {
                this.runStockLevel(displayData);
            }
        }
        int n = type;
        this.transactionCount[n] = this.transactionCount[n] + 1;
    }

    protected int mixType(int chooseType) {
        if (chooseType <= 43) {
            boolean byName = this.rand.randomInt(1, 100) <= 60;
            return byName ? 3 : 4;
        }
        if (chooseType <= 47) {
            boolean byName = this.rand.randomInt(1, 100) <= 60;
            return byName ? 1 : 2;
        }
        if (chooseType <= 51) {
            return 5;
        }
        if (chooseType <= 55) {
            return 0;
        }
        boolean rollback = this.rand.randomInt(1, 100) == 1;
        return rollback ? 7 : 6;
    }

    protected void runNewOrder(Object displayData, boolean forRollback) throws Exception {
        short homeWarehouse = this.warehouse();
        int orderItemCount = this.rand.randomInt(5, 15);
        int[] items = new int[orderItemCount];
        short[] quantities = new short[orderItemCount];
        short[] supplyW = new short[orderItemCount];
        for (int i = 0; i < orderItemCount; ++i) {
            items[i] = this.rand.NURand8191();
            if (this.maxW == 1 || this.rand.randomInt(1, 100) > 1) {
                supplyW[i] = homeWarehouse;
            } else {
                short sw = this.warehouse();
                while (sw == homeWarehouse) {
                    sw = this.warehouse();
                }
                supplyW[i] = sw;
            }
            supplyW[i] = this.rand.randomInt(1, 100) > 1 ? homeWarehouse : this.warehouse();
            quantities[i] = (short)this.rand.randomInt(1, 10);
        }
        if (forRollback) {
            items[orderItemCount - 1] = 2334432;
        }
        this.ops.newOrder(this.display, displayData, homeWarehouse, this.rand.district(), this.rand.NURand1023(), items, quantities, supplyW);
    }

    protected void runScheduleDelivery(Object displayData) {
    }

    protected void runPayment(Object displayData, boolean byName) throws Exception {
        if (byName) {
            this.ops.payment(this.display, displayData, this.warehouse(), this.rand.district(), this.warehouse(), this.rand.district(), this.rand.randomCLast(), this.rand.payment().toString());
        } else {
            this.ops.payment(this.display, displayData, this.warehouse(), this.rand.district(), this.warehouse(), this.rand.district(), this.rand.NURand1023(), this.rand.payment().toString());
        }
    }

    private final short warehouse() {
        if (this.maxW == 1) {
            return 1;
        }
        return (short)this.rand.randomInt(1, this.maxW);
    }

    protected void runStockLevel(Object displayData) throws Exception {
        this.ops.stockLevel(this.display, displayData, this.warehouse(), this.rand.district(), this.rand.threshold());
    }

    protected void runOrderStatus(Object displayData, boolean byName) throws Exception {
        if (byName) {
            this.ops.orderStatus(this.display, displayData, this.warehouse(), this.rand.district(), this.rand.randomCLast());
        } else {
            this.ops.orderStatus(this.display, displayData, this.warehouse(), this.rand.district(), this.rand.NURand1023());
        }
    }

    public void printReport(PrintStream out) {
        int total = 0;
        for (int i = 0; i < this.transactionCount.length; ++i) {
            total += this.transactionCount[i];
        }
        out.println("Total Transactions: " + total);
        int noTotal = this.transactionCount[6] + this.transactionCount[7];
        int pyCount = this.transactionCount[3] + this.transactionCount[4];
        int osCount = this.transactionCount[1] + this.transactionCount[2];
        if (noTotal != 0) {
            out.println(this.transactionCount("New Order         ", noTotal, total));
        }
        if (pyCount != 0) {
            out.println(this.transactionCount("Payment           ", pyCount, total));
            out.println(this.transactionCount("    By Name       ", this.transactionCount[3], total));
            out.println(this.transactionCount("    By Identifier ", this.transactionCount[4], total));
        }
        if (osCount != 0) {
            out.println(this.transactionCount("Order Status      ", osCount, total));
            out.println(this.transactionCount("    By Name       ", this.transactionCount[1], total));
            out.println(this.transactionCount("    By Identifier ", this.transactionCount[2], total));
        }
        if (this.transactionCount[0] != 0) {
            out.println(this.transactionCount("Stock Level       ", this.transactionCount[0], total));
        }
        if (this.transactionCount[5] != 0) {
            out.println(this.transactionCount("Schedule Delivery ", this.transactionCount[5], total));
        }
    }

    private String transactionCount(String name, int count, int total) {
        return name + " : " + this.percent(count, total) + "(" + count + ")";
    }

    private String percent(int count, int total) {
        BigDecimal c = BigDecimal.valueOf((long)count * 100L);
        BigDecimal t = BigDecimal.valueOf(total);
        BigDecimal p = c.divide(t, 2, 1);
        return p.toString().concat("%");
    }

    public int[] getTransactionCount() {
        return this.transactionCount;
    }
}

