/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.sqlService.parse.SqlExecuteSentencies.SqlExecuteSentence;

/**
 * @author sima
 * 
 */
public class ResultsTableModel extends AbstractTableModel implements SqlExecutedListener, TableModelListener {

	private static final long serialVersionUID = -4605343361563115844L;

	private final List<ColumnAttributeResult> headerList = Collections.synchronizedList(new ArrayList<ColumnAttributeResult>());
	private final List<List<Result>> detailList = Collections.synchronizedList(new ArrayList<List<Result>>());

	volatile private boolean tableEditable = false;

	public ResultsTableModel() {
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @seejdbcacsess2.sqlService.SqlExecutedListener#executAccept(jdbcacsess2.
	 * sqlService.SqlExecuteTask)
	 */
	@Override
	public void taskAccept(SqlExecuteTask sqlExecuteTask) {
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see
	 * jdbcacsess2.sqlService.SqlExecutedListener#executBegin(jdbcacsess2.sqlService
	 * .SqlExecuteTask,
	 * jdbcacsess2.sqlService.SqlExecuteSentencies.SqlExecuteSentence)
	 */
	@Override
	public void executBegin(SqlExecuteSentence sqlExecuteSentence) {
		tableEditable = sqlExecuteSentence.isEditable();
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see jdbcacsess.sql2.SqlExecutedListener#executNormalFinish(int)
	 */
	@Override
	public void executNormalFinish(int count) {
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see
	 * jdbcacsess.sql2.SqlExecutedListener#executeException(java.lang.Throwable)
	 */
	@Override
	public void executeException(Throwable t) {
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see jdbcacsess.sql2.SqlExecutedListener#resultHeader(List)
	 */
	@Override
	public void resultHeader(final List<ColumnAttributeResult> header) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				headerList.clear();
				detailList.clear();
				headerList.addAll(header);
				fireTableStructureChanged();
			}
		});
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see jdbcacsess.sql2.SqlExecutedListener#result(int, java.util.ArrayList)
	 */
	@Override
	public void resultDetail(final int seq, final List<Result> results) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				detailList.add(results);
				fireTableRowsInserted(seq - 1, seq - 1);
			}
		});
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see jdbcacsess.sql2.SqlExecutedListener#statusContinue(int)
	 */
	@Override
	public void statusContinue(int seqNo) {
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see jdbcacsess2.sqlService.SqlExecutedListener#executeAllEnd()
	 */
	@Override
	public void executeAllEnd() {
	}
	/*
	 * (非 Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getColumnCount()
	 */
	@Override
	public int getColumnCount() {
		return headerList.size();
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	@Override
	public int getRowCount() {
		return detailList.size();
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see javax.swing.table.TableModel#getValueAt(int, int)
	 */
	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		return detailList.get(rowIndex).get(columnIndex);
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see javax.swing.table.AbstractTableModel#getColumnName(int)
	 */
	@Override
	public String getColumnName(int column) {
		return headerList.get(column).getColumnName();
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see javax.swing.table.AbstractTableModel#getColumnClass(int)
	 */
	@Override
	public Class<?> getColumnClass(int columnIndex) {
		return headerList.get(columnIndex).getColumnClass();
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see javax.swing.table.AbstractTableModel#isCellEditable(int, int)
	 */
	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return tableEditable;
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see javax.swing.table.AbstractTableModel#setValueAt(java.lang.Object,
	 * int, int)
	 */
	@Override
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
		// TODO UPDATEを実装する
		Jdbcacsess2.logger.info("setValueAt:row=" + rowIndex + ",col=" + columnIndex + ",val=" + aValue);
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see javax.swing.event.TableModelListener#tableChanged(javax.swing.event.
	 * TableModelEvent)
	 */
	@Override
	public void tableChanged(TableModelEvent e) {
		// TODO INSERTとDELETEを実装する
		if (e.getType() == TableModelEvent.DELETE) {
			Jdbcacsess2.logger.info("tableChanged(DELETE):row=" + e.getFirstRow() + "," + e.getLastRow());
		}
	}

}
