/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService.history;

import java.sql.Types;
import java.util.Date;

import net.java.ao.Entity;
import net.java.ao.Preload;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.SQLType;

@Preload
public interface ExecHistory extends Entity {

	enum ResultStatus {
		ACCEPT, EXECUTING, NORMALEND, ABNORMALEND,
	};

	@NotNull
	String getConnectName();

	void setConnectName(String connectName);

	@NotNull
	Date getStartDate();

	void setStartDate(Date startDate);

	@NotNull
	String getUrl();

	void setUrl(String url);

	String getConnectUser();

	void setConnectUser(String connectUser);

	Date getEndDate();

	void setEndDate(Date endDate);

	String getSqlCommand();

	void setSqlCommand(String sqlCommand);

	@SQLType(value = Types.CLOB)
	String getSqlText();

	void setSqlText(String sqlText);

	Integer getResultCnt();

	void setResultCnt(Integer resultCnt);

	ResultStatus getResultStatus();

	void setResultStatus(ResultStatus resultStatus);

	public static String CONNECTNAME = "connectname";
	public static String STARTDATE = "startdate";
	public static String ENDDATE = "enddate";
	public static String URL = "url";
	public static String CONNECTUSER = "connectuser";
	public static String SQLCOMMAND = "sqlcommand";
	public static String SQLTEXT = "sqltext";
	public static String RESULTCNT = "resultcnt";
	public static String RESULTSTATUS = "resultstatus";

}
