package com.kekenzy.test;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class IntentTestProjectActivity extends Activity implements OnClickListener{
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        Button bWeb = (Button)findViewById(R.id.bWeb);
        bWeb.setOnClickListener(this);

        Button bCall = (Button)findViewById(R.id.bCall);
        bCall.setOnClickListener(this);

        Button bCamera = (Button)findViewById(R.id.bCamera);
        bCamera.setOnClickListener(this);

        Button bActivity = (Button)findViewById(R.id.bActivity);
        bActivity.setOnClickListener(this);
    }

	@Override
	public void onClick(View v) {
		if(v.getId() == R.id.bWeb){
	        Uri uri = Uri.parse("http://www.google.com");
			Intent intent = new Intent(Intent.ACTION_VIEW, uri);
			startActivity( intent );
		} else if (v.getId() == R.id.bCall){
	        Intent intent = new Intent();
	        intent.setAction(Intent.ACTION_VIEW);
	        intent.setData(Uri.parse("tel:09024976871"));
			startActivity( intent );
		} else if (v.getId() == R.id.bCamera){
	        Intent intent = new Intent();
	        intent.setAction("android.media.action.IMAGE_CAPTURE");
			startActivityForResult(intent, 1);
		} else if (v.getId() == R.id.bActivity){
			Intent intent = new Intent( getApplicationContext(), CalledActivity.class );
			startActivity( intent );
		}
	}
}