package com.kekenzy.sports;

import java.util.List;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.ItemizedOverlay;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;
import com.google.android.maps.OverlayItem;
import com.google.android.maps.Projection;
import com.kekenzy.model.sqlite.biz.RunningDBManager;
import com.kekenzy.model.sqllite.helper.MapPosTB;

public class RunningMapActivity extends MapActivity {

	static final String TAG = "RunningMapActivity";

	private RunningDBManager mDb;
    private LocationOverlay mLocationOverlay = null;

	static final String INTENT_PARAM_LAT = "INTENT_PARAM_LAT";
	static final String INTENT_PARAM_LON = "INTENT_PARAM_LON";

	static final int INIT_LATITUDE = 35710058;
	static final int INIT_LONGITUDE = 139810718;
	static final int INITAL_ZOOM_LEVEL = 15;
    private static final int E6 = 1000000;

	double latitude;
	double longitude;

	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.map);

		latitude = getIntent().getDoubleExtra(RunningMapActivity.INTENT_PARAM_LAT,INIT_LATITUDE);
		longitude = getIntent().getDoubleExtra(RunningMapActivity.INTENT_PARAM_LON,INIT_LONGITUDE);

        Log.d(TAG,"latitude=" + latitude);
        Log.d(TAG,"longitude=" + longitude);

		MapView mapView = (MapView)findViewById(R.id.mapView);
		mapView.setEnabled(true);


		MapController controller = mapView.getController();
		int geoLat =  (int) (latitude * 1E6);
		int geoLon =  (int) (longitude * 1E6);

		GeoPoint point = new GeoPoint(geoLat,geoLon);
//		GeoPoint point = new GeoPoint(INIT_LATITUDE,INIT_LONGITUDE);
		controller.setCenter(point);
		controller.setZoom(INITAL_ZOOM_LEVEL);

		mDb = new RunningDBManager(getApplicationContext());

        Drawable pin = getResources().getDrawable(R.drawable.pin);
        pin.setBounds(0, 0, pin.getMinimumWidth(), pin.getMinimumHeight());
        mLocationOverlay = new LocationOverlay(pin);

        // 位置情報をマップに表示
        mLocationOverlay.reloadDB();
    }

//    private void setOverlay(GeoPoint point){
//
//    }

//	private void setOverlay(MapView mapView) {
//		Bitmap icon = BitmapFactory.decodeResource(getResources(),
//				R.drawable.pin);
//
//		IconOverlay overlay = new IconOverlay(icon, mapView);
//
//		List<Overlay> overlays = mapView.getOverlays();
//		overlays.add(overlay);
//
//	}

	@Override
	protected boolean isRouteDisplayed() {
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}

	// 地図上に表示するオーバレイ
/*	public class IconOverlay extends Overlay {
		Bitmap mIcon;
		int mOffsetX;
		int mOffsetY;

		GeoPoint mPoint;
		MapView mView;

		IconOverlay(Bitmap icon, MapView mapView) {
			mIcon = icon;
			mOffsetX = 0 - icon.getWidth() / 2;
			mOffsetY = 0 - icon.getHeight() / 2;
			mPoint = null;
			mView = mapView;

		}

		@Override
		public boolean onTap(GeoPoint geopoint, MapView mapview) {
			mPoint = geopoint;
			mView.getController().animateTo(mPoint);
			latitude = mPoint.getLatitudeE6() / 1E6;
			longitude = mPoint.getLongitudeE6() / 1E6;
//			setLocationNameFromGeo(latitude, longitude);
			return super.onTap(geopoint, mapview);
		}

		@Override
		public void draw(Canvas canvas, MapView mapview, boolean shadow) {
			super.draw(canvas, mapview, shadow);

			// タップ時は通常描画、陰描画の２回が呼ばれるので通常描画のみ更新
			if (!shadow && mPoint != null) {
				Projection projection = mapview.getProjection();
				Point point = new Point();
				projection.toPixels(mPoint, point);
				point.offset(mOffsetX, mOffsetY);

				canvas.drawBitmap(mIcon, point.x, point.y, null);
			}
		}

	}
*/
	   /**
     * マップ上に重ねるオーバーレイ
     */
    private class LocationOverlay extends ItemizedOverlay<OverlayItem> {

        private Drawable mIcon = null;
        private Cursor cursor = null;

        /**
         * ＤＢの再読み込み
         */
        public void reloadDB() {
            this.cursor = mDb.fetchAllMapPos();
            // 要素の再構築
            populate();
        }

        /**
         * コンストラクタ
         *
         * @param arg0
         */
        public LocationOverlay(Drawable arg0) {
            super(arg0);
            mIcon = arg0;
        }

        @Override
        public int size() {
            if (cursor == null)
                return 0;
            return cursor.getCount();
        }

        @Override
        protected OverlayItem createItem(int i) {
            if (cursor.moveToPosition(i)) {
            	MapPosTB tb = new MapPosTB();
                String title = String.valueOf(cursor.getLong(tb.id.getIndex()));
                String snippet = "";
                int latitudeE6 = (int) (cursor.getFloat(tb.latitude.getIndex()) * E6);
                int longitudeE6 = (int) (cursor.getFloat(tb.longitude.getIndex()) * E6);

                 OverlayItem item = new OverlayItem(new GeoPoint(latitudeE6, longitudeE6),
                        title,
                        snippet);
                item.setMarker(mIcon);

                return item;
            }

            Log.e(TAG, "overlay is null");
            return null;
        }

    }
}