package image_editor.toolbar;

import image_editor.DefaultMode;
import image_editor.EditorCanvas;
import image_editor.EraserMode;
import image_editor.PointMode;
//Kazuhiro 2007/10/1
import image_editor.FreeLineMode;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;


@SuppressWarnings("serial")

public class ImageEditorToolBar extends JToolBar{
	
	private EditorCanvas canvas;
	
	private JButton cutButton;
	private JButton pasteButton;
	
	private JButton selectButton;
	private JButton drawPointButton;
	
	//Kazuhiro 2007/10/1
	private JButton drawFreeLineButton;
	
	private JButton eraserButton;
	
	public ImageEditorToolBar(EditorCanvas canvas){
		super();
		this.canvas = canvas;
		
		this.cutButton = new JButton(new ImageIcon(this.getClass().getResource("img/cut.gif")));
		this.cutButton.addActionListener(new CutImageAction(this.canvas));
		
		this.pasteButton = new JButton("Paste");
		this.pasteButton.addActionListener(new PasteImageAction(this.canvas));
		
		this.selectButton = new JButton("Select");
		this.selectButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				ImageEditorToolBar.this.canvas.setMode(DefaultMode.getInstance());
			}
		});
		
		this.drawPointButton = new JButton("Point");
		this.drawPointButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				ImageEditorToolBar.this.canvas.setMode(PointMode.getInstance());
			}
		});
		
		//Kazuhiro 2007/10/1
		this.drawFreeLineButton = new JButton("Free Line");
		this.drawFreeLineButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				ImageEditorToolBar.this.canvas.setMode(FreeLineMode.getInstance());
				
			}
		});
		
		this.eraserButton = new JButton(new ImageIcon(this.getClass().getResource("img/delete.gif")));
		this.eraserButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				ImageEditorToolBar.this.canvas.setMode(EraserMode.getInstance());
			}
		});
		
		this.add(this.selectButton);
		this.add(this.cutButton);
		this.add(this.pasteButton);
		this.add(this.drawPointButton);
		
		//Kazuhiro 2007/10/1
		this.add(this.drawFreeLineButton);
		
		this.add(this.eraserButton);
	}
}
