package image_editor.toolbar;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public class SelectedRectangleView {
	
	private int x;
	private int y;
	private int width;
	private int height;
	
//	private double x, y, width, height;
	
	
	private Rectangle2D rect;
	
	public SelectedRectangleView(int x,int y,int width,int height){
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
		
		this.setRectangle();
	}
	
	public SelectedRectangleView(Point start, Point end) {
		int width, height;
		int startX, startY;
		
		if(start.getX() > end.getX()){
			startX = end.x;
			width = start.x - end.x;
		}
		else{
			startX = start.x;
			width = end.x - start.x;
		}
		if(start.getY() > end.getY()){
			startY = end.y;
			height = start.y - end.y;
		}
		else{
			startY = start.y;
			height= end.y - start.y;
		}
		this.x = startX;
		this.y = startY;
		this.width = width;
		this.height = height;
		
		
//		this.x = start.x;
//		this.y = start.y;
//		this.width = end.x-this.x;
//		this.height = end.y - this.y;
		this.setRectangle();
	}
	private void setRectangle(){
		this.rect = new Rectangle2D.Double((double)x,(double)y,(double)width,(double)height);
	}
	public void draw(Graphics2D g){
		g.draw(this.rect);
	}
	public int getX(){
		return this.x;
	}
	public int getY(){
		return this.y;
	}
	public int getWidth(){
		return this.width;
	}
	public int getHeight(){
		return this.height;
	}
	
}
