package smart_gs.dictionary;

import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.LineSegment;
import java.util.List;
import java.awt.geom.Rectangle2D;
import java.awt.Rectangle;
import java.awt.Polygon;

public class DictionaryRegion {
	protected Region region;
	protected String imageFile;
	
	public String getImageFile() {
		return imageFile;
	}
	public void setImageFile(String imageFile) {
		this.imageFile = imageFile;
	}
	public Region getRegion() {
		return region;
	}
	public void setRegion(Region region) {
		this.region = region;
	}
	//20100825 shimizu add
	public boolean isSearchable(){
		Region region = this.getRegion();
		Spread spread = region.getSpread();
		Rectangle rect = region.getRectangle();
		List<LineSegment> lines = spread.getLines();
		for(int i=0; i<lines.size();){
			Polygon polygon = lines.get(i).getPolygon();
			Rectangle r = polygon.getBounds();
			
			if(r.intersects(rect)||r.contains(rect)||rect.contains(r)){
				return true;
			}
			i++;
			
		}
		return false;
	}

	
}
