/*
 * 쐬: 2006/05/28
 *
 */
package smart_gs.drawing_tool;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

/**
 * @author kazuaki kobayashi
 *
 *  
 *  Line2D.Doublecontains\bhoverride
*/
public class ExLine2D extends Line2D.Double {
	
	private double criteria = 10.0;
	
	public ExLine2D(Point2D start, Point2D end) {
		super(start,end);
	}

	public ExLine2D(double x1, double y1, double x2, double y2) {
		super(x1,y1,x2,y2);
	}
	
	public ExLine2D(Point2D start,Point2D end,double criteria){
		super(start,end);
		this.criteria = criteria;
	}
	public ExLine2D(double x1, double y1, double x2, double y2,double criteria) {
		super(x1,y1,x2,y2);
		this.criteria = criteria;
	}
	public void setCriteria(double d){
		this.criteria = d;
	}
	public boolean contains(Point2D p) {
		double distance = this.ptSegDist(p);
		if(distance <= criteria){
			return true;
		}
		else{
			return false;
		}
	}
	public String toString() {
		Point2D start = this.getP1();
		Point2D end = this.getP2();
		String s = (int)start.getX()+" : "+(int)start.getY();
		String e = (int)end.getX()+" : "+(int)end.getY();
		return s+"\n"+e;
	}

}
