package smart_gs.drawing_tool.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import smart_gs.drawing_tool.ExLine2D;


public class MarkerView extends LineView{

	
	public MarkerView(Point2D start, Point2D end) {
		super(start, end);
		this.init();
	}
	public MarkerView(ExLine2D line){
		super(line);
		this.init();
	}
	public MarkerView(ExLine2D line,boolean isSelected,boolean isEmphasized, boolean isProtected){
		this(line);
		this.isSelected = isSelected;
		this.isEmphasized = isEmphasized;
		this.isProtected = isProtected;
	}
	private void init(){
		Color selectColor = Color.red;
		selectColor = new Color(selectColor.getRed(),selectColor.getGreen(),selectColor.getBlue(),128);
		this.setSelectionColor(selectColor);
		this.setSelectionStroke(new BasicStroke(15));
		
		Color protectedColor = new Color(50, 150, 100).brighter();
		protectedColor = new Color(protectedColor.getRed(),protectedColor.getGreen(),protectedColor.getBlue(),128);
		this.setProtectedColor(protectedColor);
		this.setProtectedStroke(new BasicStroke(15));
		
		Color yellow = Color.YELLOW.brighter();
		this.defaultColor = new Color(yellow.getRed(),yellow.getGreen(),yellow.getBlue(),128);
		this.defaultStroke = new BasicStroke(15);
	}
	@Override
	public int getType() {
		return View.MARKER;
	}
	@Override
	public View enlargedView(double ratio, double gapX, double gapY) {
		Point2D start = this.line.getP1();
		Point2D end = this.line.getP2();
		Point2D p1 = new Point2D.Double(start.getX()*ratio+gapX,start.getY()*ratio+gapY);
		Point2D p2 = new Point2D.Double(end.getX()*ratio+gapX,end.getY()*ratio+gapY);
		return new MarkerView(new ExLine2D(p1,p2),this.isSelected,this.isEmphasized, this.isProtected);
	}
	@Override
	public String getTypeString() {
		return "marker";
	}
	@Override
	public Element createXMLElement(Document document) {
		Element element = document.createElement("view");
		element.setAttribute("type","marker");
		element.setAttribute("x1",this.line.x1+"");
		element.setAttribute("y1",this.line.y1+"");
		element.setAttribute("x2",this.line.x2+"");
		element.setAttribute("y2",this.line.y2+"");		
		return element;
	}
	@Override
	public void drawLinkedShape(Graphics2D g) {
		if(this.isSelected){
			this.draw(g);
			return;
		};
		Color oldColor = g.getColor();
		Stroke oldStroke = g.getStroke();
		g.setStroke(new BasicStroke(15));
		g.setColor(this.defaultColor);
		g.draw(this.line);
		g.setColor(oldColor);
		g.setStroke(oldStroke);
	}
	public static MarkerView restore(Element elem) {
		double x1 = new Double(elem.getAttribute("x1"));
		double y1 = new Double(elem.getAttribute("y1"));
		double x2 = new Double(elem.getAttribute("x2"));
		double y2 = new Double(elem.getAttribute("y2"));
		return new MarkerView(new ExLine2D(x1,y1,x2,y2));
	}
	@Override
	public Rectangle2D getRectangle2D() {
		double x1 = this.getMinX();
		double x2 = this.getMaxX();
		double y1 = this.getMinY();
		double y2 = this.getMaxY();
		double width = ((BasicStroke)this.defaultStroke).getLineWidth();
		return new Rectangle2D.Double(x1-1,y1-25,(x2-x1),y2-y1+width+50);
	}
}
