package smart_gs.logical;

import java.util.ArrayList;
import java.util.List;

import smart_gs.logical.visitor.Visitor;


public class Note extends GSResource{
	
	public static final String NOTE = "note";
	
	private List<Region> regions;
	
	public Note(){
		super("");
		this.regions = new ArrayList<Region>();
		int id = this.hashCode();
		this.name = ""+id;
		this.setURI("SMART://note/"+this.name);
		this.setId(id);
	}
	public Note(String uri) {
		super(uri);
		this.regions = new ArrayList<Region>();
		this.id = this.hashCode();
	}
	
	public void addRegion(Region region){
		this.regions.add(region);
	}
	
	public List<Region> getRegions(){
		return this.regions;
	}

	@Override
	public String toString() {
		return this.name;
	}

	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
}
