package smart_gs.logical;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@SuppressWarnings("serial")
public class NoteTree extends JTree{
	
	private static NoteTree singleton = new NoteTree();

	private Note previousNote;  //Oɍꂽm[g
	private List<Note> notes;
	
	private NoteTree(){
		super(new DefaultMutableTreeNode("root"));
		this.notes = new ArrayList<Note>();
	}
	public static NoteTree getInstance(){
		return singleton;
	}
	public void addRegionToPreviousNote(Region region){
		if(previousNote == null){
			return;
		}
		
		previousNote.addRegion(region);
	}
	public void addNote(Note note){
		this.notes.add(note);
		((DefaultMutableTreeNode)((DefaultTreeModel)this.getModel()).getRoot()).add(new DefaultMutableTreeNode(note));
		((DefaultTreeModel)this.getModel()).reload();
		
		this.previousNote = note;
	}
	public List<Note> getNotes(){
		return this.notes;
	}
	public Note getSelectedNote(){
		TreePath path = this.getSelectionModel().getSelectionPath();
		if(path == null){
			return null;
		}
		Object selectedObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
		if(selectedObject instanceof Note){
			return (Note)selectedObject;
		}
		return null;
	}
	public void save(Document document,Element parent) {
		Element element = document.createElement("noteTree");
		for(int i=0;i<this.notes.size();i++){
			element.appendChild(this.notes.get(i).createXMLElement(document));
			
		}
		parent.appendChild(element);
	}
	public void restore(Element noteElement) {
		this.notes.clear();
		NodeList elements = noteElement.getElementsByTagName("note");
		for(int i=0;i<elements.getLength();i++){
			Note note = XML2ResourceConverter.getNote((Element)elements.item(i));
			this.addNote(note);
		}
		
	}
	public Note getNoteByURI(String uri) {
		for(int i=0;i<this.notes.size();i++){
			if(this.notes.get(i).getURI().equals(uri)){
				return this.notes.get(i);
			}
		}
		return null;
	}
}
