package smart_gs.reasoning_web.desktop.swingui;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;

import javax.swing.JPanel;

import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;
import smart_gs.reasoning_web.desktop.logical.ShortCut;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;

@SuppressWarnings("serial")
public class FolderPanel extends JPanel implements MouseListener,MouseMotionListener,Observable{
	
	private DeskTopFolder folder;
	
	private DesktopElement selectedElement;
	
	private Point start;
	private Point end;
		
	public FolderPanel(DeskTopFolder folder) {
		this.folder = folder;
		this.folder.addObserver(this);
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
	//	this.setLayout(null);
		this.notifyChange();
	}
	public DeskTopFolder getFolder(){
		return this.folder;
	}
	public void mouseClicked(MouseEvent e) {
		if(e.getClickCount() == 2){
			DesktopElement element = this.getElement(e.getPoint());
			if(element == null){
				return;
			}
			element.open();
		}
	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseExited(MouseEvent e) {
	}
	
	private DesktopElement getElement(Point point){
		List<DesktopElement> shortcuts = this.folder.getAllElements();
		for(int i=0;i<shortcuts.size();i++){
			if(shortcuts.get(i).getView().contains(point)){
				return shortcuts.get(i);
			}
		}
		return null;
	}
	public void mousePressed(MouseEvent e) {
		if(e.getButton() == MouseEvent.BUTTON3){
			//menu̕\
			
			new RightClickPopupMenu(this.folder).show(this,e.getPoint().x,e.getPoint().y);
			this.repaint();
			return;
		}
		this.start = e.getPoint();
		List<DesktopElement> shortcuts = folder.getAllElements();
		for(int i=0;i<shortcuts.size();i++){
			if(shortcuts.get(i).getView().contains(e.getPoint())){
				this.selectedElement = shortcuts.get(i);
				ReasoningWebFrame.getInstance().getDesktopPanel().setSelectedElement(this.selectedElement);
			}
		}
		this.repaint();
	}

	public void mouseReleased(MouseEvent e) {
		if(this.selectedElement != null && this.selectedElement instanceof ShortCut){
			DeskTopFolder container = this.folder.getFolder(e.getPoint());
		    if(container != null){
		    	container.add(this.selectedElement);
		    	this.folder.remove(this.selectedElement);
		    }
		}
		
		this.selectedElement = null;
		this.start = null;
		this.end = null;
		this.repaint();
	}

	public void mouseDragged(MouseEvent e) {
		if(this.selectedElement == null){
			return;
		}
		
		this.end = e.getPoint();
		Point p = new Point(this.end.x-this.start.x,this.end.y-this.start.y);
		this.selectedElement.getView().moveBy(p);
		this.start = this.end;
		this.repaint();
	}

	public void mouseMoved(MouseEvent e) {		
	}
	
	public void notifyChange() {
		this.removeAll();
		List<DesktopElement> shortcuts = this.folder.getAllElements();
		for(int i=0;i<shortcuts.size();i++){
			this.add(shortcuts.get(i).getView().getLabel(),null);
		}
		this.repaint();
	}	
}
