package smart_gs.reasoning_web.swingui.view;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.*;
import java.util.ArrayList;
import java.util.List;


public abstract class View {

	protected final int MARKER_SIZE=4;	/*Ĩ}[J[TCY*/
	
	protected boolean isSelected;
	
	protected Color defaultColor;
	protected Color currentColor;
	
	private static List<View> selectedViews;
	
	static{
		selectedViews = new ArrayList<View>();
	}
	/**
	 * Graphics2D graphicsɂview`܂B
	 * @param graphics
	 */
	public abstract void drawShape(Graphics2D g);
	
	//2007/11/2 kazuhiro kobayashi
	//̕`
	public void drawTranslucentShape(Graphics2D g){
		g.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER,0.3f));
		this.drawShape(g);
	}
	
	/**
	 * view𑊑΋dړ܂B
	 * @param d
	 */
	public abstract void moveBy(Point2D d);
	
	public abstract boolean contains(Point2D point);
	
	//2007/10/22 kazuhiro kobayashi
	public abstract Rectangle2D getRectangle();
	public abstract void setRectangle(double x, double y, double w, double h);
	public abstract void setRectangle(double x, double y);
	
	/**
	 * ̃CX^X̏Ԃ܂B
	 * (System.out.println()ȂǂŃfobOƂɎg܂)
	 */
	public abstract String toString();

	/**
	 * IꂽƂ}[J[\܂B
	 * @param p
	 * @param g
	 */
	protected void setMarker(Graphics2D g,Point2D p){
		g.fill(new Rectangle2D.Double(
						p.getX(),
						p.getY(),
						MARKER_SIZE,
						MARKER_SIZE));
	}
	
	public void setIsSelected(boolean isSelected){
		this.isSelected = isSelected;
		if(this.isSelected){
			selectedViews.add(this);
		}else{
			selectedViews.remove(this);
		}
	}
	public static void clearSelection(){
		for(int i=0;i<selectedViews.size();i++){
			selectedViews.get(i).setIsSelected(false);
		}
	}
	public boolean isSelected(){
		return this.isSelected;
	}
	public void setDrawColor(Color color){
		this.currentColor = color;
	}
	public void restoreDefaultColor(){
		this.currentColor = this.defaultColor;
	}

}
