package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class ButtonDialog extends JDialog implements ActionListener{
	protected JButton okButton;
	protected JButton cancelButton;
	private JPanel buttonPanel;
	private boolean isCanceled = true;
 ButtonDialog(String title) {
		this(new JFrame(),title);
	}
	public ButtonDialog(Frame parent,String title){
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		this.getContentPane().setLayout(new BorderLayout());
		this.buttonPanel = new JPanel();
		this.okButton = new JButton("OK");
		this.okButton.addActionListener(this);

		this.cancelButton = new JButton("Cancel");
		this.cancelButton.addActionListener(this);
		this.buttonPanel.add(this.okButton);
		this.buttonPanel.add(this.cancelButton);
		
		this.getContentPane().add(this.buttonPanel,BorderLayout.SOUTH);
	}
	public boolean isCanceled(){
		return this.isCanceled;
	}

	public JPanel getButtonPanel(){
		return this.buttonPanel;
	}

	public abstract void ok();
	public abstract void cancel();
	
	public void actionPerformed(ActionEvent e) {
		if(e.getSource().equals(this.okButton)){
			this.isCanceled = false;
			this.ok();
		}else if(e.getSource().equals(this.cancelButton)){
			this.isCanceled = true;
			this.cancel();
		}
		
	}
}
