package smart_gs.swingui;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;

import smart_gs.smleditor.swingui.GSTabbedPane;


public class GSTabbedPaneMamager {
	protected static HashMap<String, GSTabbedPaneMamagerContainer> gsTabbedPaneMap = new HashMap<String,  GSTabbedPaneMamagerContainer>();
	protected static HashMap<String, String> windowMap = new HashMap<String,  String>();
	protected static AtomicLong id = new AtomicLong();
	
	public static void setGSTabbedPane(String key,String windowid,GSTabbedPane gsTabbedPane){
		synchronized (gsTabbedPaneMap) {
			GSTabbedPaneMamagerContainer mangaerContainer = new GSTabbedPaneMamagerContainer(key,windowid,gsTabbedPane);
			gsTabbedPaneMap.put(key, mangaerContainer);
			if(!windowMap.containsKey(windowid)){
				windowMap.put(windowid,key);
			}
		}
	}
	public static void removeGSTabbedPane(String key){
		synchronized (gsTabbedPaneMap) {
			gsTabbedPaneMap.remove(key);
		}
	}
	public static GSTabbedPane getGSTabbedPane(String key){
		GSTabbedPaneMamagerContainer gsTabbedPaneMamagerContainer = gsTabbedPaneMap.get(key);
		if(gsTabbedPaneMamagerContainer == null){
			return null;
		}
		return gsTabbedPaneMamagerContainer.getGsTabbedPane();
	}
	
	public static String getWindowsID(String key){
		GSTabbedPaneMamagerContainer gsTabbedPaneMamagerContainer = gsTabbedPaneMap.get(key);
		return gsTabbedPaneMamagerContainer.getWindowid();
	}
	
	
	public static long getControlid(){
		return id.incrementAndGet();
	}

	public static void close(String windowid){
		synchronized (windowMap) {
			String key = windowMap.get(windowid);
			windowMap.remove(windowid);
			// JĂWindow݂Ȃ
			if(!windowMap.containsValue(key)){
				synchronized (gsTabbedPaneMap) {
					gsTabbedPaneMap.remove(key);
				}
			}
			
		}
	}
}
