/*
 * 쐬: 2006/06/18
 *
 */
package smart_gs.connection;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.RegionNotify;
import smart_gs.drawing_tool.state.RegionSelectionState;
import smart_gs.logical.GSResource;
import smart_gs.logical.Region;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.util.ResourceNotify;
import smart_gs.util.ResourceSelectionMode;
import sml_editor.swingui.EditorMouseListener;

/**
 * @author kazuaki kobayashi
 *
 * 
*/
@SuppressWarnings("serial")
public class CreateLinkDialog extends JDialog implements ActionListener,ResourceNotify,RegionNotify, CaretListener{
	
	private final int SOURCE = 0;
	private final int TARGET = 1;
	
	private final int TEXT_LENGTH = 20;
	private JTextField sourceField;
	private JTextField targetField;
	private JButton sourceSelect;
	private JButton targetSelect;
	
	private JPanel mainPanel;
	private JPanel sourcePanel;
	private JPanel targetPanel;
	
	private JTextField selectedField;
	
	private int selectedButtonType;
	
	private GSResource source;
	private GSResource target;
	
	private JButton ok;
	private JPanel buttonPanel;
	
	public CreateLinkDialog(AbstractGSWindow parent){
		super(parent.getFrame(),"Link Dialog");
		this.toFront();
		this.getContentPane().setLayout(new BorderLayout());
		
		this.mainPanel = new JPanel(new GridLayout(2,1));
		mainPanel.add(this.createSourcePanel());
		mainPanel.add(this.createTargetPanel());
		
		this.getContentPane().add(mainPanel,BorderLayout.CENTER);
		this.getContentPane().add(this.createButtonPanel(),BorderLayout.SOUTH);
		this.pack();
		this.setResizable(false);
		
	}
	private JPanel createButtonPanel(){
		this.buttonPanel = new JPanel();
		this.ok = new JButton("OK");
		this.ok.setEnabled(false);
		this.ok.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				ok();
			}
		});
		this.buttonPanel.add(this.ok);
		
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		});
		this.buttonPanel.add(cancel);
		return this.buttonPanel;
		
	}
	private JPanel createSourcePanel(){
		this.sourcePanel = new JPanel(new GridLayout(2,1));
		
		JPanel p1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		this.sourceField = new JTextField(TEXT_LENGTH);
		this.sourceField.addCaretListener(this);
		JButton reference = new JButton("reference");
		//check
		reference.setEnabled(false);
		p1.add(this.sourceField);
		p1.add(reference);
		
		JPanel p2 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		this.sourceSelect = new JButton("select by click");
		this.sourceSelect.addActionListener(this);
		p2.add(this.sourceSelect);
		
		this.sourcePanel.add(p1);
		this.sourcePanel.add(p2);
		
		this.sourcePanel.setBorder(new TitledBorder("Source"));
		return this.sourcePanel;
	}
	private JPanel createTargetPanel(){
		this.targetPanel = new JPanel(new GridLayout(2,1));
		
		JPanel p1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		this.targetField = new JTextField(TEXT_LENGTH);
		this.targetField.addCaretListener(this);
		JButton reference = new JButton("reference");
		reference.setEnabled(false);
		p1.add(this.targetField);
		p1.add(reference);
		
		JPanel p2 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		this.targetSelect = new JButton("select by click");
		this.targetSelect.addActionListener(this);
		p2.add(targetSelect);
		
		this.targetPanel.add(p1);
		this.targetPanel.add(p2);
		this.targetPanel.setBorder(new TitledBorder("Target"));
		return this.targetPanel;
	}
	
	private void select(){
		JPanel panel = new JPanel();
		this.selectedField = new JTextField(TEXT_LENGTH);
		panel.add(this.selectedField);
		JButton restore = new JButton("OK");
		restore.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				restore();
			}
		});
		panel.add(restore);
		
		this.getContentPane().removeAll();
		this.getContentPane().add(panel);
		this.pack();
		this.validate();
	}
	private void restore(){
		this.getContentPane().removeAll();
		DefaultState.restoreDefaultState();
		EditorMouseListener.restoreDefaultMouseMode();

		
		this.getContentPane().add(this.mainPanel,BorderLayout.CENTER);
		this.getContentPane().add(this.buttonPanel,BorderLayout.SOUTH);
		this.pack();
		this.validate();
	}
	public void notifyResourceSelection(GSResource resource) {
		this.selectedField.setText(resource.getURI());
		this.getSelectedTextField().setText(resource.getURI());
		if(this.selectedButtonType == SOURCE){
			this.source = resource;
		}else{
			this.target = resource;
		}
	}
	private JTextField getSelectedTextField(){
		if(this.selectedButtonType == SOURCE){
			return this.sourceField;
		}else{
			return this.targetField;
		}
	}
	public void actionPerformed(ActionEvent e) {
		if(e.getSource().equals(this.sourceSelect)){
			this.selectedButtonType = SOURCE;
			ResourceSelectionMode listener = ResourceSelectionMode.getInstance();
			DefaultState.setDefaultState(RegionSelectionState.getInstance());
			((RegionSelectionState)RegionSelectionState.getInstance()).addNotifyElement(this);
			listener.addNotifyElement(this);
			EditorMouseListener.setMouseMode(listener);
			this.select();
		}else if(e.getSource().equals(this.targetSelect)){
			this.selectedButtonType = TARGET;
			ResourceSelectionMode listener = ResourceSelectionMode.getInstance();
			DefaultState.setDefaultState(RegionSelectionState.getInstance());
			((RegionSelectionState)RegionSelectionState.getInstance()).addNotifyElement(this);
			listener.addNotifyElement(this);
			EditorMouseListener.setMouseMode(listener);
			this.select();
		}else{
			
		}
	}
	public void notifyRegionSelection(Region region) {
		this.notifyResourceSelection(region);
	}
	public void caretUpdate(CaretEvent e) {
		if(!this.sourceField.getText().trim().equals("") && !this.targetField.getText().trim().equals("")){
			this.ok.setEnabled(true);
		}else{
			this.ok.setEnabled(false);
		}
	}
	
	private void ok(){
		this.dispose();
		ConnectionCreator.setSource(this.source);
		ConnectionCreator.setTarget(this.target);
	}
}
