package smart_gs.drawing_tool.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.drawing_tool.ExLine2D;


public class FreeLineView extends View{
	
	private List<LineView> lines;
	
	public FreeLineView(){
		this.lines = new ArrayList<LineView>();
		this.defaultColor = Color.BLUE;
		this.selectionColor = Color.red;
	}
	public FreeLineView(List<ExLine2D> exLines){
		super();
		this.lines = new ArrayList<LineView>();
		for(int i=0;i<exLines.size();i++){
			this.lines.add(new LineView(exLines.get(i)));
		}
		this.defaultColor = Color.BLUE;
		this.selectionColor = Color.red;
	}
	
	public FreeLineView(List<ExLine2D> lines,boolean isSelected,boolean isEmphasized, boolean isProtected) {
		this(lines);
		this.isSelected = isSelected;
		this.isEmphasized = isEmphasized;
//		this.defaultColor = Color.BLUE;
//		this.selectionColor = Color.red;
		this.isProtected = isProtected;
	}

	@Override
	public boolean contains(Point2D point) {
		for(int i=0;i<this.lines.size();i++){
			boolean contains = this.lines.get(i).contains(point);
			if(contains){
				return true;
			}
		}
		return false;
	}
	public void addLineView(LineView line){
		this.lines.add(line);
	}
	@Override
	public void drawShape(Graphics2D g) {
		for(int i=0;i<this.lines.size();i++){
			this.lines.get(i).drawShape(g);
		}
	}

	@Override
	public int getType() {
		return View.LASSO;
	}

	@Override
	public void moveBy(Point2D d) {
		for(int i=0;i<this.lines.size();i++){
			this.lines.get(i).moveBy(d);
		}
	}

	@Override
	public View enlargedView(double ratio, double gapX, double gapY) {
		List<ExLine2D> newLines = new ArrayList<ExLine2D>();
		for(int i=0;i<this.lines.size();i++){
			LineView line = this.lines.get(i);
			line = (LineView)line.enlargedView(ratio,gapX,gapY);
			newLines.add(line.getLine());
		}
		return new FreeLineView(newLines,this.isSelected,this.isEmphasized, this.isProtected);
	}
	@Override
	public Rectangle2D getRectangle2D() {
		LineView line1 = this.lines.get(0);
		double minX = line1.getMinX(),minY = line1.getMinY(),maxX = line1.getMaxX(),maxY = line1.getMaxY(); 
		for(int i=0;i<this.lines.size();i++){
			LineView line = this.lines.get(i);
			if(minX > line.getMinX() || minX == -1){
				minX = line.getMinX();
			}
			if(minY > line.getMinY() || minX == -1){
				minY = line.getMinY();
			}
			if(maxX < line.getMaxX() || minX == -1){
				maxX = line.getMaxX();
			}
			if(maxY < line.getMaxY() || minX == -1){
				maxY = line.getMaxY();
			}
		}
		
		return new Rectangle2D.Double(minX,minY,maxX-minX,maxY-minY);
	}
	@Override
	public String getTypeString() {
		return "lasso";
	}
	@Override
	public void drawLinkedShape(Graphics2D g) {
		if(this.isSelected){
			this.draw(g);
			return;
		};
		for(int i=0;i<this.lines.size();i++){
			this.lines.get(i).drawLinkedShape(g);
		}
	}
	@Override
	public Element createXMLElement(Document document) {
		Element element = document.createElement("view");
		element.setAttribute("type","lasso");
		for(int i=0;i<this.lines.size();i++){
			element.appendChild(this.lines.get(i).createXMLElement(document));
		}
		return element;
	}

	public static FreeLineView restore(Element element) {
		FreeLineView view = new FreeLineView();
		NodeList nodes = element.getChildNodes();

		for(int i=0;i<nodes.getLength();i++){
			if(nodes.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)nodes.item(i);
				String tagname = elem.getNodeName();
				if(tagname.equals("view")){
					LineView line = LineView.restore(elem);
					view.addLineView(line);
				}
			}
		}
		return view;
	}
}
