package smart_gs.image_search.research.swingui;


import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.research.RESearch;
import smart_gs.image_search.research.SearchResultSet;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.util.RegionSelectionDialog;

@SuppressWarnings("serial")
public class REImageSearchDialog extends RegionSelectionDialog{
	
	private JRadioButton all;
	private JRadioButton currentDirectory;
	
	private JRadioButton spreadButton;
	private JRadioButton lineButton;
	
	private JTextField lineField;
	/*
	 * spread̎ŵ߂ɒǉ
	 */
	private JRadioButton selectSpread;
	private JTextField pageSelectField;
	
	public REImageSearchDialog(GSEditorFrame parent) {
		super(parent);
		this.addRegionButton.setText("add Query");
		parent.getFrame().setTitle("Search Dialog");
		this.lineField = new JTextField(2);
		JPanel panel = new JPanel(new GridLayout(2,1));
		
		JPanel rePanel = new JPanel(new GridLayout(2,1));
		JPanel linePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		this.spreadButton = new JRadioButton("spread");
		this.spreadButton.setSelected(true);
		this.lineButton = new JRadioButton("line");
		ButtonGroup reGroup = new ButtonGroup();
		reGroup.add(this.spreadButton);
		reGroup.add(this.lineButton);
		rePanel.add(this.spreadButton);
		linePanel.add(this.lineButton);
		linePanel.add(this.lineField);
		rePanel.add(linePanel);
		
		JPanel scopePanel = new JPanel(new GridLayout(4,1));
		scopePanel.setBorder(new TitledBorder("scope to search"));
		this.all = new JRadioButton("All Spreads");
		this.all.setSelected(true);
		this.currentDirectory = new JRadioButton("Current Directory");
		
		/*
		 * spreadI
		 */
		this.selectSpread = new JRadioButton("Select Spread");
		this.pageSelectField = new JTextField(10);
		
		ButtonGroup group = new ButtonGroup();
		group.add(this.all);
		group.add(this.currentDirectory);
		group.add(this.selectSpread);
		scopePanel.add(all);
		scopePanel.add(currentDirectory);
		scopePanel.add(pageSelectField);
		
		panel.add(rePanel);
		panel.add(scopePanel);
		this.southPanel.add(panel,BorderLayout.CENTER);
		
		this.setSize(400,500);
	}
	
	public boolean isLineSelected(){
		return this.lineButton.isSelected();
	}
	public int getLineNumber(){
		return new Integer(this.lineField.getText());
	}
	private List<Spread> getSpreadsToSearch(){
		if(this.all.isSelected()){
			return SpreadTree.getInstance().getSpreads();
		}
		else if(this.currentDirectory.isSelected()){
			return SpreadTree.getInstance().getCurrentDirectory().getSpreads();
		}
		return null;
	}
	@Override
	protected void ok() {
		super.ok();
		List<GSQuery> queries = new ArrayList<GSQuery>();
		for(int i=0;i<this.regions.size();i++){
			Region region = this.regions.get(i);
			Spread spread = region.getSpread();
			Rectangle rect = region.getView().getRectangle();
			GSQuery query = new GSQuery(spread,spread.getDscFile(),rect);
			queries.add(query);
		}
		List<Spread> spreads = getSpreadsToSearch();
		List<Spread> spreadsToSearch = new ArrayList<Spread>();
		for(int i=0;i<spreads.size();i++){
			if(spreads.get(i).hasDscFile()){
				spreadsToSearch.add(spreads.get(i));
			}
		}		
		RESearch searcher = new RESearch(this,queries,spreadsToSearch);
		searcher.execute();
		
		List<SearchResultSet> results = searcher.getResults();
		
		new RESearchResultViewer(queries,results).setVisible(true);
	}
	
	
}
